/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.expression.Expression;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.integration.support.management.CounterFacade;
import org.springframework.integration.support.management.IntegrationManagedResource;
import org.springframework.integration.support.management.IntegrationManagement;
import org.springframework.integration.support.management.MessageSourceMetrics;
import org.springframework.integration.support.management.MetricsCaptor;
import org.springframework.integration.util.AbstractExpressionEvaluator;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.CollectionUtils;

@IntegrationManagedResource
public abstract class AbstractMessageSource<T>
extends AbstractExpressionEvaluator
implements MessageSource<T>,
MessageSourceMetrics,
NamedComponent,
BeanNameAware {
    private final AtomicLong messageCount = new AtomicLong();
    private final IntegrationManagement.ManagementOverrides managementOverrides = new IntegrationManagement.ManagementOverrides();
    private volatile Map<String, Expression> headerExpressions = Collections.emptyMap();
    private String beanName;
    private String managedType;
    private String managedName;
    private volatile boolean countsEnabled;
    private volatile boolean loggingEnabled = true;
    private MetricsCaptor metricsCaptor;
    private CounterFacade receiveCounter;

    public void setHeaderExpressions(Map<String, Expression> headerExpressions) {
        this.headerExpressions = headerExpressions != null ? headerExpressions : Collections.emptyMap();
    }

    @Override
    public void registerMetricsCaptor(MetricsCaptor metricsCaptor) {
        this.metricsCaptor = metricsCaptor;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    @Override
    public void setManagedType(String managedType) {
        this.managedType = managedType;
    }

    @Override
    public String getManagedType() {
        return this.managedType;
    }

    @Override
    public void setManagedName(String managedName) {
        this.managedName = managedName;
    }

    @Override
    public String getManagedName() {
        return this.managedName;
    }

    @Override
    public String getComponentName() {
        return this.beanName;
    }

    @Override
    public boolean isCountsEnabled() {
        return this.countsEnabled;
    }

    @Override
    public void setCountsEnabled(boolean countsEnabled) {
        this.countsEnabled = countsEnabled;
        this.managementOverrides.countsConfigured = true;
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    @Override
    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
        this.managementOverrides.loggingConfigured = true;
    }

    @Override
    public void reset() {
        this.messageCount.set(0L);
    }

    @Override
    public int getMessageCount() {
        return (int)this.messageCount.get();
    }

    @Override
    public long getMessageCountLong() {
        return this.messageCount.get();
    }

    @Override
    public IntegrationManagement.ManagementOverrides getOverrides() {
        return this.managementOverrides;
    }

    @Override
    public final Message<T> receive() {
        return this.buildMessage(this.doReceive());
    }

    protected Message<T> buildMessage(Object result) {
        Object message = null;
        Map<String, Object> headers = this.evaluateHeaders();
        if (result instanceof AbstractIntegrationMessageBuilder) {
            if (!CollectionUtils.isEmpty(headers)) {
                ((AbstractIntegrationMessageBuilder)result).copyHeaders(headers);
            }
            message = ((AbstractIntegrationMessageBuilder)result).build();
        } else if (result instanceof Message) {
            try {
                message = (Message<Object>)result;
            }
            catch (Exception e) {
                throw new MessagingException("MessageSource returned unexpected type.", (Throwable)e);
            }
            if (!CollectionUtils.isEmpty(headers)) {
                message = this.getMessageBuilderFactory().fromMessage(message).copyHeaders(headers).build();
            }
        } else if (result != null) {
            Object payload;
            try {
                payload = result;
            }
            catch (Exception e) {
                throw new MessagingException("MessageSource returned unexpected type.", (Throwable)e);
            }
            message = this.getMessageBuilderFactory().withPayload(payload).copyHeaders(headers).build();
        }
        if (this.countsEnabled && message != null) {
            if (this.metricsCaptor != null) {
                this.incrementReceiveCounter();
            }
            this.messageCount.incrementAndGet();
        }
        return message;
    }

    private void incrementReceiveCounter() {
        if (this.receiveCounter == null) {
            this.receiveCounter = this.metricsCaptor.counterBuilder("spring.integration.receive").tag("name", this.getComponentName() == null ? "unknown" : this.getComponentName()).tag("type", "source").tag("result", "success").tag("exception", "none").description("Messages received").build();
        }
        this.receiveCounter.increment();
    }

    private Map<String, Object> evaluateHeaders() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (Map.Entry<String, Expression> entry : this.headerExpressions.entrySet()) {
            Object headerValue = this.evaluateExpression(entry.getValue());
            if (headerValue == null) continue;
            results.put(entry.getKey(), headerValue);
        }
        return results;
    }

    protected abstract Object doReceive();
}

