/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.dispatcher.AggregateMessageDeliveryException;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class LoggingHandler
extends AbstractMessageHandler {
    private volatile Level level;
    private volatile boolean expressionSet;
    private volatile Expression expression = EXPRESSION_PARSER.parseExpression("payload");
    private volatile EvaluationContext evaluationContext = ExpressionUtils.createStandardEvaluationContext();
    private volatile boolean shouldLogFullMessageSet;
    private volatile Log messageLogger = this.logger;

    public LoggingHandler(String level) {
        this(LoggingHandler.convertLevel(level));
    }

    private static Level convertLevel(String level) {
        Assert.hasText((String)level, (String)"'level' cannot be empty");
        try {
            return Level.valueOf(level.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid log level '" + level + "'. The (case-insensitive) supported values are: " + StringUtils.arrayToCommaDelimitedString((Object[])Level.values()));
        }
    }

    public LoggingHandler(Level level) {
        this.doSetLevel(level);
    }

    public void setLogExpressionString(String expressionString) {
        Assert.hasText((String)expressionString, (String)"'expressionString' must not be empty");
        this.setLogExpression(EXPRESSION_PARSER.parseExpression(expressionString));
    }

    public void setLogExpression(Expression expression) {
        Assert.isTrue((!this.shouldLogFullMessageSet ? 1 : 0) != 0, (String)"Cannot set both 'expression' AND 'shouldLogFullMessage' properties");
        this.expressionSet = true;
        this.expression = expression;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.doSetLevel(level);
    }

    private void doSetLevel(Level level) {
        Assert.notNull((Object)((Object)level), (String)"'level' cannot be null");
        this.level = level;
    }

    public void setLoggerName(String loggerName) {
        Assert.hasText((String)loggerName, (String)"loggerName must not be empty");
        this.messageLogger = LogFactory.getLog((String)loggerName);
    }

    public void setShouldLogFullMessage(boolean shouldLogFullMessage) {
        Assert.isTrue((!this.expressionSet ? 1 : 0) != 0, (String)"Cannot set both 'expression' AND 'shouldLogFullMessage' properties");
        this.shouldLogFullMessageSet = true;
        this.expression = shouldLogFullMessage ? EXPRESSION_PARSER.parseExpression("#root") : EXPRESSION_PARSER.parseExpression("payload");
    }

    @Override
    public String getComponentType() {
        return "logging-channel-adapter";
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext(this.getBeanFactory());
    }

    @Override
    protected void handleMessageInternal(Message<?> message) throws Exception {
        switch (this.level) {
            case FATAL: {
                if (!this.messageLogger.isFatalEnabled()) break;
                this.messageLogger.fatal(this.createLogMessage(message));
                break;
            }
            case ERROR: {
                if (!this.messageLogger.isErrorEnabled()) break;
                this.messageLogger.error(this.createLogMessage(message));
                break;
            }
            case WARN: {
                if (!this.messageLogger.isWarnEnabled()) break;
                this.messageLogger.warn(this.createLogMessage(message));
                break;
            }
            case INFO: {
                if (!this.messageLogger.isInfoEnabled()) break;
                this.messageLogger.info(this.createLogMessage(message));
                break;
            }
            case DEBUG: {
                if (!this.messageLogger.isDebugEnabled()) break;
                this.messageLogger.debug(this.createLogMessage(message));
                break;
            }
            case TRACE: {
                if (!this.messageLogger.isTraceEnabled()) break;
                this.messageLogger.trace(this.createLogMessage(message));
                break;
            }
            default: {
                throw new IllegalStateException("Level '" + (Object)((Object)this.level) + "' is not supported");
            }
        }
    }

    private Object createLogMessage(Message<?> message) {
        Object logMessage = this.expression.getValue(this.evaluationContext, message);
        return logMessage instanceof Throwable ? this.createLogMessage((Throwable)logMessage) : logMessage;
    }

    private String createLogMessage(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        if (throwable instanceof AggregateMessageDeliveryException) {
            stringWriter.append(throwable.getMessage());
            for (Exception exception : ((AggregateMessageDeliveryException)((Object)throwable)).getAggregatedExceptions()) {
                this.printStackTrace(exception, stringWriter);
            }
        } else {
            this.printStackTrace(throwable, stringWriter);
        }
        return stringWriter.toString();
    }

    private void printStackTrace(Throwable throwable, Writer writer) {
        throwable.printStackTrace(new PrintWriter(writer, true));
    }

    public static enum Level {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

