/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.management;

import org.springframework.integration.support.management.DefaultMessageChannelMetrics;
import org.springframework.integration.support.management.ExponentialMovingAverage;
import org.springframework.integration.support.management.ExponentialMovingAverageRate;
import org.springframework.integration.support.management.ExponentialMovingAverageRatio;
import org.springframework.integration.support.management.MetricsContext;

public class AggregatingMessageChannelMetrics
extends DefaultMessageChannelMetrics {
    private static final int DEFAULT_SAMPLE_SIZE = 1000;
    private final int sampleSize;
    private long start;

    public AggregatingMessageChannelMetrics() {
        this(null, 1000);
    }

    public AggregatingMessageChannelMetrics(String name, int sampleSize) {
        super(name);
        this.sampleSize = sampleSize;
    }

    public AggregatingMessageChannelMetrics(String name, ExponentialMovingAverage sendDuration, ExponentialMovingAverageRate sendErrorRate, ExponentialMovingAverageRatio sendSuccessRatio, ExponentialMovingAverageRate sendRate, int sampleSize) {
        super(name, sendDuration, sendErrorRate, sendSuccessRatio, sendRate);
        this.sampleSize = sampleSize;
    }

    @Override
    public synchronized MetricsContext beforeSend() {
        long count = this.sendCount.getAndIncrement();
        if (this.isFullStatsEnabled() && count % (long)this.sampleSize == 0L) {
            this.start = System.nanoTime();
            this.sendRate.increment(this.start);
        }
        return new AggregatingChannelMetricsContext(this.start, count + 1L);
    }

    @Override
    public void afterSend(MetricsContext context, boolean result) {
        AggregatingChannelMetricsContext aggregatingContext = (AggregatingChannelMetricsContext)context;
        long newCount = aggregatingContext.newCount;
        if (result) {
            if (this.isFullStatsEnabled() && newCount % (long)this.sampleSize == 0L) {
                long now = System.nanoTime();
                this.sendSuccessRatio.success(now);
                this.sendDuration.append(now - aggregatingContext.start);
            }
        } else {
            if (this.isFullStatsEnabled() && newCount % (long)this.sampleSize == 0L) {
                long now = System.nanoTime();
                this.sendSuccessRatio.failure(now);
                this.sendErrorRate.increment(now);
            }
            this.sendErrorCount.incrementAndGet();
        }
    }

    protected static class AggregatingChannelMetricsContext
    extends DefaultMessageChannelMetrics.DefaultChannelMetricsContext {
        protected long newCount;

        public AggregatingChannelMetricsContext(long start, long newCount) {
            super(start);
            this.newCount = newCount;
        }
    }
}

