/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.management;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.support.management.AbstractMessageChannelMetrics;
import org.springframework.integration.support.management.AbstractMessageHandlerMetrics;
import org.springframework.integration.support.management.ConfigurableMetricsAware;
import org.springframework.integration.support.management.DefaultMetricsFactory;
import org.springframework.integration.support.management.IntegrationManagement;
import org.springframework.integration.support.management.MessageChannelMetrics;
import org.springframework.integration.support.management.MessageHandlerMetrics;
import org.springframework.integration.support.management.MessageSourceMetrics;
import org.springframework.integration.support.management.MessageSourceMetricsConfigurer;
import org.springframework.integration.support.management.MetricsCaptor;
import org.springframework.integration.support.management.MetricsFactory;
import org.springframework.integration.support.management.PollableChannelManagement;
import org.springframework.integration.support.management.micrometer.MicrometerMetricsCaptor;
import org.springframework.integration.util.PatternMatchUtils;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class IntegrationManagementConfigurer
implements SmartInitializingSingleton,
ApplicationContextAware,
BeanNameAware,
DestructionAwareBeanPostProcessor {
    private static final Log logger = LogFactory.getLog(IntegrationManagementConfigurer.class);
    public static final String MANAGEMENT_CONFIGURER_NAME = "integrationManagementConfigurer";
    private final Map<String, MessageChannelMetrics> channelsByName = new HashMap<String, MessageChannelMetrics>();
    private final Map<String, MessageHandlerMetrics> handlersByName = new HashMap<String, MessageHandlerMetrics>();
    private final Map<String, MessageSourceMetrics> sourcesByName = new HashMap<String, MessageSourceMetrics>();
    private final Map<String, MessageSourceMetricsConfigurer> sourceConfigurers = new HashMap<String, MessageSourceMetricsConfigurer>();
    private ApplicationContext applicationContext;
    private String beanName;
    private boolean defaultLoggingEnabled = true;
    private Boolean defaultCountsEnabled = false;
    private Boolean defaultStatsEnabled = false;
    private MetricsFactory metricsFactory;
    private String metricsFactoryBeanName;
    private String[] enabledCountsPatterns = new String[0];
    private String[] enabledStatsPatterns = new String[0];
    private volatile boolean singletonsInstantiated;
    private MetricsCaptor metricsCaptor;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setMetricsFactory(MetricsFactory metricsFactory) {
        this.metricsFactory = metricsFactory;
    }

    public void setMetricsFactoryBeanName(String metricsFactory) {
        this.metricsFactoryBeanName = metricsFactory;
    }

    public void setEnabledCountsPatterns(String[] enabledCountsPatterns) {
        Assert.notEmpty((Object[])enabledCountsPatterns, (String)"enabledCountsPatterns must not be empty");
        this.enabledCountsPatterns = Arrays.copyOf(enabledCountsPatterns, enabledCountsPatterns.length);
    }

    public void setEnabledStatsPatterns(String[] enabledStatsPatterns) {
        Assert.notEmpty((Object[])enabledStatsPatterns, (String)"enabledStatsPatterns must not be empty");
        this.enabledStatsPatterns = Arrays.copyOf(enabledStatsPatterns, enabledStatsPatterns.length);
    }

    public void setDefaultCountsEnabled(Boolean defaultCountsEnabled) {
        this.defaultCountsEnabled = defaultCountsEnabled;
    }

    public Boolean getDefaultCountsEnabled() {
        return this.defaultCountsEnabled;
    }

    public void setDefaultStatsEnabled(Boolean defaultStatsEnabled) {
        this.defaultStatsEnabled = defaultStatsEnabled;
    }

    public Boolean getDefaultStatsEnabled() {
        return this.defaultStatsEnabled;
    }

    public void setDefaultLoggingEnabled(boolean defaultLoggingEnabled) {
        this.defaultLoggingEnabled = defaultLoggingEnabled;
    }

    public void afterSingletonsInstantiated() {
        Map factories;
        Assert.state((this.applicationContext != null ? 1 : 0) != 0, (String)"'applicationContext' must not be null");
        Assert.state((boolean)MANAGEMENT_CONFIGURER_NAME.equals(this.beanName), (String)(this.getClass().getSimpleName() + " bean name must be " + MANAGEMENT_CONFIGURER_NAME));
        if (ClassUtils.isPresent((String)"io.micrometer.core.instrument.MeterRegistry", (ClassLoader)IntegrationManagementConfigurer.class.getClassLoader())) {
            this.metricsCaptor = MicrometerMetricsCaptor.loadCaptor(this.applicationContext);
        }
        if (this.metricsCaptor != null) {
            this.injectCaptor();
            this.registerComponentGauges();
        }
        if (this.metricsFactory == null && StringUtils.hasText((String)this.metricsFactoryBeanName)) {
            this.metricsFactory = (MetricsFactory)this.applicationContext.getBean(this.metricsFactoryBeanName, MetricsFactory.class);
        }
        if (this.metricsFactory == null && (factories = this.applicationContext.getBeansOfType(MetricsFactory.class)).size() == 1) {
            this.metricsFactory = (MetricsFactory)factories.values().iterator().next();
        }
        if (this.metricsFactory == null) {
            this.metricsFactory = new DefaultMetricsFactory();
        }
        this.sourceConfigurers.putAll(this.applicationContext.getBeansOfType(MessageSourceMetricsConfigurer.class));
        Map managed = this.applicationContext.getBeansOfType(IntegrationManagement.class);
        for (Map.Entry entry : managed.entrySet()) {
            IntegrationManagement bean = (IntegrationManagement)entry.getValue();
            if (!bean.getOverrides().loggingConfigured) {
                bean.setLoggingEnabled(this.defaultLoggingEnabled);
            }
            String name = (String)entry.getKey();
            this.doConfigureMetrics(bean, name);
        }
        this.singletonsInstantiated = true;
    }

    private void injectCaptor() {
        Map managed = this.applicationContext.getBeansOfType(IntegrationManagement.class);
        for (Map.Entry entry : managed.entrySet()) {
            IntegrationManagement bean = (IntegrationManagement)entry.getValue();
            if (!bean.getOverrides().loggingConfigured) {
                bean.setLoggingEnabled(this.defaultLoggingEnabled);
            }
            bean.registerMetricsCaptor(this.metricsCaptor);
        }
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.singletonsInstantiated) {
            if (bean instanceof IntegrationManagement) {
                ((IntegrationManagement)bean).registerMetricsCaptor(this.metricsCaptor);
            }
            return this.doConfigureMetrics(bean, beanName);
        }
        return bean;
    }

    public boolean requiresDestruction(Object bean) {
        return bean instanceof MessageChannelMetrics || bean instanceof MessageHandlerMetrics || bean instanceof MessageSourceMetrics;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        if (bean instanceof MessageChannelMetrics) {
            this.channelsByName.remove(beanName);
        } else if (bean instanceof MessageHandlerMetrics) {
            if (this.handlersByName.remove(beanName) == null) {
                this.handlersByName.remove(beanName + ".handler");
            }
        } else if (bean instanceof MessageSourceMetrics && this.sourcesByName.remove(beanName) == null) {
            this.sourcesByName.remove(beanName + ".source");
        }
    }

    private Object doConfigureMetrics(Object bean, String name) {
        if (bean instanceof MessageChannelMetrics) {
            this.configureChannelMetrics(name, (MessageChannelMetrics)bean);
        } else if (bean instanceof MessageHandlerMetrics) {
            this.configureHandlerMetrics(name, (MessageHandlerMetrics)bean);
        } else if (bean instanceof MessageSourceMetrics) {
            this.configureSourceMetrics(name, (MessageSourceMetrics)bean);
            this.sourceConfigurers.values().forEach(c -> c.configure((MessageSourceMetrics)bean, name));
        }
        return bean;
    }

    private void configureChannelMetrics(String name, MessageChannelMetrics bean) {
        AbstractMessageChannelMetrics metrics = bean instanceof PollableChannelManagement ? this.metricsFactory.createPollableChannelMetrics(name) : this.metricsFactory.createChannelMetrics(name);
        Assert.state((metrics != null ? 1 : 0) != 0, (String)"'metrics' must not be null");
        IntegrationManagement.ManagementOverrides overrides = bean.getOverrides();
        Boolean enabled = PatternMatchUtils.smartMatch(name, this.enabledCountsPatterns);
        if (enabled != null) {
            bean.setCountsEnabled(enabled);
        } else if (!overrides.countsConfigured) {
            bean.setCountsEnabled(this.defaultCountsEnabled);
        }
        enabled = PatternMatchUtils.smartMatch(name, this.enabledStatsPatterns);
        if (enabled != null) {
            bean.setStatsEnabled(enabled);
            metrics.setFullStatsEnabled(enabled);
        } else if (!overrides.statsConfigured) {
            bean.setStatsEnabled(this.defaultStatsEnabled);
            metrics.setFullStatsEnabled(this.defaultStatsEnabled);
        }
        if (bean instanceof ConfigurableMetricsAware && !overrides.metricsConfigured) {
            ((ConfigurableMetricsAware)((Object)bean)).configureMetrics(metrics);
        }
        this.channelsByName.put(name, bean);
    }

    private void configureHandlerMetrics(String name, MessageHandlerMetrics bean) {
        AbstractMessageHandlerMetrics metrics = this.metricsFactory.createHandlerMetrics(name);
        Assert.state((metrics != null ? 1 : 0) != 0, (String)"'metrics' must not be null");
        IntegrationManagement.ManagementOverrides overrides = bean.getOverrides();
        Boolean enabled = PatternMatchUtils.smartMatch(name, this.enabledCountsPatterns);
        if (enabled != null) {
            bean.setCountsEnabled(enabled);
        } else if (!overrides.countsConfigured) {
            bean.setCountsEnabled(this.defaultCountsEnabled);
        }
        enabled = PatternMatchUtils.smartMatch(name, this.enabledStatsPatterns);
        if (enabled != null) {
            bean.setStatsEnabled(enabled);
            metrics.setFullStatsEnabled(enabled);
        } else if (!overrides.statsConfigured) {
            bean.setStatsEnabled(this.defaultStatsEnabled);
            metrics.setFullStatsEnabled(this.defaultStatsEnabled);
        }
        if (bean instanceof ConfigurableMetricsAware && !overrides.metricsConfigured) {
            ((ConfigurableMetricsAware)((Object)bean)).configureMetrics(metrics);
        }
        this.handlersByName.put(bean.getManagedName() != null ? bean.getManagedName() : name, bean);
    }

    private void configureSourceMetrics(String name, MessageSourceMetrics bean) {
        Boolean enabled = PatternMatchUtils.smartMatch(name, this.enabledCountsPatterns);
        if (enabled != null) {
            bean.setCountsEnabled(enabled);
        } else if (!bean.getOverrides().countsConfigured) {
            bean.setCountsEnabled(this.defaultCountsEnabled);
        }
        this.sourcesByName.put(bean.getManagedName() != null ? bean.getManagedName() : name, bean);
    }

    private void registerComponentGauges() {
        this.metricsCaptor.gaugeBuilder("spring.integration.channels", this, c -> this.applicationContext.getBeansOfType(MessageChannel.class).size()).description("The number of message channels").build();
        this.metricsCaptor.gaugeBuilder("spring.integration.handlers", this, c -> this.applicationContext.getBeansOfType(MessageHandler.class).size()).description("The number of message handlers").build();
        this.metricsCaptor.gaugeBuilder("spring.integration.sources", this, c -> this.applicationContext.getBeansOfType(MessageSource.class).size()).description("The number of message sources").build();
    }

    public String[] getChannelNames() {
        return this.channelsByName.keySet().toArray(new String[this.channelsByName.size()]);
    }

    public String[] getHandlerNames() {
        return this.handlersByName.keySet().toArray(new String[this.handlersByName.size()]);
    }

    public String[] getSourceNames() {
        return this.sourcesByName.keySet().toArray(new String[this.sourcesByName.size()]);
    }

    public MessageChannelMetrics getChannelMetrics(String name) {
        if (this.channelsByName.containsKey(name)) {
            return this.channelsByName.get(name);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("No channel found for (" + name + ")"));
        }
        return null;
    }

    public MessageHandlerMetrics getHandlerMetrics(String name) {
        if (this.handlersByName.containsKey(name)) {
            return this.handlersByName.get(name);
        }
        if (this.handlersByName.containsKey(name + ".handler")) {
            return this.handlersByName.get(name + ".handler");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("No handler found for (" + name + ")"));
        }
        return null;
    }

    public MessageSourceMetrics getSourceMetrics(String name) {
        if (this.sourcesByName.containsKey(name)) {
            return this.sourcesByName.get(name);
        }
        if (this.sourcesByName.containsKey(name + ".source")) {
            return this.sourcesByName.get(name + ".source");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("No source found for (" + name + ")"));
        }
        return null;
    }
}

