/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.shiro.filter;

import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.shiro.realm.CasAuthorizingRealm;
import com.jeesite.common.shiro.realm.LoginInfo;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.cas.CasFilter;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.util.WebUtils;

public class CasAuthenticationFilter
extends CasFilter {
    private CasAuthorizingRealm authorizingRealm;

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        this.authorizingRealm.onLoginSuccess((LoginInfo)subject.getPrincipal(), (HttpServletRequest)request);
        String url = request.getParameter("__url");
        if (StringUtils.isNotBlank((CharSequence)url)) {
            WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)url, null, (boolean)true);
        } else {
            WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)this.getSuccessUrl(), null, (boolean)true);
        }
        return false;
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException ae, ServletRequest request, ServletResponse response) {
        Subject subject = this.getSubject(request, response);
        if (subject.isAuthenticated() || subject.isRemembered()) {
            try {
                String url = request.getParameter("__url");
                if (StringUtils.isNotBlank((CharSequence)url)) {
                    WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)url, null, (boolean)true);
                } else {
                    WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)this.getSuccessUrl(), null, (boolean)true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }
        try {
            if (ae != null && StringUtils.startsWith((CharSequence)ae.getMessage(), (CharSequence)"msg:")) {
                request.setAttribute("exception", (Object)ae);
                request.getRequestDispatcher("/error/403").forward(request, response);
            } else {
                WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)this.getLoginUrl());
            }
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void setAuthorizingRealm(CasAuthorizingRealm authorizingRealm) {
        this.authorizingRealm = authorizingRealm;
    }
}

