/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.shiro.realm;

import com.jeesite.common.codec.EncodeUtils;
import com.jeesite.common.collect.MapUtils;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.shiro.authc.FormToken;
import com.jeesite.common.shiro.cas.CasCreateUser;
import com.jeesite.common.shiro.cas.CasOutHandler;
import com.jeesite.common.shiro.realm.BaseAuthorizingRealm;
import com.jeesite.common.shiro.realm.LoginInfo;
import com.jeesite.common.utils.SpringUtils;
import com.jeesite.common.web.http.ServletUtils;
import com.jeesite.modules.sys.entity.EmpUser;
import com.jeesite.modules.sys.entity.User;
import com.jeesite.modules.sys.service.EmpUserService;
import com.jeesite.modules.sys.service.UserService;
import com.jeesite.modules.sys.utils.LogUtils;
import com.jeesite.modules.sys.utils.UserUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ValidationException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.cas.CasToken;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class CasAuthorizingRealm
extends BaseAuthorizingRealm {
    private UserService userService;
    private EmpUserService empUserService;
    private CasOutHandler casOutHandler;
    private String casServerUrl;
    private String casServerCallbackUrl;
    private TicketValidator ticketValidator;

    public CasAuthorizingRealm() {
        this.setAuthenticationTokenClass(CasToken.class);
    }

    protected FormToken getFormToken(AuthenticationToken authcToken) {
        HttpServletRequest request = ServletUtils.getRequest();
        if (this.casOutHandler.isLogoutRequest(request)) {
            LoginInfo loginInfo = this.casOutHandler.destroySession(request);
            if (loginInfo != null) {
                this.onLogoutSuccess(loginInfo, request);
            }
            return null;
        }
        if (authcToken == null) {
            return null;
        }
        CasToken casToken = (CasToken)authcToken;
        String ticket = (String)casToken.getCredentials();
        if (this.ticketValidator == null) {
            this.ticketValidator = new Cas20ServiceTicketValidator(this.casServerUrl);
            ((Cas20ServiceTicketValidator)this.ticketValidator).setEncoding("UTF-8");
        }
        Assertion casAssertion = null;
        try {
            casAssertion = this.ticketValidator.validate(ticket, this.casServerCallbackUrl);
        }
        catch (TicketValidationException e) {
            return null;
        }
        AttributePrincipal casPrincipal = casAssertion.getPrincipal();
        casToken.setUserId(casPrincipal.getName());
        FormToken token = new FormToken();
        token.setUsername(casPrincipal.getName());
        HashMap params = MapUtils.newHashMap();
        params.putAll(casPrincipal.getAttributes());
        params.put("ticket", ticket);
        token.setParams((Map)params);
        return token;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected User getUserInfo(FormToken token) {
        User user = super.getUserInfo(token);
        if (user != null) return user;
        Map attrs = token.getParams();
        if (!ObjectUtils.toBoolean(attrs.get("isAllowClientCreateUser")).booleanValue()) throw new AuthenticationException("msg:\u7528\u6237 \u201c" + token.getUsername() + "\u201d \u5728\u672c\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458.");
        user = new User(EncodeUtils.decodeUrl((String)ObjectUtils.toString(attrs.get("userCode"))));
        user.setLoginCode(EncodeUtils.decodeUrl((String)ObjectUtils.toString(attrs.get("loginCode"))));
        user.setPassword(EncodeUtils.decodeUrl((String)ObjectUtils.toString(attrs.get("password"))));
        user.setUserName(EncodeUtils.decodeUrl((String)ObjectUtils.toString(attrs.get("userName"))));
        user.setEmail(EncodeUtils.decodeUrl((String)ObjectUtils.toString(attrs.get("email"))));
        user.setMobile(EncodeUtils.decodeUrl((String)ObjectUtils.toString(attrs.get("mobile"))));
        user.setPhone(EncodeUtils.decodeUrl((String)ObjectUtils.toString(attrs.get("phone"))));
        user.setUserType(EncodeUtils.decodeUrl((String)ObjectUtils.toString(attrs.get("userType"))));
        user.setRefCode(EncodeUtils.decodeUrl((String)ObjectUtils.toString(attrs.get("refCode"))));
        user.setRefName(EncodeUtils.decodeUrl((String)ObjectUtils.toString(attrs.get("refName"))));
        user.setMgrType(EncodeUtils.decodeUrl((String)ObjectUtils.toString(attrs.get("mgrType"))));
        user.setStatus(EncodeUtils.decodeUrl((String)ObjectUtils.toString(attrs.get("status"))));
        if ("employee".equals(user.getUserType())) {
            try {
                EmpUser empUser = new EmpUser();
                empUser.setIsNewRecord(true);
                empUser.setMobile(user.getMobile());
                empUser.setEmail(user.getEmail());
                empUser.setPhone(user.getPhone());
                empUser.getEmployee().getCompany().setCompanyCode(EncodeUtils.decodeUrl((String)ObjectUtils.toString(attrs.get("companyCode"))));
                empUser.getEmployee().getOffice().setOfficeCode(EncodeUtils.decodeUrl((String)ObjectUtils.toString(attrs.get("officeCode"))));
                this.getEmpUserService().save(empUser);
            }
            catch (ValidationException ve) {
                throw new AuthenticationException("msg:" + ve.getMessage());
            }
            user = UserUtils.getByLoginCode((String)token.getUsername());
            if (user == null) return user;
            return user;
        }
        try {
            CasCreateUser casCreateUser = (CasCreateUser)SpringUtils.getBean(CasCreateUser.class);
            if (casCreateUser == null) return user;
            casCreateUser.createUser(user, attrs);
            return user;
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new AuthenticationException("msg:\u7528\u6237 \u201c" + token.getUsername() + "\u201d, \u7c7b\u578b \u201c" + user.getUserType() + "\u201d \u5728\u672c\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458.");
        }
    }

    protected void assertCredentialsMatch(AuthenticationToken authcToken, AuthenticationInfo info) throws AuthenticationException {
    }

    public void onLoginSuccess(LoginInfo loginInfo, HttpServletRequest request) {
        super.onLoginSuccess(loginInfo, request);
        String ticket = loginInfo.getParam("ticket");
        this.casOutHandler.recordSession(request, ticket);
        User user = UserUtils.get((String)loginInfo.getId());
        this.getUserService().updateUserLoginInfo(user);
        LogUtils.saveLog(user, ServletUtils.getRequest(), "\u7cfb\u7edf\u767b\u5f55", "loginLogout");
    }

    public void onLogoutSuccess(LoginInfo loginInfo, HttpServletRequest request) {
        super.onLogoutSuccess(loginInfo, request);
        User user = UserUtils.get((String)loginInfo.getId());
        LogUtils.saveLog(user, request, "\u7cfb\u7edf\u9000\u51fa", "loginLogout");
    }

    public UserService getUserService() {
        if (this.userService == null) {
            this.userService = (UserService)SpringUtils.getBean(UserService.class);
        }
        return this.userService;
    }

    public EmpUserService getEmpUserService() {
        if (this.empUserService == null) {
            this.empUserService = (EmpUserService)SpringUtils.getBean(EmpUserService.class);
        }
        return this.empUserService;
    }

    public void setCasOutHandler(CasOutHandler casOutHandler) {
        this.casOutHandler = casOutHandler;
    }

    public void setCasServerUrl(String casServerUrl) {
        this.casServerUrl = casServerUrl;
    }

    public void setCasServerCallbackUrl(String casServerCallbackUrl) {
        this.casServerCallbackUrl = casServerCallbackUrl;
    }
}

