/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.db;

import com.jeesite.common.callback.MethodCallback;
import com.jeesite.common.entity.DataEntity;
import com.jeesite.common.idgen.IdGen;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.tests.BaseInitDataTests;
import com.jeesite.modules.gen.entity.GenTable;
import com.jeesite.modules.gen.entity.GenTableColumn;
import com.jeesite.modules.gen.service.GenTableService;
import com.jeesite.modules.job.entity.JobEntity;
import com.jeesite.modules.job.service.JobService;
import com.jeesite.modules.msg.task.impl.MsgLocalMergePushTask;
import com.jeesite.modules.msg.task.impl.MsgLocalPushTask;
import com.jeesite.modules.sys.dao.RoleMenuDao;
import com.jeesite.modules.sys.entity.Area;
import com.jeesite.modules.sys.entity.Company;
import com.jeesite.modules.sys.entity.CompanyOffice;
import com.jeesite.modules.sys.entity.Config;
import com.jeesite.modules.sys.entity.DictData;
import com.jeesite.modules.sys.entity.DictType;
import com.jeesite.modules.sys.entity.EmpUser;
import com.jeesite.modules.sys.entity.Employee;
import com.jeesite.modules.sys.entity.EmployeePost;
import com.jeesite.modules.sys.entity.Log;
import com.jeesite.modules.sys.entity.Menu;
import com.jeesite.modules.sys.entity.Module;
import com.jeesite.modules.sys.entity.Office;
import com.jeesite.modules.sys.entity.Post;
import com.jeesite.modules.sys.entity.Role;
import com.jeesite.modules.sys.entity.RoleDataScope;
import com.jeesite.modules.sys.entity.RoleMenu;
import com.jeesite.modules.sys.entity.User;
import com.jeesite.modules.sys.entity.UserDataScope;
import com.jeesite.modules.sys.entity.UserRole;
import com.jeesite.modules.sys.service.AreaService;
import com.jeesite.modules.sys.service.CompanyService;
import com.jeesite.modules.sys.service.ConfigService;
import com.jeesite.modules.sys.service.DictDataService;
import com.jeesite.modules.sys.service.DictTypeService;
import com.jeesite.modules.sys.service.EmpUserService;
import com.jeesite.modules.sys.service.MenuService;
import com.jeesite.modules.sys.service.ModuleService;
import com.jeesite.modules.sys.service.OfficeService;
import com.jeesite.modules.sys.service.PostService;
import com.jeesite.modules.sys.service.RoleService;
import com.jeesite.modules.sys.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;

public class InitCoreData
extends BaseInitDataTests {
    @Autowired
    private AreaService areaService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private DictTypeService dictTypeService;
    @Autowired
    private DictDataService dictDataService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private MenuService menuService;
    @Autowired
    private RoleMenuDao roleMenuDao;
    @Autowired
    private UserService userService;
    @Autowired
    private OfficeService officeService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private PostService postService;
    @Autowired
    private EmpUserService empUserService;
    @Autowired
    private JobService jobService;
    @Autowired
    private GenTableService genTableService;

    public void begin() {
        super.begin();
        this.excelFile = InitCoreData.class.getName().replaceAll("\\.", "/") + ".xlsx";
    }

    public void createTable() throws Exception {
        this.runScript("core.sql");
        this.runScript("job.sql");
        this.runScript("test.sql");
    }

    public void initLog() throws Exception {
        this.clearTable(Log.class);
    }

    public void initArea(final String ... prefixes) throws Exception {
        this.clearTable(Area.class);
        this.initExcelData(Area.class, new MethodCallback(){

            public Object execute(Object ... params) {
                String action = (String)params[0];
                if ("save".equals(action)) {
                    Area entity = (Area)((Object)params[1]);
                    entity.setIsNewRecord(true);
                    if (prefixes == null || prefixes.length == 0 || StringUtils.startsWithAny((CharSequence)entity.getAreaCode(), (CharSequence[])prefixes)) {
                        InitCoreData.this.areaService.save(entity);
                    }
                    return null;
                }
                return null;
            }
        });
    }

    public void initConfig() throws Exception {
        this.clearTable(Config.class);
        this.initExcelData(Config.class, new MethodCallback(){

            public Object execute(Object ... params) {
                String action = (String)params[0];
                if ("save".equals(action)) {
                    Config entity = (Config)params[1];
                    entity.setId(IdGen.nextId());
                    entity.setIsNewRecord(true);
                    InitCoreData.this.configService.save(entity);
                    return null;
                }
                return null;
            }
        });
    }

    public void initModule() throws Exception {
        this.clearTable(Module.class);
        this.initExcelData(Module.class, new MethodCallback(){

            public Object execute(Object ... params) {
                String action = (String)params[0];
                if ("save".equals(action)) {
                    Module entity = (Module)params[1];
                    entity.setIsNewRecord(true);
                    InitCoreData.this.moduleService.save(entity);
                    return null;
                }
                return null;
            }
        });
    }

    public void initDict() throws Exception {
        this.clearTable(DictType.class);
        this.initExcelData(DictType.class, new MethodCallback(){

            public Object execute(Object ... params) {
                String action = (String)params[0];
                if ("save".equals(action)) {
                    DictType entity = (DictType)params[1];
                    entity.setId(IdGen.nextId());
                    entity.setIsNewRecord(true);
                    InitCoreData.this.dictTypeService.save((DataEntity)entity);
                    return null;
                }
                return null;
            }
        });
        this.clearTable(DictData.class);
        this.initExcelData(DictData.class, new MethodCallback(){

            public Object execute(Object ... params) {
                String action = (String)params[0];
                if ("save".equals(action)) {
                    DictData entity = (DictData)params[1];
                    entity.setIsNewRecord(true);
                    InitCoreData.this.dictDataService.save(entity);
                    return null;
                }
                return null;
            }
        });
    }

    public void initRole() throws Exception {
        this.clearTable(Role.class);
        this.clearTable(RoleMenu.class);
        this.clearTable(RoleDataScope.class);
        this.initExcelData(Role.class, new MethodCallback(){

            public Object execute(Object ... params) {
                String action = (String)params[0];
                if ("save".equals(action)) {
                    Role entity = (Role)params[1];
                    entity.setIsNewRecord(true);
                    InitCoreData.this.roleService.save(entity);
                    return null;
                }
                return null;
            }
        });
    }

    public void initMenu() throws Exception {
        this.clearTable(Menu.class);
        this.clearTable(RoleMenu.class);
        this.initExcelData(Menu.class, new MethodCallback(){

            public Object execute(Object ... params) {
                String action = (String)params[0];
                if ("save".equals(action)) {
                    Menu entity = (Menu)params[1];
                    entity.setIsNewRecord(true);
                    InitCoreData.this.menuService.save(entity);
                    RoleMenu rm = new RoleMenu();
                    rm.setMenuCode(entity.getMenuCode());
                    rm.setRoleCode(Role.CORP_ADMIN_ROLE_CODE);
                    InitCoreData.this.roleMenuDao.insert((Object)rm);
                    return null;
                }
                return null;
            }
        });
    }

    public void initUser() throws Exception {
        this.clearTable(User.class);
        this.clearTable(UserRole.class);
        this.clearTable(UserDataScope.class);
        this.initExcelData(User.class, new MethodCallback(){

            public Object execute(Object ... params) {
                String action = (String)params[0];
                if ("save".equals(action)) {
                    User entity = (User)params[1];
                    entity.setIsNewRecord(true);
                    InitCoreData.this.userService.save(entity);
                    return null;
                }
                return null;
            }
        });
    }

    public void initOffice() throws Exception {
        this.clearTable(Office.class);
        this.initExcelData(Office.class, new MethodCallback(){

            public Object execute(Object ... params) {
                String action = (String)params[0];
                if ("save".equals(action)) {
                    Office entity = (Office)((Object)params[1]);
                    entity.setIsNewRecord(true);
                    InitCoreData.this.officeService.save(entity);
                    return null;
                }
                return null;
            }
        });
    }

    public void initCompany() throws Exception {
        this.clearTable(Company.class);
        this.clearTable(CompanyOffice.class);
        this.initExcelData(Company.class, new MethodCallback(){

            public Object execute(Object ... params) {
                String action = (String)params[0];
                if ("save".equals(action)) {
                    Company entity = (Company)((Object)params[1]);
                    entity.setIsNewRecord(true);
                    InitCoreData.this.companyService.save(entity);
                    return null;
                }
                return null;
            }
        });
    }

    public void initPost() throws Exception {
        this.clearTable(Post.class);
        this.initExcelData(Post.class, new MethodCallback(){

            public Object execute(Object ... params) {
                String action = (String)params[0];
                if ("save".equals(action)) {
                    Post entity = (Post)((Object)params[1]);
                    entity.setIsNewRecord(true);
                    InitCoreData.this.postService.save(entity);
                    return null;
                }
                return null;
            }
        });
    }

    public void initEmpUser() throws Exception {
        this.clearTable(Employee.class);
        this.clearTable(EmployeePost.class);
        this.initExcelData(EmpUser.class, new MethodCallback(){

            public Object execute(Object ... params) {
                String action = (String)params[0];
                if ("set".equals(action)) {
                    EmpUser entity = (EmpUser)((Object)params[1]);
                    String header = (String)params[2];
                    String val = (String)params[3];
                    if ("userRoleString".equals(header)) {
                        entity.setUserRoleString(val);
                        return true;
                    }
                    if ("employee.employeePosts".equals(header)) {
                        entity.getEmployee().setEmployeePosts(new String[]{val});
                        return true;
                    }
                } else if ("save".equals(action)) {
                    EmpUser entity = (EmpUser)((Object)params[1]);
                    entity.setIsNewRecord(true);
                    InitCoreData.this.empUserService.save(entity);
                    entity.setCurrentUser(new User(User.SUPER_ADMIN_CODE));
                    InitCoreData.this.userService.saveAuth((User)entity);
                    return null;
                }
                return null;
            }
        });
    }

    public void initMsgPushJob() {
        JobEntity job = new JobEntity(MsgLocalPushTask.class.getSimpleName(), "SYSTEM");
        job.setDescription("\u6d88\u606f\u63a8\u9001\u670d\u52a1 (\u5b9e\u65f6\u63a8\u9001)");
        job.setInvokeTarget("msgLocalPushTask.execute()");
        job.setCronExpression("0/3 * * * * ?");
        job.setConcurrent("0");
        job.setMisfireInstruction(Integer.valueOf(2));
        job.setStatus("2");
        this.jobService.insert((DataEntity)job);
        job = new JobEntity(MsgLocalMergePushTask.class.getSimpleName(), "SYSTEM");
        job.setDescription("\u6d88\u606f\u63a8\u9001\u670d\u52a1 (\u5ef6\u8fdf\u63a8\u9001)");
        job.setInvokeTarget("msgLocalMergePushTask.execute()");
        job.setCronExpression("0 0/30 * * * ?");
        job.setConcurrent("0");
        job.setMisfireInstruction(Integer.valueOf(2));
        job.setStatus("2");
        this.jobService.insert((DataEntity)job);
    }

    public void initGenTestData() throws Exception {
        GenTable genTable = new GenTable();
        genTable.setIsNewRecord(true);
        genTable.setTableName("test_data");
        genTable = this.genTableService.getFromDb(genTable);
        genTable.setIsNewRecord(true);
        genTable.setClassName("TestData");
        genTable.setFunctionAuthor("ThinkGem");
        genTable.setTplCategory("crud");
        genTable.setPackageName("com.jeesite.modules");
        genTable.setModuleName("test");
        genTable.setSubModuleName("");
        genTable.setFunctionName("\u6d4b\u8bd5\u6570\u636e");
        genTable.setFunctionNameSimple("\u6570\u636e");
        genTable.getOptionMap().put("isHaveDisableEnable", "1");
        genTable.getOptionMap().put("isHaveDelete", "1");
        genTable.getOptionMap().put("isFileUpload", "1");
        genTable.getOptionMap().put("isImageUpload", "1");
        this.initGenTableColumn(genTable);
        this.genTableService.save(genTable);
        GenTable genTableChild = new GenTable();
        genTableChild.setIsNewRecord(true);
        genTableChild.setTableName("test_data_child");
        genTableChild = this.genTableService.getFromDb(genTableChild);
        genTableChild.setIsNewRecord(true);
        genTableChild.setClassName("TestDataChild");
        genTableChild.setFunctionAuthor("ThinkGem");
        genTableChild.setTplCategory("crud");
        genTableChild.setPackageName("com.jeesite.modules");
        genTableChild.setModuleName("test");
        genTableChild.setSubModuleName("");
        genTableChild.setFunctionName("\u6d4b\u8bd5\u5b50\u8868");
        genTableChild.setFunctionNameSimple("\u6570\u636e");
        genTableChild.setParentTableName("test_data");
        genTableChild.setParentTableFkName("test_data_id");
        this.initGenTableColumn(genTableChild);
        this.genTableService.save(genTableChild);
    }

    private void initGenTableColumn(GenTable genTable) {
        for (GenTableColumn column : genTable.getColumnList()) {
            if ("test_input".equals(column.getColumnName()) || "test_textarea".equals(column.getColumnName()) || "test_select".equals(column.getColumnName()) || "test_select_multiple".equals(column.getColumnName()) || "test_checkbox".equals(column.getColumnName()) || "test_radio".equals(column.getColumnName()) || "test_date".equals(column.getColumnName()) || "test_datetime".equals(column.getColumnName())) {
                column.setShowType(StringUtils.substringAfter((String)column.getColumnName(), (String)"test_"));
                if ("test_input".equals(column.getColumnName())) {
                    column.setQueryType("LIKE");
                    continue;
                }
                if ("test_textarea".equals(column.getColumnName())) {
                    column.setQueryType("LIKE");
                    column.getOptionMap().put("isNewLine", "1");
                    column.getOptionMap().put("gridRowCol", "12/2/10");
                    continue;
                }
                if ("test_select".equals(column.getColumnName()) || "test_select_multiple".equals(column.getColumnName()) || "test_radio".equals(column.getColumnName()) || "test_checkbox".equals(column.getColumnName())) {
                    column.getOptionMap().put("dictType", "sys_menu_type");
                    column.getOptionMap().put("dictName", "sys_menu_type");
                    continue;
                }
                if (!"test_date".equals(column.getColumnName()) && !"test_datetime".equals(column.getColumnName())) continue;
                column.setQueryType("BETWEEN");
                continue;
            }
            if ("test_user_code".equals(column.getColumnName())) {
                column.setAttrType("com.jeesite.modules.sys.entity.User");
                column.setFullAttrName("testUser");
                column.setShowType("userselect");
                continue;
            }
            if ("test_office_code".equals(column.getColumnName())) {
                column.setAttrType("com.jeesite.modules.sys.entity.Office");
                column.setFullAttrName("testOffice");
                column.setShowType("officeselect");
                continue;
            }
            if ("test_area_code".equals(column.getColumnName())) {
                column.setFullAttrName("testAreaCode|testAreaName");
                column.setShowType("areaselect");
                continue;
            }
            if ("test_area_name".equals(column.getColumnName())) {
                column.setIsEdit("0");
                column.setIsQuery("0");
                continue;
            }
            if (!"test_data_id".equals(column.getColumnName())) continue;
            column.setFullAttrName("testData");
        }
    }

    public void initGenTreeData() throws Exception {
        GenTable genTable = new GenTable();
        genTable.setIsNewRecord(true);
        genTable.setTableName("test_tree");
        genTable = this.genTableService.getFromDb(genTable);
        genTable.setIsNewRecord(true);
        genTable.setClassName("TestTree");
        genTable.setFunctionAuthor("ThinkGem");
        genTable.setTplCategory("treeGrid");
        genTable.setPackageName("com.jeesite.modules");
        genTable.setModuleName("test");
        genTable.setSubModuleName("");
        genTable.setFunctionName("\u6d4b\u8bd5\u6811\u8868");
        genTable.setFunctionNameSimple("\u6570\u636e");
        genTable.getOptionMap().put("isHaveDisableEnable", "1");
        genTable.getOptionMap().put("isHaveDelete", "1");
        genTable.getOptionMap().put("isFileUpload", "1");
        genTable.getOptionMap().put("isImageUpload", "1");
        genTable.getOptionMap().put("treeViewCode", "tree_code");
        genTable.getOptionMap().put("treeViewName", "tree_name");
        this.initGenTableColumn(genTable);
        this.genTableService.save(genTable);
    }
}

