/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.entity;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.entity.BaseEntity;
import com.jeesite.common.entity.DataEntity;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mybatis.annotation.Column;
import com.jeesite.common.mybatis.annotation.JoinTable;
import com.jeesite.common.mybatis.annotation.Table;
import com.jeesite.common.mybatis.mapper.query.QueryType;
import com.jeesite.modules.sys.entity.Area;
import com.jeesite.modules.sys.entity.Company;
import com.jeesite.modules.sys.entity.EmployeePost;
import com.jeesite.modules.sys.entity.Office;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

@Table(name="${_prefix}sys_employee", alias="a", columns={@Column(includeEntity=BaseEntity.class), @Column(includeEntity=DataEntity.class), @Column(name="emp_code", attrName="empCode", label="\u5458\u5de5\u7f16\u7801", isPK=true), @Column(name="emp_name", attrName="empName", label="\u5458\u5de5\u59d3\u540d", queryType=QueryType.LIKE), @Column(name="emp_name_en", attrName="empNameEn", label="\u82f1\u6587\u540d", queryType=QueryType.LIKE), @Column(name="office_code", attrName="office.officeCode", label="\u673a\u6784\u7f16\u7801", isQuery=false), @Column(name="office_name", attrName="office.officeName", label="\u673a\u6784\u540d\u79f0", isQuery=false), @Column(name="company_code", attrName="company.companyCode", label="\u516c\u53f8\u7f16\u7801", isQuery=false), @Column(name="company_name", attrName="company.companyName", label="\u516c\u53f8\u540d\u79f0", isQuery=false)}, joinTable={@JoinTable(type=JoinTable.Type.LEFT_JOIN, entity=Office.class, alias="o", on="o.office_code = a.office_code", columns={@Column(includeEntity=Office.class)}), @JoinTable(type=JoinTable.Type.LEFT_JOIN, entity=Company.class, alias="c", on="c.company_code = a.company_code", columns={@Column(includeEntity=Company.class)}), @JoinTable(type=JoinTable.Type.LEFT_JOIN, entity=Area.class, alias="ar", on="ar.area_code = c.area_code", attrName="company.area", columns={@Column(name="area_name", label="\u533a\u57df\u540d\u79f0"), @Column(name="area_type", label="\u533a\u57df\u7c7b\u578b")})}, orderBy="a.update_date DESC")
public class Employee
extends DataEntity<Employee> {
    private static final long serialVersionUID = 1L;
    private String empCode;
    private String empName;
    private String empNameEn;
    private Office office;
    private Company company;
    private String postCode;
    private List<EmployeePost> employeePostList = ListUtils.newArrayList();

    public Employee() {
        this(null);
    }

    public Employee(String id) {
        super(id);
    }

    public String getEmpCode() {
        return this.empCode;
    }

    public void setEmpCode(String empCode) {
        this.empCode = empCode;
    }

    @Length(min=0, max=100, message="\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 100 \u4e2a\u5b57\u7b26")
    public @Length(min=0, max=100, message="\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 100 \u4e2a\u5b57\u7b26") String getEmpName() {
        return this.empName;
    }

    public void setEmpName(String empName) {
        this.empName = empName;
    }

    @Length(min=0, max=100, message="\u82f1\u6587\u540d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 100 \u4e2a\u5b57\u7b26")
    public @Length(min=0, max=100, message="\u82f1\u6587\u540d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 100 \u4e2a\u5b57\u7b26") String getEmpNameEn() {
        return this.empNameEn;
    }

    public void setEmpNameEn(String empNameEn) {
        this.empNameEn = empNameEn;
    }

    @NotNull(message="\u5f52\u5c5e\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a")
    public @NotNull(message="\u5f52\u5c5e\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a") Office getOffice() {
        if (this.office == null) {
            this.office = new Office();
        }
        return this.office;
    }

    public void setOffice(Office office) {
        this.office = office;
    }

    @NotNull(message="\u5f52\u5c5e\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a")
    public @NotNull(message="\u5f52\u5c5e\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a") Company getCompany() {
        if (this.company == null) {
            this.company = new Company();
        }
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public String getPostCode() {
        return this.postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public List<EmployeePost> getEmployeePostList() {
        return this.employeePostList;
    }

    public void setEmployeePostList(List<EmployeePost> employeePostList) {
        this.employeePostList = employeePostList;
    }

    public String[] getEmployeePosts() {
        List list = ListUtils.extractToList(this.employeePostList, (String)"postCode");
        return list.toArray(new String[list.size()]);
    }

    public void setEmployeePosts(String[] employeePosts) {
        for (String val : employeePosts) {
            if (!StringUtils.isNotBlank((CharSequence)val)) continue;
            EmployeePost e = new EmployeePost();
            e.setPostCode(val);
            this.employeePostList.add(e);
        }
    }
}

