/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jeesite.common.entity.BaseEntity;
import com.jeesite.common.entity.DataEntity;
import com.jeesite.common.entity.Extend;
import com.jeesite.common.entity.TreeEntity;
import com.jeesite.common.mybatis.annotation.Column;
import com.jeesite.common.mybatis.annotation.Table;
import com.jeesite.common.mybatis.mapper.query.QueryType;
import com.jeesite.modules.sys.utils.EmpUtils;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;

@Table(name="${_prefix}sys_office", alias="a", columns={@Column(includeEntity=BaseEntity.class), @Column(includeEntity=DataEntity.class), @Column(includeEntity=TreeEntity.class), @Column(name="office_code", attrName="officeCode", label="\u673a\u6784\u7f16\u7801", isPK=true), @Column(name="view_code", attrName="viewCode", label="\u673a\u6784\u4ee3\u7801"), @Column(name="office_name", attrName="officeName", label="\u673a\u6784\u540d\u79f0", queryType=QueryType.LIKE, isTreeName=true), @Column(name="full_name", attrName="fullName", label="\u673a\u6784\u5168\u79f0", queryType=QueryType.LIKE), @Column(name="office_type", attrName="officeType", label="\u673a\u6784\u7c7b\u578b"), @Column(name="leader", attrName="leader", label="\u8d1f\u8d23\u4eba", queryType=QueryType.LIKE), @Column(name="phone", attrName="phone", label="\u7535\u8bdd", queryType=QueryType.LIKE), @Column(name="address", attrName="address", label="\u8054\u7cfb\u5730\u5740", queryType=QueryType.LIKE), @Column(name="zip_code", attrName="zipCode", label="\u90ae\u653f\u7f16\u7801", queryType=QueryType.LIKE), @Column(name="email", attrName="email", label="\u90ae\u7bb1", queryType=QueryType.LIKE), @Column(includeEntity=Extend.class, attrName="extend")}, extWhereKeys="dsf", orderBy="a.tree_sort, a.office_code")
public class Office
extends TreeEntity<Office> {
    private static final long serialVersionUID = 1L;
    private String officeCode;
    private String viewCode;
    private String officeName;
    private String fullName;
    private String officeType;
    private String leader;
    private String phone;
    private String address;
    private String zipCode;
    private String email;
    private Extend extend;
    private String companyCode;

    public Office() {
        this(null);
    }

    public Office(String id) {
        super(id);
    }

    public Office getParent() {
        return (Office)this.parent;
    }

    public void setParent(Office parent) {
        this.parent = parent;
    }

    public String getOfficeCode() {
        return this.officeCode;
    }

    public void setOfficeCode(String officeCode) {
        this.officeCode = officeCode;
    }

    @NotBlank(message="\u673a\u6784\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a")
    @Pattern(regexp="[a-zA-Z0-9_]{0,30}", message="\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e 30 \u4e2a\u5b57\u7b26\uff0c\u5e76\u4e14\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf")
    public @NotBlank(message="\u673a\u6784\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a") @Pattern(regexp="[a-zA-Z0-9_]{0,30}", message="\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e 30 \u4e2a\u5b57\u7b26\uff0c\u5e76\u4e14\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf") String getViewCode() {
        return this.viewCode;
    }

    public void setViewCode(String viewCode) {
        this.viewCode = viewCode;
    }

    @NotBlank(message="\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(min=0, max=100, message="\u673a\u6784\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 100 \u4e2a\u5b57\u7b26")
    public @NotBlank(message="\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") @Length(min=0, max=100, message="\u673a\u6784\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 100 \u4e2a\u5b57\u7b26") String getOfficeName() {
        return this.officeName;
    }

    public void setOfficeName(String officeName) {
        this.officeName = officeName;
    }

    @NotBlank(message="\u673a\u6784\u5168\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(min=0, max=200, message="\u673a\u6784\u5168\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 200 \u4e2a\u5b57\u7b26")
    public @NotBlank(message="\u673a\u6784\u5168\u79f0\u4e0d\u80fd\u4e3a\u7a7a") @Length(min=0, max=200, message="\u673a\u6784\u5168\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 200 \u4e2a\u5b57\u7b26") String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @NotBlank(message="\u673a\u6784\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(min=0, max=1, message="\u673a\u6784\u7c7b\u578b\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 1 \u4e2a\u5b57\u7b26")
    public @NotBlank(message="\u673a\u6784\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") @Length(min=0, max=1, message="\u673a\u6784\u7c7b\u578b\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 1 \u4e2a\u5b57\u7b26") String getOfficeType() {
        return this.officeType;
    }

    public void setOfficeType(String officeType) {
        this.officeType = officeType;
    }

    @Length(min=0, max=100, message="\u8d1f\u8d23\u4eba\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 100 \u4e2a\u5b57\u7b26")
    public @Length(min=0, max=100, message="\u8d1f\u8d23\u4eba\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 100 \u4e2a\u5b57\u7b26") String getLeader() {
        return this.leader;
    }

    public void setLeader(String leader) {
        this.leader = leader;
    }

    @Length(min=0, max=100, message="\u7535\u8bdd\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 100 \u4e2a\u5b57\u7b26")
    public @Length(min=0, max=100, message="\u7535\u8bdd\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 100 \u4e2a\u5b57\u7b26") String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Length(min=0, max=255, message="\u8054\u7cfb\u5730\u5740\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 255 \u4e2a\u5b57\u7b26")
    public @Length(min=0, max=255, message="\u8054\u7cfb\u5730\u5740\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 255 \u4e2a\u5b57\u7b26") String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Length(min=0, max=100, message="\u90ae\u653f\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 100 \u4e2a\u5b57\u7b26")
    public @Length(min=0, max=100, message="\u90ae\u653f\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 100 \u4e2a\u5b57\u7b26") String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    @Length(min=0, max=200, message="\u90ae\u7bb1\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 200 \u4e2a\u5b57\u7b26")
    public @Length(min=0, max=200, message="\u90ae\u7bb1\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 200 \u4e2a\u5b57\u7b26") String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Extend getExtend() {
        return this.extend;
    }

    public void setExtend(Extend extend) {
        this.extend = extend;
    }

    public String getCompanyCode() {
        return this.companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    @JsonIgnore
    public Office getParentByType(String type) {
        if (type == null) {
            return null;
        }
        Office office = EmpUtils.getOffice(this.getOfficeCode());
        if (office == null) {
            return null;
        }
        do {
            if ((office = EmpUtils.getOffice(office.getParentCode())) != null) continue;
            return null;
        } while (!type.equals(office.getOfficeType()));
        return office;
    }

    public String toString() {
        return this.officeCode;
    }
}

