/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.service.support;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.entity.DataEntity;
import com.jeesite.common.entity.TreeEntity;
import com.jeesite.common.service.TreeService;
import com.jeesite.modules.sys.dao.CompanyDao;
import com.jeesite.modules.sys.dao.CompanyOfficeDao;
import com.jeesite.modules.sys.entity.Company;
import com.jeesite.modules.sys.entity.CompanyOffice;
import com.jeesite.modules.sys.service.CompanyService;
import com.jeesite.modules.sys.service.DataScopeService;
import com.jeesite.modules.sys.utils.EmpUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CompanyServiceSupport
extends TreeService<CompanyDao, Company>
implements CompanyService {
    @Autowired
    private CompanyOfficeDao companyOfficeDao;
    @Autowired
    private DataScopeService dataScopeService;

    @Override
    public Company get(Company company) {
        return (Company)super.get((DataEntity)company);
    }

    @Override
    public void addDataScopeFilter(Company company, String ctrlPermi) {
        company.getSqlMap().getDataScope().addFilter("dsf", "Company", "a.company_code", ctrlPermi);
    }

    @Override
    public List<Company> findList(Company company) {
        return super.findList((DataEntity)company);
    }

    @Override
    @Transactional(readOnly=false)
    public void save(Company company) {
        if (company.getIsNewRecord()) {
            this.genIdAndValid((DataEntity)company, company.getViewCode());
            this.dataScopeService.insertIfParentExists((TreeEntity)company, "Company");
        }
        super.save((TreeEntity)company);
        if (StringUtils.isBlank((CharSequence)company.getCompanyCode())) {
            return;
        }
        CompanyOffice where = new CompanyOffice();
        where.setCompanyCode(company.getCompanyCode());
        this.companyOfficeDao.deleteByEntity((Object)where);
        if (ListUtils.isNotEmpty(company.getCompanyOfficeList())) {
            this.companyOfficeDao.insertBatch(company.getCompanyOfficeList());
        }
        this.clearCompanyCache();
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(Company company) {
        super.delete((TreeEntity)company);
        this.clearCompanyCache();
    }

    @Override
    @Transactional(readOnly=false)
    public void updateStatus(Company company) {
        ((CompanyDao)this.dao).updateStatus((Object)company);
        this.clearCompanyCache();
    }

    private void clearCompanyCache() {
        EmpUtils.removeCache("companyAllList");
    }
}

