/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.service.support;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.entity.DataEntity;
import com.jeesite.common.entity.Page;
import com.jeesite.common.service.CrudService;
import com.jeesite.modules.sys.dao.EmployeeDao;
import com.jeesite.modules.sys.dao.EmployeePostDao;
import com.jeesite.modules.sys.entity.Employee;
import com.jeesite.modules.sys.entity.EmployeePost;
import com.jeesite.modules.sys.service.EmployeeService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class EmployeeServiceSupport
extends CrudService<EmployeeDao, Employee>
implements EmployeeService {
    @Autowired
    private EmployeePostDao employeePostDao;

    @Override
    public Employee get(Employee employee) {
        return (Employee)super.get((DataEntity)employee);
    }

    @Override
    public Page<Employee> findPage(Employee employee) {
        return super.findPage((DataEntity)employee);
    }

    @Override
    @Transactional(readOnly=false)
    public void save(Employee employee) {
        if (employee.getIsNewRecord() && ((EmployeeDao)this.dao).get((Object)employee) != null) {
            throw EmployeeServiceSupport.newValidationException((String)"\u5458\u5de5\u7f16\u7801\u5df2\u5b58\u5728");
        }
        super.save((DataEntity)employee);
        EmployeePost where = new EmployeePost();
        where.setEmpCode(employee.getEmpCode());
        this.employeePostDao.deleteByEntity((Object)where);
        if (ListUtils.isNotEmpty(employee.getEmployeePostList())) {
            for (EmployeePost e : employee.getEmployeePostList()) {
                e.setEmpCode(employee.getEmpCode());
            }
            this.employeePostDao.insertBatch(employee.getEmployeePostList());
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(Employee employee) {
        super.delete((DataEntity)employee);
    }

    @Override
    public List<EmployeePost> findEmployeePostList(Employee employee) {
        EmployeePost employeePost = new EmployeePost();
        employeePost.setEmpCode(employee.getEmpCode());
        return this.employeePostDao.findList((Object)employeePost);
    }
}

