/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.service.support;

import com.jeesite.common.entity.DataEntity;
import com.jeesite.common.entity.TreeEntity;
import com.jeesite.common.service.TreeService;
import com.jeesite.modules.sys.dao.OfficeDao;
import com.jeesite.modules.sys.entity.Office;
import com.jeesite.modules.sys.service.DataScopeService;
import com.jeesite.modules.sys.service.OfficeService;
import com.jeesite.modules.sys.utils.EmpUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class OfficeServiceSupport
extends TreeService<OfficeDao, Office>
implements OfficeService {
    @Autowired
    private DataScopeService dataScopeService;

    @Override
    public Office get(Office office) {
        return (Office)super.get((DataEntity)office);
    }

    @Override
    public void addDataScopeFilter(Office office, String ctrlPermi) {
        office.getSqlMap().getDataScope().addFilter("dsf", "Office", "a.office_code", ctrlPermi);
    }

    @Override
    public List<Office> findList(Office office) {
        return super.findList((DataEntity)office);
    }

    @Override
    @Transactional(readOnly=false)
    public void save(Office office) {
        if (office.getIsNewRecord()) {
            this.genIdAndValid((DataEntity)office, office.getViewCode());
            this.dataScopeService.insertIfParentExists((TreeEntity)office, "Office");
        }
        super.save((TreeEntity)office);
        this.clearOfficeCache();
    }

    @Override
    @Transactional(readOnly=false)
    public void updateStatus(Office office) {
        super.updateStatus((TreeEntity)office);
        this.clearOfficeCache();
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(Office office) {
        super.delete((TreeEntity)office);
        this.clearOfficeCache();
    }

    private void clearOfficeCache() {
        EmpUtils.removeCache("officeAllList");
    }
}

