/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.utils;

import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.utils.SpringUtils;
import com.jeesite.modules.sys.entity.Company;
import com.jeesite.modules.sys.entity.Employee;
import com.jeesite.modules.sys.entity.Office;
import com.jeesite.modules.sys.entity.User;
import com.jeesite.modules.sys.service.CompanyService;
import com.jeesite.modules.sys.service.OfficeService;
import com.jeesite.modules.sys.utils.CorpUtils;
import com.jeesite.modules.sys.utils.UserUtils;
import java.util.List;

public class EmpUtils {
    public static final String CACHE_OFFICE_ALL_LIST = "officeAllList";
    public static final String CACHE_COMPANY_ALL_LIST = "companyAllList";

    public static Employee getEmployee() {
        User user = UserUtils.getUser();
        Employee employee = null;
        if ("employee".equals(user.getUserType())) {
            employee = (Employee)((Object)UserUtils.getUser().getRefObj());
        }
        if (employee == null) {
            employee = new Employee();
        }
        return employee;
    }

    public static Office getOffice() {
        return EmpUtils.getEmployee().getOffice();
    }

    public static Office getOffice(String officeCode) {
        List<Office> officeList = EmpUtils.getOfficeAllList();
        for (Office office : officeList) {
            if (!office.getOfficeCode().equals(officeCode)) continue;
            return office;
        }
        return null;
    }

    public static List<Office> getOfficeAllList() {
        List<Office> officeList = (List<Office>)CorpUtils.getCache((String)CACHE_OFFICE_ALL_LIST);
        if (officeList == null) {
            Office where = new Office();
            where.setStatus("0");
            officeList = Static.officeService.findList(where);
            CorpUtils.putCache((String)CACHE_OFFICE_ALL_LIST, officeList);
        }
        return officeList;
    }

    public static Company getCompany() {
        return EmpUtils.getEmployee().getCompany();
    }

    public static Company getCompany(String companyCode) {
        List<Company> companyList = EmpUtils.getCompanyAllList();
        for (Company company : companyList) {
            if (!company.getCompanyCode().equals(companyCode)) continue;
            return company;
        }
        return null;
    }

    public static List<Company> getCompanyAllList() {
        List<Company> companyList = (List<Company>)CorpUtils.getCache((String)CACHE_COMPANY_ALL_LIST);
        if (companyList == null) {
            Company where = new Company();
            where.setStatus("0");
            companyList = Static.companyService.findList(where);
            CorpUtils.putCache((String)CACHE_COMPANY_ALL_LIST, companyList);
        }
        return companyList;
    }

    public static void removeCache(String key) {
        if (StringUtils.inString((String)key, (String[])new String[]{CACHE_OFFICE_ALL_LIST, CACHE_COMPANY_ALL_LIST})) {
            CorpUtils.removeCache((String)key);
        }
    }

    private static final class Static {
        private static OfficeService officeService = (OfficeService)SpringUtils.getBean(OfficeService.class);
        private static CompanyService companyService = (CompanyService)SpringUtils.getBean(CompanyService.class);

        private Static() {
        }
    }
}

