/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.utils;

import com.jeesite.common.config.Global;
import com.jeesite.common.entity.BaseEntity;
import com.jeesite.common.lang.ExceptionUtils;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mybatis.annotation.Column;
import com.jeesite.common.mybatis.annotation.Table;
import com.jeesite.common.mybatis.mapper.MapperHelper;
import com.jeesite.common.network.IpUtils;
import com.jeesite.common.utils.SpringUtils;
import com.jeesite.common.web.http.UserAgentUtils;
import com.jeesite.modules.sys.entity.Log;
import com.jeesite.modules.sys.entity.User;
import com.jeesite.modules.sys.service.LogService;
import com.jeesite.modules.sys.service.MenuService;
import eu.bitwalker.useragentutils.UserAgent;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.method.HandlerMethod;

public class LogUtils {
    private static ParameterNameDiscoverer pnd = new DefaultParameterNameDiscoverer();

    public static void saveLog(User user, HttpServletRequest request, String logTitle, String logType) {
        LogUtils.saveLog(user, request, null, null, logTitle, logType, 0L);
    }

    public static void saveLog(User user, HttpServletRequest request, Object handler, Exception ex, String logTitle, String logType, long executeTime) {
        if (user == null || StringUtils.isBlank((CharSequence)user.getUserCode()) || request == null) {
            return;
        }
        Log log = new Log();
        log.setLogTitle(logTitle);
        log.setLogType(logType);
        if (StringUtils.isBlank((CharSequence)log.getLogType())) {
            String sqlCommandTypes = ObjectUtils.toString((Object)request.getAttribute(SqlCommandType.class.getName()));
            if (StringUtils.containsAny((CharSequence)("," + sqlCommandTypes + ","), (CharSequence[])new CharSequence[]{",INSERT,", ",UPDATE,", ",DELETE,"})) {
                log.setLogType("update");
            } else if (StringUtils.contains((CharSequence)("," + sqlCommandTypes + ","), (CharSequence)",SELECT,")) {
                log.setLogType("select");
            } else {
                log.setLogType("access");
            }
        }
        log.setServerAddr(request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort());
        log.setRemoteAddr(IpUtils.getRemoteAddr((HttpServletRequest)request));
        UserAgent userAgent = UserAgentUtils.getUserAgent((HttpServletRequest)request);
        log.setDeviceName(userAgent.getOperatingSystem().getName());
        log.setBrowserName(userAgent.getBrowser().getName());
        log.setUserAgent(request.getHeader("User-Agent"));
        log.setRequestUri(StringUtils.abbr((String)request.getRequestURI(), (int)255));
        log.setRequestParams(request.getParameterMap());
        log.setRequestMethod(request.getMethod());
        if (Global.isUseCorpModel().booleanValue()) {
            log.setCorpCode(user.getCorpCode());
            log.setCorpName(user.getCorpName());
        }
        log.setExecuteTime(executeTime);
        log.setCurrentUser(user);
        log.preInsert();
        Throwable throwable = null;
        if (ex != null) {
            throwable = ExceptionUtils.getThrowable((HttpServletRequest)request);
        }
        new SaveLogThread(log, handler, request.getContextPath(), throwable).start();
    }

    public static class SaveLogThread
    extends Thread {
        private Log log;
        private Object handler;
        private String contextPath;
        private Throwable throwable;

        public SaveLogThread(Log log, Object handler, String contextPath, Throwable throwable) {
            super(SaveLogThread.class.getSimpleName());
            this.log = log;
            this.handler = handler;
            this.contextPath = contextPath;
            this.throwable = throwable;
        }

        @Override
        public void run() {
            if (StringUtils.isBlank((CharSequence)this.log.getLogTitle())) {
                String href;
                String permission = "";
                if (this.handler instanceof HandlerMethod) {
                    HandlerMethod hm = (HandlerMethod)this.handler;
                    Method m = hm.getMethod();
                    RequiresPermissions rp = m.getAnnotation(RequiresPermissions.class);
                    permission = rp != null ? StringUtils.join((Object[])rp.value(), (String)",") : "";
                    block4: for (Class<?> clazz : m.getParameterTypes()) {
                        try {
                            Class<?> superClass;
                            for (superClass = clazz.getSuperclass(); superClass != null && superClass != BaseEntity.class; superClass = superClass.getSuperclass()) {
                            }
                            if (superClass == null) continue;
                            Table t = clazz.getAnnotation(Table.class);
                            for (Column c : t.columns()) {
                                if (!c.isPK()) continue;
                                try {
                                    String attrName = MapperHelper.getAttrName((Column)c);
                                    if (attrName == null) continue;
                                    this.log.setBizKey(this.log.getRequestParam(attrName));
                                    this.log.setBizType(clazz.getSimpleName());
                                }
                                catch (Exception e) {
                                    continue block4;
                                }
                            }
                        }
                        catch (Exception e) {
                            break;
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)this.log.getBizKey())) {
                        for (GenericDeclaration genericDeclaration : hm.getBeanType().getMethods()) {
                            String[] ps;
                            ModelAttribute ma = (ModelAttribute)AnnotationUtils.findAnnotation((Method)genericDeclaration, ModelAttribute.class);
                            if (ma == null || (ps = pnd.getParameterNames((Method)genericDeclaration)) == null || ps.length <= 0) continue;
                            this.log.setBizKey(StringUtils.abbr((String)this.log.getRequestParam(ps[0]), (int)64));
                            this.log.setBizType(((Method)genericDeclaration).getReturnType().getSimpleName());
                            break;
                        }
                    }
                }
                if (StringUtils.startsWith((CharSequence)(href = this.log.getRequestUri()), (CharSequence)this.contextPath)) {
                    href = StringUtils.substringAfter((String)href, (String)this.contextPath);
                }
                if (StringUtils.startsWith((CharSequence)href, (CharSequence)Global.getAdminPath())) {
                    href = StringUtils.substringAfter((String)href, (String)Global.getAdminPath());
                }
                if (StringUtils.startsWith((CharSequence)href, (CharSequence)Global.getFrontPath())) {
                    href = StringUtils.substringAfter((String)href, (String)Global.getFrontPath());
                }
                this.log.setLogTitle(Static.menuService.getMenuNamePath(href, permission));
            }
            if (StringUtils.isBlank((CharSequence)this.log.getLogTitle())) {
                this.log.setLogTitle("\u672a\u77e5\u64cd\u4f5c");
            }
            this.log.setIsException(this.throwable != null ? "1" : "0");
            this.log.setExceptionInfo(ExceptionUtils.getStackTraceAsString((Throwable)this.throwable));
            if (StringUtils.isBlank((CharSequence)this.log.getRequestUri()) && StringUtils.isBlank((CharSequence)this.log.getExceptionInfo())) {
                return;
            }
            this.log.setIsNewRecord(true);
            Static.logService.insertLog(this.log);
        }
    }

    private static final class Static {
        private static LogService logService = (LogService)SpringUtils.getBean(LogService.class);
        private static MenuService menuService = (MenuService)SpringUtils.getBean(MenuService.class);

        private Static() {
        }
    }
}

