/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.web;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.collect.MapUtils;
import com.jeesite.common.entity.DataEntity;
import com.jeesite.common.idgen.IdGen;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.sys.entity.Area;
import com.jeesite.modules.sys.service.AreaService;
import com.jeesite.modules.sys.utils.AreaUtils;
import com.jeesite.modules.sys.utils.UserUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/area"})
@ConditionalOnProperty(name={"web.core.enabled"}, havingValue="true", matchIfMissing=true)
public class AreaController
extends BaseController {
    @Autowired
    private AreaService areaService;

    @ModelAttribute
    public Area get(String areaCode, boolean isNewRecord) {
        return (Area)this.areaService.get(areaCode, isNewRecord);
    }

    @RequiresPermissions(value={"sys:area:view"})
    @RequestMapping(value={"list"})
    public String list(Area area, Model model) {
        return "modules/sys/areaList";
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public List<Area> listData(Area area) {
        if (StringUtils.isBlank((CharSequence)area.getParentCode())) {
            area.setParentCode("0");
        }
        if (StringUtils.isNotBlank((CharSequence)area.getAreaCode()) || StringUtils.isNotBlank((CharSequence)area.getAreaName())) {
            area.setParentCode(null);
        }
        List<Area> list = this.areaService.findList(area);
        return list;
    }

    @RequiresPermissions(value={"sys:area:view"})
    @RequestMapping(value={"form"})
    public String form(Area area, Model model) {
        area = this.createNextNode(area);
        model.addAttribute("area", (Object)area);
        return "modules/sys/areaForm";
    }

    @RequiresPermissions(value={"sys:area:edit"})
    @RequestMapping(value={"createNextNode"})
    @ResponseBody
    public Area createNextNode(Area area) {
        if (StringUtils.isNotBlank((CharSequence)area.getParentCode())) {
            area.setParent((Area)this.areaService.get(area.getParentCode()));
        }
        if (area.getIsNewRecord()) {
            Area where = new Area();
            where.setParentCode(area.getParentCode());
            Area last = (Area)this.areaService.getLastByParentCode(where);
            if (last != null) {
                area.setTreeSort(last.getTreeSort() + 30);
                area.setAreaCode(IdGen.nextCode((String)last.getAreaCode()));
            } else if (area.getParent() != null) {
                area.setAreaCode((Object)((Object)area.getParent()) + "001");
            }
        }
        if (area.getTreeSort() == null) {
            area.setTreeSort(30);
        }
        return area;
    }

    @RequiresPermissions(value={"sys:area:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated Area area, Model model) {
        this.areaService.save(area);
        return this.renderResult("true", "\u4fdd\u5b58\u533a\u57df'" + area.getAreaName() + "'\u6210\u529f");
    }

    @RequiresPermissions(value={"sys:area:edit"})
    @RequestMapping(value={"disable"})
    @ResponseBody
    public String disable(Area area) {
        Area where = new Area();
        where.setStatus("0");
        where.setParentCodes("," + area.getId() + ",");
        long count = this.areaService.findCount((DataEntity)where);
        if (count > 0L) {
            return this.renderResult("false", "\u8be5\u533a\u57df\u5305\u542b\u672a\u505c\u7528\u7684\u5b50\u533a\u57df\uff01");
        }
        area.setStatus("2");
        this.areaService.updateStatus(area);
        return this.renderResult("true", "\u505c\u7528\u533a\u57df" + area.getAreaName() + "\u6210\u529f");
    }

    @RequiresPermissions(value={"sys:area:edit"})
    @RequestMapping(value={"enable"})
    @ResponseBody
    public String enable(Area area) {
        area.setStatus("0");
        this.areaService.updateStatus(area);
        return this.renderResult("true", "\u542f\u7528\u533a\u57df" + area.getAreaName() + "\u6210\u529f");
    }

    @RequiresPermissions(value={"sys:area:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(Area area) {
        this.areaService.delete(area);
        return this.renderResult("true", "\u5220\u9664\u533a\u57df\u6210\u529f");
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"treeData"})
    @ResponseBody
    public List<Map<String, Object>> treeData(String excludeCode, String isShowCode) {
        ArrayList mapList = ListUtils.newArrayList();
        List<Area> list = AreaUtils.getAreaAllList();
        for (int i = 0; i < list.size(); ++i) {
            Area e = list.get(i);
            if (!"0".equals(e.getStatus()) || StringUtils.isNotBlank((CharSequence)excludeCode) && (e.getId().equals(excludeCode) || e.getParentCodes().contains("," + excludeCode + ","))) continue;
            HashMap map = MapUtils.newHashMap();
            map.put("id", e.getId());
            map.put("pId", e.getParentCode());
            map.put("name", StringUtils.getTreeNodeName((String)isShowCode, (String)e.getId(), (String)e.getAreaName()));
            mapList.add(map);
        }
        return mapList;
    }

    @RequiresPermissions(value={"sys:area:edit"})
    @RequestMapping(value={"fixTreeData"})
    @ResponseBody
    public String fixTreeData() {
        if (!UserUtils.getUser().isAdmin()) {
            return this.renderResult("false", "\u64cd\u4f5c\u5931\u8d25\uff0c\u53ea\u6709\u7ba1\u7406\u5458\u624d\u80fd\u8fdb\u884c\u4fee\u590d\uff01");
        }
        this.areaService.fixTreeData();
        return this.renderResult("true", "\u6570\u636e\u4fee\u590d\u6210\u529f");
    }
}

