/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.web;

import com.jeesite.common.entity.Page;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.sys.entity.Log;
import com.jeesite.modules.sys.service.LogService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/log"})
@ConditionalOnProperty(name={"web.core.enabled"}, havingValue="true", matchIfMissing=true)
public class LogController
extends BaseController {
    @Autowired
    private LogService logService;

    @ModelAttribute
    public Log get(String id, boolean isNewRecord) {
        return (Log)this.logService.get(id, isNewRecord);
    }

    @RequiresPermissions(value={"sys:log:view"})
    @RequestMapping(value={"list"})
    public String list(Log log, Model model) {
        model.addAttribute("log", (Object)log);
        return "modules/sys/logList";
    }

    @RequiresPermissions(value={"sys:log:view"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public Page<Log> listData(Log log, HttpServletRequest request, HttpServletResponse response) {
        log.setPage(new Page(request, response));
        Page<Log> page = this.logService.findPage(log);
        return page;
    }

    @RequiresPermissions(value={"sys:log:view"})
    @RequestMapping(value={"form"})
    public String form(Log log, Model model) {
        model.addAttribute("log", (Object)log);
        return "modules/sys/logForm";
    }
}

