/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.web;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.collect.MapUtils;
import com.jeesite.common.entity.DataEntity;
import com.jeesite.common.idgen.IdGen;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.sys.entity.Office;
import com.jeesite.modules.sys.service.OfficeService;
import com.jeesite.modules.sys.utils.UserUtils;
import com.jeesite.modules.sys.web.user.EmpUserController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/office"})
@ConditionalOnProperty(name={"web.core.enabled"}, havingValue="true", matchIfMissing=true)
public class OfficeController
extends BaseController {
    @Autowired
    private OfficeService officeService;
    @Autowired
    private EmpUserController empUserController;

    @ModelAttribute
    public Office get(String officeCode, boolean isNewRecord) {
        return (Office)this.officeService.get(officeCode, isNewRecord);
    }

    @RequiresPermissions(value={"sys:office:view"})
    @RequestMapping(value={"list"})
    public String list(Office office, Model model) {
        model.addAttribute("office", (Object)office);
        return "modules/sys/officeList";
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public List<Office> listData(Office office, String ctrlPermi) {
        if (StringUtils.isBlank((CharSequence)office.getParentCode())) {
            office.setParentCode("0");
        }
        if (StringUtils.isNotBlank((CharSequence)office.getViewCode()) || StringUtils.isNotBlank((CharSequence)office.getOfficeName()) || StringUtils.isNotBlank((CharSequence)office.getFullName())) {
            office.setParentCode(null);
        }
        this.officeService.addDataScopeFilter(office, ctrlPermi);
        List<Office> list = this.officeService.findList(office);
        return list;
    }

    @RequiresPermissions(value={"sys:office:view"})
    @RequestMapping(value={"form"})
    public String form(Office office, Model model) {
        if (StringUtils.isNotBlank((CharSequence)(office = this.createNextNode(office)).getParentCode())) {
            office.setParent((Office)this.officeService.get(office.getParentCode()));
        }
        if (office.getIsNewRecord()) {
            office.setTreeSort(30);
            Office where = new Office();
            where.setParentCode(office.getParentCode());
            Office last = (Office)this.officeService.getLastByParentCode(where);
            if (last != null) {
                office.setTreeSort(last.getTreeSort() + 30);
                office.setViewCode(IdGen.nextCode((String)last.getViewCode()));
            } else if (office.getParent() != null) {
                office.setViewCode(office.getParent().getViewCode() + "001");
            }
        }
        model.addAttribute("office", (Object)office);
        return "modules/sys/officeForm";
    }

    @RequiresPermissions(value={"sys:office:edit"})
    @RequestMapping(value={"createNextNode"})
    @ResponseBody
    public Office createNextNode(Office office) {
        if (StringUtils.isNotBlank((CharSequence)office.getParentCode())) {
            office.setParent((Office)this.officeService.get(office.getParentCode()));
        }
        if (office.getIsNewRecord()) {
            Office where = new Office();
            where.setParentCode(office.getParentCode());
            Office last = (Office)this.officeService.getLastByParentCode(where);
            if (last != null) {
                office.setTreeSort(last.getTreeSort() + 30);
                office.setViewCode(IdGen.nextCode((String)last.getViewCode()));
            } else if (office.getParent() != null) {
                office.setViewCode(office.getParent().getViewCode() + "001");
            }
        }
        if (office.getTreeSort() == null) {
            office.setTreeSort(30);
        }
        return office;
    }

    @RequiresPermissions(value={"sys:office:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated Office office, String cmd, Model model) {
        this.officeService.save(office);
        return this.renderResult("true", OfficeController.text((String)"\u4fdd\u5b58\u673a\u6784''{0}''\u6210\u529f", (String[])new String[]{office.getOfficeName()}));
    }

    @RequiresPermissions(value={"sys:office:edit"})
    @RequestMapping(value={"disable"})
    @ResponseBody
    public String disable(Office office) {
        Office where = new Office();
        where.setStatus("0");
        where.setParentCodes("," + office.getId() + ",");
        long count = this.officeService.findCount((DataEntity)where);
        if (count > 0L) {
            return this.renderResult("false", OfficeController.text((String)"\u8be5\u673a\u6784\u5305\u542b\u672a\u505c\u7528\u7684\u5b50\u673a\u6784\uff01", (String[])new String[0]));
        }
        office.setStatus("2");
        this.officeService.updateStatus(office);
        return this.renderResult("true", OfficeController.text((String)"\u505c\u7528\u673a\u6784''{0}''\u6210\u529f", (String[])new String[]{office.getOfficeName()}));
    }

    @RequiresPermissions(value={"sys:office:edit"})
    @RequestMapping(value={"enable"})
    @ResponseBody
    public String enable(Office office) {
        office.setStatus("0");
        this.officeService.updateStatus(office);
        return this.renderResult("true", OfficeController.text((String)"\u542f\u7528\u673a\u6784''{0}''\u6210\u529f", (String[])new String[]{office.getOfficeName()}));
    }

    @RequiresPermissions(value={"sys:office:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(Office office) {
        this.officeService.delete(office);
        return this.renderResult("true", OfficeController.text((String)"\u5220\u9664\u673a\u6784''{0}''\u6210\u529f", (String[])new String[]{office.getOfficeName()}));
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"treeData"})
    @ResponseBody
    public List<Map<String, Object>> treeData(String excludeCode, String parentCode, Boolean isAll, String officeTypes, String companyCode, String isShowCode, String isShowFullName, Boolean isLoadUser, String postCode, String roleCode, String ctrlPermi) {
        ArrayList mapList = ListUtils.newArrayList();
        Office where = new Office();
        where.setStatus("0");
        where.setCompanyCode(companyCode);
        if (isAll == null || !isAll.booleanValue()) {
            this.officeService.addDataScopeFilter(where, ctrlPermi);
        }
        List<Office> list = this.officeService.findList(where);
        for (int i = 0; i < list.size(); ++i) {
            Office e = list.get(i);
            if (!"0".equals(e.getStatus()) || StringUtils.isNotBlank((CharSequence)excludeCode) && (e.getId().equals(excludeCode) || e.getParentCodes().contains("," + excludeCode + ",")) || StringUtils.isNotBlank((CharSequence)parentCode) && (!e.getOfficeCode().equals(parentCode) || !e.getParentCodes().contains("," + parentCode + ",")) || StringUtils.isNotBlank((CharSequence)officeTypes) && !StringUtils.inString((String)e.getOfficeType(), (String[])officeTypes.split(","))) continue;
            HashMap map = MapUtils.newHashMap();
            map.put("id", e.getId());
            map.put("pId", e.getParentCode());
            String name = e.getOfficeName();
            if ("true".equals(isShowFullName) || "1".equals(isShowFullName)) {
                name = e.getFullName();
            }
            map.put("name", StringUtils.getTreeNodeName((String)isShowCode, (String)e.getViewCode(), (String)name));
            map.put("title", e.getFullName());
            if (isLoadUser != null && isLoadUser.booleanValue()) {
                map.put("isParent", true);
                List<Map<String, Object>> userList = this.empUserController.treeData("u_", e.getOfficeCode(), e.getOfficeCode(), companyCode, postCode, roleCode, isAll, isShowCode, ctrlPermi);
                mapList.addAll(userList);
            }
            mapList.add(map);
        }
        return mapList;
    }

    @RequiresPermissions(value={"sys:office:edit"})
    @RequestMapping(value={"fixTreeData"})
    @ResponseBody
    public String fixTreeData() {
        if (!UserUtils.getUser().isAdmin()) {
            return this.renderResult("false", "\u64cd\u4f5c\u5931\u8d25\uff0c\u53ea\u6709\u7ba1\u7406\u5458\u624d\u80fd\u8fdb\u884c\u4fee\u590d\uff01");
        }
        this.officeService.fixTreeData();
        return this.renderResult("true", "\u6570\u636e\u4fee\u590d\u6210\u529f");
    }
}

