/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.web;

import com.jeesite.common.cache.CacheUtils;
import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.collect.MapUtils;
import com.jeesite.common.lang.DateUtils;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.lang.TimeUtils;
import com.jeesite.common.shiro.realm.LoginInfo;
import com.jeesite.common.shiro.session.SessionDAO;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.sys.utils.UserUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/online"})
@ConditionalOnProperty(name={"web.core.enabled"}, havingValue="true", matchIfMissing=true)
public class OnlineController
extends BaseController {
    @Autowired
    private SessionDAO sessionDAO;

    @RequestMapping(value={"count"})
    @ResponseBody
    public Integer count(HttpServletRequest request, HttpServletResponse response) {
        return this.sessionDAO.getActiveSessions(true, true).size();
    }

    @RequiresPermissions(value={"sys:online:view"})
    @RequestMapping(value={"list"})
    public String list(Model model) {
        return "modules/sys/onlineList";
    }

    @RequiresPermissions(value={"sys:online:view"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public List<Map<String, Object>> listData(String isAllOnline, String isVisitor, String sessionId, String userCode, String userName, String userType, String orderBy) {
        String[] ss;
        ArrayList list = ListUtils.newArrayList();
        boolean excludeLeave = isAllOnline == null || !"1".equals(isAllOnline);
        boolean excludeVisitor = isVisitor == null || !"1".equals(isVisitor);
        Collection sessions = this.sessionDAO.getActiveSessions(excludeLeave, excludeVisitor, null, sessionId, userCode);
        long currentTime = System.currentTimeMillis();
        for (Session session : sessions) {
            LoginInfo loginInfo;
            if (StringUtils.isNotBlank((CharSequence)userName) && ((String)session.getAttribute((Object)"userName")).contains(userName) || StringUtils.isNotBlank((CharSequence)userType) && ((String)session.getAttribute((Object)"userType")).equals(userType)) continue;
            LinkedHashMap map = MapUtils.newLinkedHashMap();
            if (UserUtils.getSubject().isPermitted("sys:online:edit")) {
                map.put("id", session.getId().toString());
            }
            map.put("startTimestamp", DateUtils.formatDateTime((Date)session.getStartTimestamp()));
            map.put("lastAccessTime", DateUtils.formatDateTime((Date)session.getLastAccessTime()));
            map.put("timeout", TimeUtils.formatDateAgo((long)(session.getTimeout() - (currentTime - session.getLastAccessTime().getTime()))));
            Object pc = session.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
            if (pc != null && pc instanceof PrincipalCollection && (loginInfo = (LoginInfo)((PrincipalCollection)pc).getPrimaryPrincipal()) != null) {
                map.put("userCode", session.getAttribute((Object)"userCode"));
                map.put("userName", session.getAttribute((Object)"userName"));
                map.put("userType", session.getAttribute((Object)"userType"));
                map.put("deviceType", ObjectUtils.toString((Object)loginInfo.getParam("deviceType")));
            }
            map.put("host", session.getHost());
            list.add(map);
        }
        if (StringUtils.isNotBlank((CharSequence)orderBy) && (ss = orderBy.trim().split(" ")) != null && ss.length == 2) {
            Collections.sort(list, new Comparator<Map<String, Object>>(){

                @Override
                public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                    String s1 = (String)o1.get(ss[0]);
                    String s2 = (String)o2.get(ss[0]);
                    if ("asc".equals(ss[1])) {
                        return s1.compareTo(s2);
                    }
                    return s2.compareTo(s1);
                }
            });
        }
        return list;
    }

    @RequiresPermissions(value={"sys:online:edit"})
    @RequestMapping(value={"tickOut"})
    @ResponseBody
    public String tickOut(String sessionId) {
        Session session = this.sessionDAO.readSession((Serializable)((Object)sessionId));
        if (session != null) {
            PrincipalCollection pc;
            LoginInfo principal;
            Map onlineTickOutMap = (Map)CacheUtils.get((String)"onlineTickOutMap");
            if (onlineTickOutMap == null) {
                onlineTickOutMap = MapUtils.newConcurrentMap();
            }
            LoginInfo loginInfo = principal = (pc = (PrincipalCollection)session.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY)) != null ? (LoginInfo)pc.getPrimaryPrincipal() : null;
            if (principal != null) {
                onlineTickOutMap.put(principal.getId() + "_" + principal.getParam("deviceType", "PC"), "");
            }
            CacheUtils.put((String)"onlineTickOutMap", (Object)onlineTickOutMap);
            this.sessionDAO.delete(session);
            return this.renderResult("true", "\u8e22\u51fa\u5df2\u6210\u529f\uff01");
        }
        return this.renderResult("false", "\u8e22\u51fa\u5931\u8d25\uff0c\u6ca1\u6709\u627e\u5230\u8be5\u5728\u7ebf\u7528\u6237\uff01");
    }
}

