/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.web.user;

import com.jeesite.common.entity.Page;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.sys.entity.User;
import com.jeesite.modules.sys.entity.UserDataScope;
import com.jeesite.modules.sys.service.UserService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/secAdmin"})
@ConditionalOnProperty(name={"web.core.enabled"}, havingValue="true", matchIfMissing=true)
public class SecAdminController
extends BaseController {
    @Autowired
    private UserService userService;

    @ModelAttribute
    public User get(String userCode, boolean isNewRecord) {
        return (User)this.userService.get(userCode, isNewRecord);
    }

    @RequiresPermissions(value={"sys:secAdmin:view"})
    @RequestMapping(value={"list"})
    public String list(User user, Model model) {
        return "modules/sys/user/secAdminList";
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public Page<User> listData(User user, HttpServletRequest request, HttpServletResponse response) {
        user.setMgrType("2");
        user.setPage(new Page(request, response));
        Page page = this.userService.findPage(user);
        return page;
    }

    @RequiresPermissions(value={"sys:secAdmin:view"})
    @RequestMapping(value={"form"})
    public String form(User user, String op, Model model) {
        UserDataScope userDataScope = new UserDataScope();
        userDataScope.setUserCode(user.getUserCode());
        userDataScope.setCtrlPermi("2");
        List userDataScopeList = this.userService.findDataScopeList(userDataScope);
        model.addAttribute("userDataScopeList", (Object)userDataScopeList);
        model.addAttribute("user", (Object)user);
        return "modules/sys/user/secAdminForm";
    }

    @RequiresPermissions(value={"sys:secAdmin:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated User user, String op) {
        if (User.isSuperAdmin((String)user.getUserCode())) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u80fd\u591f\u64cd\u4f5c\u6b64\u7528\u6237\uff01");
        }
        if (!"employee".equals(user.getUserType())) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u80fd\u591f\u64cd\u4f5c\u6b64\u7528\u6237\uff01");
        }
        user.setMgrType("2");
        this.userService.updateMgrType(user);
        this.userService.saveAuthDataScope(user);
        return this.renderResult("true", "\u4fdd\u5b58\u7528\u6237'" + user.getUserName() + "'\u6210\u529f");
    }

    @RequiresPermissions(value={"sys:secAdmin:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(User user) {
        if (User.isSuperAdmin((String)user.getUserCode())) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u80fd\u591f\u64cd\u4f5c\u6b64\u7528\u6237\uff01");
        }
        if (!"employee".equals(user.getUserType())) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u80fd\u591f\u64cd\u4f5c\u6b64\u7528\u6237\uff01");
        }
        user.setMgrType("2");
        user.setUserDataScopeListJson("[]");
        this.userService.saveAuthDataScope(user);
        user.setMgrType("0");
        this.userService.updateMgrType(user);
        return this.renderResult("true", "\u53d6\u6d88\u7528\u6237'" + user.getUserName() + "'\u7ba1\u7406\u5458\u8eab\u4efd\u6210\u529f\uff01");
    }
}

