/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.cache;

import com.jeesite.common.cache.g;
import com.jeesite.common.collect.SetUtils;
import com.jeesite.common.config.Global;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mybatis.mapper.query.QueryDataScope;
import com.jeesite.common.shiro.cas.CasOutHandler;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.shiro.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheUtils {
    private static final String SYS_CACHE = "sysCache";
    private static Logger logger = LoggerFactory.getLogger(CacheUtils.class);

    public static Object get(String key, Object defaultValue) {
        Object a2 = CacheUtils.get(key);
        if (a2 != null) {
            return a2;
        }
        return defaultValue;
    }

    public static void put(String key, Object value) {
        CacheUtils.put(SYS_CACHE, key, value);
    }

    public static void removeByKeyPrefix(String cacheName, String keyPrefix) {
        String a2 = keyPrefix;
        Cache<String, Object> a3 = CacheUtils.getCache(cacheName);
        Set a4 = a3.keys();
        HashSet a5 = SetUtils.newHashSet();
        for (String a6 : a4) {
            if (!StringUtils.startsWith((CharSequence)a6, (CharSequence)a2)) continue;
            a3.remove((Object)a6);
            a5.add(a6);
        }
        logger.info(QueryDataScope.ALLATORIxDEMO("\u6e30\u7459\u7f26\u5b07\uff2f\u007fN\"\u0015b\u000b\u007fN\""), (Object)cacheName, (Object)a5);
    }

    public static void remove(String key) {
        CacheUtils.remove(SYS_CACHE, key);
    }

    public static void clearCache() {
        int n;
        String a2 = Global.getConfig(CasOutHandler.ALLATORIxDEMO("(R.[.R(\u0014.V([?t,W(I"));
        if (StringUtils.isBlank((CharSequence)a2)) {
            return;
        }
        String[] stringArray = a2.split(QueryDataScope.ALLATORIxDEMO("s"));
        int n2 = stringArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            CacheUtils.removeAll(stringArray[n++]);
            n3 = n;
        }
    }

    public static Object get(String cacheName, String key) {
        return CacheUtils.getCache(cacheName).get((Object)key);
    }

    public static void remove(String cacheName, String key) {
        CacheUtils.getCache(cacheName).remove((Object)key);
    }

    public static void put(String cacheName, String key, Object value) {
        CacheUtils.getCache(cacheName).put((Object)key, value);
    }

    public static Object get(String key) {
        return CacheUtils.get(SYS_CACHE, key);
    }

    public static String[] getCacheNames() {
        return g.ALLATORIxDEMO().getCacheNames();
    }

    public static void removeAll(String cacheName) {
        Iterator a2;
        Cache<String, Object> a3 = CacheUtils.getCache(cacheName);
        Set a4 = a3.keys();
        Iterator iterator = a2 = a4.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = a2;
            iterator = iterator2;
            a3.remove(iterator2.next());
        }
        logger.info(CasOutHandler.ALLATORIxDEMO("\u6e48\u743c\u7f5e\u5b62\uff57\u001a6Gm\u0007s\u001a6G"), (Object)cacheName, (Object)a4);
    }

    public static Object get(String cacheName, String key, Object defaultValue) {
        Object a2 = CacheUtils.get(cacheName, key);
        if (a2 != null) {
            return a2;
        }
        return defaultValue;
    }

    public static Cache<String, Object> getCache(String cacheName) {
        Cache a2 = g.ALLATORIxDEMO().getCache(cacheName);
        if (a2 == null) {
            throw new RuntimeException(new StringBuilder().insert(0, QueryDataScope.ALLATORIxDEMO("\u5f66\u5212\u7cce\u7e80\u4e18\u6cfe\u673c\u5bc5\u4e7c\u2043")).append(cacheName).append(CasOutHandler.ALLATORIxDEMO("\u2050\u8fe3\u4e67\u7f29\u5b15\u3038")).toString());
        }
        return a2;
    }
}

