/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.job.service;

import com.beust.jcommander.internal.Lists;
import com.jeesite.common.config.Global;
import com.jeesite.common.datasource.RoutingDataSource;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.n.v.F;
import com.jeesite.common.n.v.d;
import com.jeesite.common.service.CrudService;
import com.jeesite.common.service.ServiceException;
import com.jeesite.modules.job.dao.JobDao;
import com.jeesite.modules.job.entity.JobEntity;
import com.jeesite.modules.job.listener.JobDetalListener;
import com.jeesite.modules.job.listener.JobSchedulerListener;
import com.jeesite.modules.job.listener.JobTriggerListener;
import com.jeesite.modules.job.n.D;
import com.jeesite.modules.job.service.JobLogService;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.quartz.JobListener;
import org.quartz.ListenerManager;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DependsOn(value={"dbUpgrade"})
@Transactional(readOnly=true)
public class JobService
extends CrudService<JobDao, JobEntity> {
    private SchedulerFactoryBean scheduler;
    @Autowired
    private JobLogService jobLogService;
    @Autowired
    private RoutingDataSource dataSource;

    public boolean isRunning() {
        block3: {
            try {
                if (this.getScheduler().isInStandbyMode() || !this.getScheduler().isStarted()) break block3;
                return true;
            }
            catch (Exception a2) {
                this.logger.error(F.ALLATORIxDEMO("\u8392\u53be\u5bbf\u659e\u564d\u72de\u6024\u659e\u5914\u8d4d\uff24"), (Throwable)a2);
                return false;
            }
        }
        return false;
    }

    public Scheduler getScheduler() {
        return this.scheduler.getScheduler();
    }

    @PostConstruct
    private /* synthetic */ void initialize() throws Exception {
        JobEntity a2;
        if (Global.isTestProfileActive()) {
            return;
        }
        JobService jobService = this;
        jobService.scheduler = new SchedulerFactoryBean();
        jobService.scheduler.setAutoStartup(ObjectUtils.toBoolean((Object)Global.getProperty(F.ALLATORIxDEMO("O\u0007GFD\u001dQ\u0007v\u001cD\u001aQ\u001dU"), "true")).booleanValue());
        jobService.scheduler.setStartupDelay(ObjectUtils.toInteger((Object)Global.getProperty(F.ALLATORIxDEMO("\u0002J\n\u000b\u001bQ\tW\u001cP\u0018a\rI\t\\"), F.ALLATORIxDEMO("^\u0015"))).intValue());
        if (!ObjectUtils.toBoolean(d.ALLATORIxDEMO().get(F.ALLATORIxDEMO("C\u0006o\u0007G"))).booleanValue()) {
            this.scheduler.afterPropertiesSet();
            return;
        }
        JobService jobService2 = this;
        jobService2.scheduler.setQuartzProperties(D.ALLATORIxDEMO());
        JobService jobService3 = this;
        jobService2.scheduler.setDataSource((DataSource)((Object)jobService3.dataSource));
        jobService3.scheduler.afterPropertiesSet();
        if (jobService2.scheduler.isAutoStartup()) {
            this.scheduler.start();
        }
        JobEntity jobEntity = a2 = new JobEntity();
        jobEntity.setStatus("");
        for (JobEntity a3 : super.findList(jobEntity)) {
            if ("1".equals(a2.getStatus())) {
                this.delete(a2);
                continue;
            }
            try {
                this.save(a3, false);
            }
            catch (Exception a4) {
                this.logger.warn(a4.getMessage(), (Throwable)a4);
            }
        }
        try {
            ListenerManager a5;
            ListenerManager listenerManager = a5 = this.getScheduler().getListenerManager();
            a5.addJobListener((JobListener)new JobDetalListener(this.jobLogService));
            listenerManager.addTriggerListener((TriggerListener)new JobTriggerListener(this.jobLogService));
            a5.addSchedulerListener((SchedulerListener)new JobSchedulerListener(this.jobLogService));
            return;
        }
        catch (SchedulerException a6) {
            this.logger.error(F.ALLATORIxDEMO("\u4f79\u4e72\u76f4\u5444\u4eae\u4e9e\u5f27\u5e50\uff24"), (Throwable)a6);
            return;
        }
    }

    public boolean stopAll() {
        if (!ObjectUtils.toBoolean(d.ALLATORIxDEMO().get(F.ALLATORIxDEMO("C\u0006o\u0007G"))).booleanValue()) {
            return false;
        }
        try {
            this.scheduler.stop();
        }
        catch (Exception a2) {
            this.logger.error(F.ALLATORIxDEMO("\u5034\u6b47\u5bf2\u65d3\u5600\u5914\u8d4d\uff24"), (Throwable)a2);
            return false;
        }
        return true;
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(JobEntity job) {
        if (!ObjectUtils.toBoolean(d.ALLATORIxDEMO().get(F.ALLATORIxDEMO("C\u0006o\u0007G"))).booleanValue()) {
            return;
        }
        super.delete(job);
        try {
            TriggerKey a2 = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            Trigger a3 = this.getScheduler().getTrigger(a2);
            if (a3 != null) {
                JobService jobService = this;
                jobService.getScheduler().deleteJob(a3.getJobKey());
                jobService.getScheduler().unscheduleJob(a3.getKey());
                return;
            }
        }
        catch (SchedulerException a4) {
            throw new ServiceException(F.ALLATORIxDEMO("\u5205\u960c\u5914\u8d4d\uff24"), a4);
        }
    }

    @Transactional(readOnly=false)
    public void runOnce(JobEntity job) {
        if (!ObjectUtils.toBoolean(d.ALLATORIxDEMO().get(F.ALLATORIxDEMO("C\u0006o\u0007G"))).booleanValue()) {
            return;
        }
        try {
            TriggerKey a2 = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            JobService jobService = this;
            Trigger a3 = jobService.getScheduler().getTrigger(a2);
            jobService.getScheduler().triggerJob(a3.getJobKey());
            return;
        }
        catch (SchedulerException a4) {
            throw new ServiceException(F.ALLATORIxDEMO("\u8ff5\u8824\u4e25\u6b49\u5914\u8d4d\uff24"), a4);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Transactional(readOnly=false)
    public void save(JobEntity job, boolean isSaveToDb) {
        block6: {
            block7: {
                if (!ObjectUtils.toBoolean(d.ALLATORIxDEMO().get(F.ALLATORIxDEMO("C\u0006o\u0007G"))).booleanValue()) {
                    return;
                }
                v0 = job;
                a = D.ALLATORIxDEMO(v0);
                a = D.ALLATORIxDEMO(v0, a);
                if (!isSaveToDb) break block6;
                if (!job.getIsNewRecord()) break block7;
                v1 = this;
                v2 = v1;
                super.insert(job);
                ** GOTO lbl17
            }
            super.update(job);
        }
        try {
            v2 = this;
lbl17:
            // 2 sources

            v2.getScheduler().addJob(a, true);
            v3 = this;
            if (this.getScheduler().getTrigger(a.getKey()) != null) {
                v3.getScheduler().rescheduleJob(a.getKey(), (Trigger)a);
            } else {
                v3.getScheduler().scheduleJob((Trigger)a);
            }
            if ("2".equals(job.getStatus())) {
                v4 = this;
                v4.getScheduler().pauseJob(a.getJobKey());
                v4.getScheduler().pauseTrigger(a.getKey());
                return;
            }
        }
        catch (Exception a) {
            throw new ServiceException(F.ALLATORIxDEMO("\u6dde\u52c8\u8b84\u527a\u4ede\u52c9\u5914\u8d4d\uff24"), a);
        }
    }

    @Override
    public JobEntity get(JobEntity job) {
        JobEntity a2 = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)job.getJobName()) && StringUtils.isNotBlank((CharSequence)job.getJobGroup())) {
                TriggerKey a3 = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
                Trigger a4 = this.getScheduler().getTrigger(a3);
                if (a4 instanceof CronTriggerImpl) {
                    a2 = new JobEntity().convert(this.getScheduler(), (CronTriggerImpl)a4);
                }
            }
        }
        catch (SchedulerException a5) {
            this.logger.error(F.ALLATORIxDEMO("\u8392\u53be\u5914\u8d4d\uff24"), (Throwable)a5);
        }
        return a2;
    }

    @Override
    public List<JobEntity> findList(JobEntity job) {
        List a2 = Lists.newArrayList();
        try {
            Scheduler a3 = this.getScheduler();
            Iterator iterator = a3.getTriggerGroupNames().iterator();
            while (iterator.hasNext()) {
                GroupMatcher a4 = GroupMatcher.groupEquals((String)((String)iterator.next()));
                for (TriggerKey a5 : a3.getTriggerKeys(a4)) {
                    Trigger a6 = a3.getTrigger(a5);
                    if (!(a6 instanceof CronTriggerImpl)) continue;
                    a2.add(new JobEntity().convert(a3, (CronTriggerImpl)a6));
                }
            }
        }
        catch (Exception a7) {
            this.logger.error(F.ALLATORIxDEMO("\u67c0\u8b8a\u4ede\u52c9\u5232\u8800\u5914\u8d4d\uff24"), (Throwable)a7);
        }
        return a2;
    }

    @Override
    @Transactional(readOnly=false)
    public void save(JobEntity job) {
        this.save(job, true);
    }

    @Transactional(readOnly=false)
    public void pause(JobEntity job) {
        if (!ObjectUtils.toBoolean(d.ALLATORIxDEMO().get(F.ALLATORIxDEMO("C\u0006o\u0007G"))).booleanValue()) {
            return;
        }
        job.setStatus("2");
        super.updateStatus(job);
        try {
            TriggerKey a2 = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            JobService jobService = this;
            Trigger a3 = jobService.getScheduler().getTrigger(a2);
            jobService.getScheduler().pauseJob(a3.getJobKey());
            jobService.getScheduler().pauseTrigger(a3.getKey());
            return;
        }
        catch (SchedulerException a4) {
            throw new ServiceException(F.ALLATORIxDEMO("\u66a7\u5034\u8ff5\u8824\u5914\u8d4d\uff24"), a4);
        }
    }

    public boolean startAll() {
        if (!ObjectUtils.toBoolean(d.ALLATORIxDEMO().get(F.ALLATORIxDEMO("C\u0006o\u0007G"))).booleanValue()) {
            return false;
        }
        try {
            JobService jobService = this;
            jobService.scheduler.setStartupDelay(0);
            jobService.scheduler.start();
        }
        catch (Exception a2) {
            this.logger.error(F.ALLATORIxDEMO("\u5447\u528d\u5bf2\u65d3\u5600\u5914\u8d4d\uff24"), (Throwable)a2);
            return false;
        }
        return true;
    }

    @Transactional(readOnly=false)
    public void resume(JobEntity job) {
        if (!ObjectUtils.toBoolean(d.ALLATORIxDEMO().get(F.ALLATORIxDEMO("C\u0006o\u0007G"))).booleanValue()) {
            return;
        }
        job.setStatus("0");
        super.updateStatus(job);
        try {
            TriggerKey a2 = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            JobService jobService = this;
            Trigger a3 = jobService.getScheduler().getTrigger(a2);
            jobService.getScheduler().resumeJob(a3.getJobKey());
            jobService.getScheduler().resumeTrigger(a3.getKey());
            return;
        }
        catch (SchedulerException a4) {
            throw new ServiceException(F.ALLATORIxDEMO("\u6047\u5965\u8ff5\u8824\u5914\u8d4d\uff24"), a4);
        }
    }
}

