/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.msg.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jeesite.common.entity.DataEntity;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mapper.JsonMapper;
import com.jeesite.common.mybatis.annotation.Column;
import com.jeesite.common.mybatis.annotation.Table;
import com.jeesite.common.mybatis.mapper.query.QueryType;
import com.jeesite.common.n.v.a;
import com.jeesite.common.shiro.cas.CasOutHandler;
import com.jeesite.modules.msg.entity.content.BaseMsgContent;
import java.util.Date;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

@Table(name="${_prefix}sys_msg_push", alias="a", columns={@Column(name="id", attrName="id", label="\u7f16\u53f7", isPK=true), @Column(name="msg_type", attrName="msgType", label="\u6d88\u606f\u7c7b\u578b", comment="\u6d88\u606f\u7c7b\u578b\uff08PC APP \u77ed\u4fe1 \u90ae\u4ef6 \u5fae\u4fe1\uff09"), @Column(name="msg_title", attrName="msgTitle", label="\u6d88\u606f\u6807\u9898", queryType=QueryType.LIKE), @Column(name="msg_content", attrName="msgContent", label="\u6d88\u606f\u5185\u5bb9"), @Column(name="biz_key", attrName="bizKey", label="\u4e1a\u52a1\u4e3b\u952e"), @Column(name="biz_type", attrName="bizType", label="\u4e1a\u52a1\u7c7b\u578b"), @Column(name="receive_code", attrName="receiveCode", label="\u63a5\u53d7\u8005\u8d26\u53f7"), @Column(name="receive_user_code", attrName="receiveUserCode", label="\u63a5\u53d7\u8005\u7528\u6237\u7f16\u7801"), @Column(name="receive_user_name", attrName="receiveUserName", label="\u63a5\u53d7\u8005\u7528\u6237\u59d3\u540d", queryType=QueryType.LIKE), @Column(name="send_user_code", attrName="sendUserCode", label="\u53d1\u9001\u8005\u7528\u6237\u7f16\u7801"), @Column(name="send_user_name", attrName="sendUserName", label="\u53d1\u9001\u8005\u7528\u6237\u59d3\u540d", queryType=QueryType.LIKE), @Column(name="send_date", attrName="sendDate", label="\u53d1\u9001\u65f6\u95f4"), @Column(name="is_merge_push", attrName="isMergePush", label="\u662f\u5426\u5408\u5e76\u63a8\u9001"), @Column(name="plan_push_date", attrName="planPushDate", label="\u8ba1\u5212\u63a8\u9001\u65f6\u95f4"), @Column(name="push_number", attrName="pushNumber", label="\u63a8\u9001\u5c1d\u8bd5\u6b21\u6570"), @Column(name="push_return_code", attrName="pushReturnCode", label="\u63a8\u9001\u8fd4\u56de\u7ed3\u679c\u7801"), @Column(name="push_return_msg_id", attrName="pushReturnMsgId", label="\u63a8\u9001\u8fd4\u56de\u6d88\u606f\u7f16\u53f7"), @Column(name="push_return_content", attrName="pushReturnContent", label="\u63a8\u9001\u8fd4\u56de\u7684\u5185\u5bb9\u4fe1\u606f"), @Column(name="push_status", attrName="pushStatus", label="\u63a8\u9001\u72b6\u6001", comment="\u63a8\u9001\u72b6\u6001\uff080\u672a\u63a8\u9001 1\u6210\u529f  2\u5931\u8d25\uff09"), @Column(name="push_date", attrName="pushDate", label="\u63a8\u9001\u65f6\u95f4"), @Column(name="read_status", attrName="readStatus", label="\u8bfb\u53d6\u72b6\u6001", comment="\u8bfb\u53d6\u72b6\u6001\uff080\u672a\u9001\u8fbe 1\u672a\u8bfb 2\u5df2\u8bfb\uff09"), @Column(name="read_date", attrName="readDate", label="\u8bfb\u53d6\u65f6\u95f4")}, orderBy="a.id DESC")
public class MsgPush
extends DataEntity<MsgPush> {
    public static final String PUSH_STATUS_FAIL = "2";
    private String sendUserCode;
    public static final String TYPE_EMAIL = "email";
    private String receiveUserName;
    private String sendUserName;
    private Date readDate;
    private Integer pushNumber;
    private String pushReturnCode;
    private String receiveUserCode;
    public static final String READ_STATUS_NONE = "0";
    private Date planPushDate;
    private String receiveCode;
    private String msgContent;
    public static final String PUSH_STATUS_NONE = "0";
    private String pushReturnMsgId;
    public static final String TYPE_PC = "pc";
    private String pushReturnContent;
    private String msgTitle;
    public static final String READ_STATUS_READ = "1";
    public static final String TYPE_SMS = "sms";
    private String bizType;
    private Long mergePushCount;
    private String msgType;
    public static final String READ_STATUS_UNREAD = "2";
    public static final String TYPE_APP = "app";
    private Date sendDate;
    public static final String PUSH_STATUS_SUCCESS = "1";
    private String isMergePush;
    private Date pushDate;
    private String readStatus;
    private static final long serialVersionUID = 1L;
    private String pushStatus;
    private String bizKey;
    public static final String TYPE_WEIXIN = "weixin";

    public String[] getMsgType_in() {
        return (String[])this.sqlMap.getWhere().getValue(CasOutHandler.ALLATORIxDEMO("\u001aj\u0010F\u0003`\u0007|"), QueryType.IN);
    }

    public void setSendDate_gte(Date sendDate) {
        this.sqlMap.getWhere().and(a.ALLATORIxDEMO("A4\\5m5S%W"), QueryType.GTE, sendDate);
    }

    public void setReadDate(Date readDate) {
        this.readDate = readDate;
    }

    public void setBizKey(String bizKey) {
        this.bizKey = bizKey;
    }

    @NotBlank(message="\u6d88\u606f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(min=0, max=16, message="\u6d88\u606f\u7c7b\u578b\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 16 \u4e2a\u5b57\u7b26")
    public String getMsgType() {
        return this.msgType;
    }

    public String getPushReturnContent() {
        return this.pushReturnContent;
    }

    @Length(min=0, max=64, message="\u4e1a\u52a1\u7c7b\u578b\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 64 \u4e2a\u5b57\u7b26")
    public String getBizType() {
        return this.bizType;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public Date getReadDate() {
        return this.readDate;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public Date getPushDate() {
        return this.pushDate;
    }

    @Length(min=0, max=1, message="\u662f\u5426\u5408\u5e76\u63a8\u9001\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 1 \u4e2a\u5b57\u7b26")
    public String getIsMergePush() {
        return this.isMergePush;
    }

    @NotBlank(message="\u63a5\u53d7\u8005\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(min=0, max=64, message="\u63a5\u53d7\u8005\u8d26\u53f7\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 64 \u4e2a\u5b57\u7b26")
    public String getReceiveCode() {
        return this.receiveCode;
    }

    public void setMsgTitle(String msgTitle) {
        this.msgTitle = msgTitle;
    }

    public void setPushNumber(Integer pushNumber) {
        this.pushNumber = pushNumber;
    }

    public Date getPlanPushDate_lte() {
        return (Date)this.sqlMap.getWhere().getValue(CasOutHandler.ALLATORIxDEMO("\u0007u\u0016w(i\u0002j\u001fF\u0013x\u0003|"), QueryType.LTE);
    }

    @NotBlank(message="\u63a5\u53d7\u8005\u7528\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(min=0, max=64, message="\u63a5\u53d7\u8005\u7528\u6237\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 64 \u4e2a\u5b57\u7b26")
    public String getReceiveUserCode() {
        return this.receiveUserCode;
    }

    public void setMsgContent(String msgContent) {
        this.msgContent = msgContent;
    }

    public void setSendDate_lte(Date sendDate) {
        this.sqlMap.getWhere().and(a.ALLATORIxDEMO("A4\\5m5S%W"), QueryType.LTE, sendDate);
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    @NotBlank(message="\u63a5\u53d7\u8005\u7528\u6237\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(min=0, max=100, message="\u63a5\u53d7\u8005\u7528\u6237\u59d3\u540d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 100 \u4e2a\u5b57\u7b26")
    public String getReceiveUserName() {
        return this.receiveUserName;
    }

    public <E> E parseMsgContent(Class<?> clazz) {
        if (StringUtils.isNotBlank((CharSequence)this.msgContent)) {
            return (E)JsonMapper.fromJson((String)this.msgContent, clazz);
        }
        return null;
    }

    public void setMergePushCount(Long mergePushCount) {
        this.mergePushCount = mergePushCount;
    }

    public Integer getPushNumber() {
        return this.pushNumber;
    }

    public void setPushDate(Date pushDate) {
        this.pushDate = pushDate;
    }

    @Length(min=0, max=200, message="\u63a8\u9001\u8fd4\u56de\u7ed3\u679c\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 200 \u4e2a\u5b57\u7b26")
    public String getPushReturnCode() {
        return this.pushReturnCode;
    }

    @NotBlank(message="\u53d1\u9001\u8005\u7528\u6237\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(min=0, max=100, message="\u53d1\u9001\u8005\u7528\u6237\u59d3\u540d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 100 \u4e2a\u5b57\u7b26")
    public String getSendUserName() {
        return this.sendUserName;
    }

    @Length(min=0, max=1, message="\u8bfb\u53d6\u72b6\u6001\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 1 \u4e2a\u5b57\u7b26")
    public String getReadStatus() {
        return this.readStatus;
    }

    public void setReceiveUserName(String receiveUserName) {
        this.receiveUserName = receiveUserName;
    }

    public MsgPush(String id) {
        super(id);
    }

    public void setReadStatus(String readStatus) {
        this.readStatus = readStatus;
    }

    public void setSendDate(Date sendDate) {
        this.sendDate = sendDate;
    }

    public void setReceiveCode(String receiveCode) {
        this.receiveCode = receiveCode;
    }

    @Length(min=0, max=64, message="\u4e1a\u52a1\u4e3b\u952e\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 64 \u4e2a\u5b57\u7b26")
    public String getBizKey() {
        return this.bizKey;
    }

    public MsgPush() {
        this(null);
    }

    public Date getSendDate_lte() {
        return (Date)this.sqlMap.getWhere().getValue(CasOutHandler.ALLATORIxDEMO("j\u0012w\u0013F\u0013x\u0003|"), QueryType.LTE);
    }

    public Map<String, Object> getMsgContentEntity() {
        return (Map)this.parseMsgContent(Map.class);
    }

    public void setReceiveUserCode(String receiveUserCode) {
        this.receiveUserCode = receiveUserCode;
    }

    @NotBlank(message="\u53d1\u9001\u8005\u7528\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(min=0, max=64, message="\u53d1\u9001\u8005\u7528\u6237\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 64 \u4e2a\u5b57\u7b26")
    public String getSendUserCode() {
        return this.sendUserCode;
    }

    public void setIsMergePush(String isMergePush) {
        this.isMergePush = isMergePush;
    }

    public Date getPlanPushDate_gte() {
        return (Date)this.sqlMap.getWhere().getValue(a.ALLATORIxDEMO("!^0\\\u000eB$A9m5S%W"), QueryType.GTE);
    }

    public void addPushReturnContent(String pushReturnContent) {
        MsgPush msgPush = this;
        msgPush.setPushNumber(ObjectUtils.toInteger((Object)msgPush.getPushNumber()) + 1);
        this.pushReturnContent = StringUtils.isBlank((CharSequence)msgPush.pushReturnContent) ? "" : this.pushReturnContent + CasOutHandler.ALLATORIxDEMO("\uff6c\u7b35") + this.pushNumber + a.ALLATORIxDEMO("\u6b70\uff28");
        this.pushReturnContent = this.pushReturnContent + pushReturnContent;
    }

    public Date getSendDate_gte() {
        return (Date)this.sqlMap.getWhere().getValue(CasOutHandler.ALLATORIxDEMO("j\u0012w\u0013F\u0013x\u0003|"), QueryType.GTE);
    }

    public void setPushReturnContent(String pushReturnContent) {
        this.pushReturnContent = pushReturnContent;
    }

    @NotBlank(message="\u6d88\u606f\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(min=0, max=200, message="\u6d88\u606f\u6807\u9898\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 200 \u4e2a\u5b57\u7b26")
    public String getMsgTitle() {
        return this.msgTitle;
    }

    public void setPlanPushDate(Date planPushDate) {
        this.planPushDate = planPushDate;
    }

    public void setMsgType_in(String[] msgTypes) {
        this.sqlMap.getWhere().and(a.ALLATORIxDEMO("<A6m%K!W"), QueryType.IN, msgTypes);
    }

    public void setSendUserCode(String sendUserCode) {
        this.sendUserCode = sendUserCode;
    }

    public void setPushReturnMsgId(String pushReturnMsgId) {
        this.pushReturnMsgId = pushReturnMsgId;
    }

    public void setPushReturnCode(String pushReturnCode) {
        this.pushReturnCode = pushReturnCode;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public Date getPlanPushDate() {
        return this.planPushDate;
    }

    @Length(min=0, max=1, message="\u63a8\u9001\u72b6\u6001\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 1 \u4e2a\u5b57\u7b26")
    public String getPushStatus() {
        return this.pushStatus;
    }

    public void setPushStatus(String pushStatus) {
        this.pushStatus = pushStatus;
    }

    public Long getMergePushCount() {
        return this.mergePushCount;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @NotNull(message="\u53d1\u9001\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a")
    public Date getSendDate() {
        return this.sendDate;
    }

    public void setSendUserName(String sendUserName) {
        this.sendUserName = sendUserName;
    }

    @JsonIgnore
    @NotBlank(message="\u6d88\u606f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a")
    public String getMsgContent() {
        return this.msgContent;
    }

    public void setPlanPushDate_lte(Date planPushDate) {
        this.sqlMap.getWhere().and(CasOutHandler.ALLATORIxDEMO("\u0007u\u0016w(i\u0002j\u001fF\u0013x\u0003|"), QueryType.LTE, planPushDate);
    }

    public void setPlanPushDate_gte(Date planPushDate) {
        this.sqlMap.getWhere().and(a.ALLATORIxDEMO("!^0\\\u000eB$A9m5S%W"), QueryType.GTE, planPushDate);
    }

    public void setMsgContentEntity(BaseMsgContent msgContentEntity) {
        if (msgContentEntity != null) {
            MsgPush msgPush;
            BaseMsgContent baseMsgContent = msgContentEntity;
            this.msgType = baseMsgContent.getMsgType();
            if (StringUtils.isNotBlank((CharSequence)baseMsgContent.getTitle())) {
                msgPush = this;
                this.msgTitle = msgContentEntity.getTitle();
            } else {
                msgPush = this;
                this.msgTitle = StringUtils.abbr((String)msgContentEntity.getContent(), (int)50);
            }
            msgPush.msgContent = JsonMapper.toJson((Object)msgContentEntity);
        }
    }

    @Length(min=0, max=200, message="\u63a8\u9001\u8fd4\u56de\u6d88\u606f\u7f16\u53f7\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 200 \u4e2a\u5b57\u7b26")
    public String getPushReturnMsgId() {
        return this.pushReturnMsgId;
    }
}

