/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.web;

import com.jeesite.common.entity.Page;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.config.CacheConfig;
import com.jeesite.modules.file.utils.FileUploadUtils;
import com.jeesite.modules.sys.entity.Module;
import com.jeesite.modules.sys.service.ModuleService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/module"})
public class ModuleController
extends BaseController {
    @Autowired
    private ModuleService moduleService;

    @RequiresPermissions(value={"sys:module:edit"})
    @RequestMapping(value={"disable"})
    @ResponseBody
    public String disable(Module module) {
        if (!module.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", CacheConfig.ALLATORIxDEMO("\u8dbc\u6718\u64fb\u4f07\uff3a\u53b1\u673f\u8dde\u7e91\u7bfa\u7430\u5403\u627b\u80a6\u4fd8\u6562\u6b52\u652b\u6358\uff5a"));
        }
        if ("core".equals(module.getModuleCode())) {
            return this.renderResult("false", FileUploadUtils.ALLATORIxDEMO("\u6868\u5fa5\u6a71\u5731\uff5c\u4e6b\u5111\u8bde\u79d1\u754e\uff51"));
        }
        module.setStatus("2");
        ModuleController moduleController = this;
        moduleController.moduleService.updateStatus(module);
        return moduleController.renderResult("true", new StringBuilder().insert(0, CacheConfig.ALLATORIxDEMO("\u506a\u7573\u6a17\u570c")).append(module.getModuleName()).append(FileUploadUtils.ALLATORIxDEMO("\u6276\u52cf")).toString());
    }

    @ModelAttribute
    public Module get(String moduleCode, boolean isNewRecord) {
        return (Module)this.moduleService.get(moduleCode, isNewRecord);
    }

    @RequiresPermissions(value={"sys:module:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated Module module) {
        if (!module.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", CacheConfig.ALLATORIxDEMO("\u8dbc\u6718\u64fb\u4f07\uff3a\u53b1\u673f\u8dde\u7e91\u7bfa\u7430\u5403\u627b\u80a6\u4fd8\u6562\u6b52\u652b\u6358\uff5a"));
        }
        this.moduleService.save(module);
        return this.renderResult("true", FileUploadUtils.ALLATORIxDEMO("\u4f8d\u5b3e\u6a71\u5731\u6240\u52f9\uff51"));
    }

    @RequiresPermissions(value={"sys:module:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(Module module) {
        if (!module.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", CacheConfig.ALLATORIxDEMO("\u8dbc\u6718\u64fb\u4f07\uff3a\u53b1\u673f\u8dde\u7e91\u7bfa\u7430\u5403\u627b\u80a6\u4fd8\u6562\u6b52\u652b\u6358\uff5a"));
        }
        if ("core".equals(module.getModuleCode())) {
            return this.renderResult("false", FileUploadUtils.ALLATORIxDEMO("\u6868\u5fa5\u6a71\u5731\uff5c\u4e6b\u5111\u8bde\u79d1\u754e\uff51"));
        }
        this.moduleService.delete(module);
        return this.renderResult("true", CacheConfig.ALLATORIxDEMO("\u527b\u9652\u6a7a\u5761\u624b\u52a9\uff5a"));
    }

    @RequiresPermissions(value={"sys:module:view"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public Page<Module> listData(Module module, HttpServletRequest request, HttpServletResponse response) {
        return this.moduleService.findPage(new Page<Module>(request, response), module);
    }

    @RequiresPermissions(value={"sys:module:edit"})
    @RequestMapping(value={"enable"})
    @ResponseBody
    public String enable(Module module) {
        if (!module.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", FileUploadUtils.ALLATORIxDEMO("\u8dec\u6713\u64ab\u4f0c\uff6a\u53ba\u676f\u8dd5\u7ec1\u7bf1\u7460\u5408\u622b\u80ad\u4f88\u6569\u6b02\u6520\u6308\uff51"));
        }
        module.setStatus("0");
        ModuleController moduleController = this;
        moduleController.moduleService.updateStatus(module);
        return moduleController.renderResult("true", new StringBuilder().insert(0, CacheConfig.ALLATORIxDEMO("\u5419\u7573\u6a17\u570c")).append(module.getModuleName()).append(FileUploadUtils.ALLATORIxDEMO("\u6276\u52cf")).toString());
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:module:view"})
    @RequestMapping(value={"list"})
    public String list(Module module, Model model) {
        void module2;
        module2.setStatus("");
        return CacheConfig.ALLATORIxDEMO("[4R.Z>EtE\"Et[4R.Z>z2E/");
    }

    @RequiresPermissions(value={"sys:module:view"})
    @RequestMapping(value={"form"})
    public String form(Module module, Model model) {
        if (StringUtils.isBlank((CharSequence)module.getMainClassName())) {
            module.setMainClassName(FileUploadUtils.ALLATORIxDEMO("3\t=H:\u00035\u00159\u00125H=\t4\u0013<\u0003#H#\u001f#H'\u00032H\u001c\t7\u000f>%?\b$\u0014?\n<\u0003\""));
        }
        model.addAttribute(CacheConfig.ALLATORIxDEMO("[4R.Z>"), (Object)module);
        return FileUploadUtils.ALLATORIxDEMO("\u000b?\u0002%\n5\u0015\u007f\u0015)\u0015\u007f\u000b?\u0002%\n5 ?\u0014=");
    }

    @RequiresPermissions(value={"sys:module:edit"})
    @RequestMapping(value={"checkModuleCode"})
    @ResponseBody
    public String checkModuleCode(String oldCode, String moduleCode) {
        Module a2 = new Module();
        String string = moduleCode;
        a2.setModuleCode(string);
        if (string != null && moduleCode.equals(oldCode)) {
            return "true";
        }
        if (moduleCode != null && this.moduleService.get(a2) == null) {
            return "true";
        }
        return "false";
    }
}

