/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.cache;

import com.jeesite.common.cache.E;
import com.jeesite.common.collect.SetUtils;
import com.jeesite.common.config.Global;
import com.jeesite.common.i.i.d;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.modules.config.TransactionConfig;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.shiro.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheUtils {
    private static Logger logger = LoggerFactory.getLogger(CacheUtils.class);
    private static final String SYS_CACHE = "sysCache";

    public static void remove(String key) {
        CacheUtils.remove(SYS_CACHE, key);
    }

    public static Object get(String key, Object defaultValue) {
        Object a = CacheUtils.get(key);
        if (a != null) {
            return a;
        }
        return defaultValue;
    }

    public static void clearCache() {
        int n;
        String a = Global.getConfig(d.ALLATORIxDEMO("C8E1E8C~E<C1T\u001eG=C#"));
        if (StringUtils.isBlank((CharSequence)a)) {
            return;
        }
        String[] stringArray = a.split(TransactionConfig.ALLATORIxDEMO("\u0003"));
        int n2 = stringArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            CacheUtils.removeAll(stringArray[n++]);
            n3 = n;
        }
    }

    public static String[] getCacheNames() {
        return E.ALLATORIxDEMO().getCacheNames();
    }

    public static Object get(String key) {
        return CacheUtils.get(SYS_CACHE, key);
    }

    public static Object get(String cacheName, String key) {
        return CacheUtils.getCache(cacheName).get((Object)key);
    }

    public static void remove(String cacheName, String key) {
        CacheUtils.getCache(cacheName).remove((Object)key);
    }

    public static Cache<String, Object> getCache(String cacheName) {
        Cache a = E.ALLATORIxDEMO().getCache(cacheName);
        if (a == null) {
            throw new RuntimeException(new StringBuilder().insert(0, d.ALLATORIxDEMO("\u5f75\u521d\u7cdd\u7e8f\u4e0b\u6cf1\u672f\u5bca\u4e6f\u204c")).append(cacheName).append(TransactionConfig.ALLATORIxDEMO("\u201c\u8ff6\u4e2b\u7f3c\u5b59\u302d")).toString());
        }
        return a;
    }

    public static void put(String key, Object value) {
        CacheUtils.put(SYS_CACHE, key, value);
    }

    public static Object get(String cacheName, String key, Object defaultValue) {
        Object a = CacheUtils.get(cacheName, key);
        if (a != null) {
            return a;
        }
        return defaultValue;
    }

    public static void removeByKeyPrefix(String cacheName, String keyPrefix) {
        String a = keyPrefix;
        Cache<String, Object> a2 = CacheUtils.getCache(cacheName);
        Set a3 = a2.keys();
        HashSet a4 = SetUtils.newHashSet();
        for (String a5 : a3) {
            if (!StringUtils.startsWith((CharSequence)a5, (CharSequence)a)) continue;
            a2.remove((Object)a5);
            a4.add(a5);
        }
        logger.info(d.ALLATORIxDEMO("\u6e23\u7456\u7f35\u5b08\uff3cp]-\u0006m\u0018p]-"), (Object)cacheName, (Object)a4);
    }

    public static void put(String cacheName, String key, Object value) {
        CacheUtils.getCache(cacheName).put((Object)key, value);
    }

    public static void removeAll(String cacheName) {
        Iterator a;
        Cache<String, Object> a2 = CacheUtils.getCache(cacheName);
        Set a3 = a2.keys();
        Iterator iterator = a = a3.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = a;
            iterator = iterator2;
            a2.remove(iterator2.next());
        }
        logger.info(TransactionConfig.ALLATORIxDEMO("\u6e04\u7429\u7f12\u5b77\uff1b\u000fzR!\u0012?\u000fzR"), (Object)cacheName, (Object)a3);
    }
}

