/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.shiro.session;

import com.jeesite.common.network.IpUtils;
import com.jeesite.common.shiro.session.StaticSession;
import com.jeesite.common.web.http.ServletUtils;
import com.jeesite.modules.config.DataSourceConfig;
import com.jeesite.modules.file.utils.FileUploadUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager
extends DefaultWebSessionManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultWebSessionManager.class);

    public String getHost(SessionKey key) {
        try {
            return super.getHost(key);
        }
        catch (InvalidSessionException a) {
            return null;
        }
    }

    public void setTimeout(SessionKey key, long maxIdleTimeInMillis) {
        try {
            super.setTimeout(key, maxIdleTimeInMillis);
            return;
        }
        catch (InvalidSessionException invalidSessionException) {
            return;
        }
    }

    public Date getStartTimestamp(SessionKey key) {
        try {
            return super.getStartTimestamp(key);
        }
        catch (InvalidSessionException a) {
            return new Date();
        }
    }

    public void setAttribute(SessionKey sessionKey, Object attributeKey, Object value) {
        try {
            super.setAttribute(sessionKey, attributeKey, value);
            return;
        }
        catch (InvalidSessionException invalidSessionException) {
            return;
        }
    }

    public Object removeAttribute(SessionKey sessionKey, Object attributeKey) {
        try {
            return super.removeAttribute(sessionKey, attributeKey);
        }
        catch (InvalidSessionException a) {
            return null;
        }
    }

    public void touch(SessionKey key) {
        block4: {
            Session a4;
            block5: {
                HttpServletRequest a2;
                block6: {
                    a4 = this.doGetSession(key);
                    if (a4 == null) break block4;
                    a2 = ServletUtils.getRequest();
                    if (a2 == null) break block5;
                    if (!ServletUtils.isStaticFile((String)a2.getRequestURI())) break block6;
                    return;
                }
                String a3 = a2.getParameter(DataSourceConfig.ALLATORIxDEMO("f4W\u0004M>I\u000fX\u001f\\8\\\u0018J\u0002V\u0005"));
                if (!"true".equals(a3) && !"1".equals(a3)) break block5;
                return;
            }
            try {
                a4.touch();
                this.onChange(a4);
                return;
            }
            catch (InvalidSessionException a4) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Serializable getSessionId(ServletRequest request, ServletResponse response) {
        String string;
        String a = this.getSessionIdCookieValue(request, response);
        if (StringUtils.isNotBlank((CharSequence)a)) {
            string = a;
            request.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID_SOURCE, (Object)FileUploadUtils.ALLATORIxDEMO("\u000b9\u0007=\u00013"));
        } else {
            a = request.getParameter(DataSourceConfig.ALLATORIxDEMO("4f\u0018P\u000f"));
            if (StringUtils.isNotBlank((CharSequence)a)) {
                if (WebUtils.isTrue((ServletRequest)request, (String)FileUploadUtils.ALLATORIxDEMO("7\t\u000b9\u0007=\u00013"))) {
                    void a2;
                    HttpServletRequest a3 = (HttpServletRequest)request;
                    HttpServletResponse a4 = (HttpServletResponse)response;
                    Cookie a5 = this.getSessionIdCookie();
                    SimpleCookie simpleCookie = new SimpleCookie(a5);
                    void v1 = a2;
                    v1.setValue(a);
                    v1.saveTo(a3, a4);
                }
                request.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID_SOURCE, (Object)DataSourceConfig.ALLATORIxDEMO("\u001eK\u0007"));
            }
            string = a;
        }
        if (string != null) {
            ServletRequest servletRequest = request;
            servletRequest.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID, (Object)a);
            servletRequest.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID_IS_VALID, (Object)Boolean.TRUE);
        }
        return a;
    }

    public Session start(SessionContext context) {
        try {
            return super.start(context);
        }
        catch (Exception a) {
            return StaticSession.INSTANCE;
        }
    }

    public void validateSessions() {
        super.validateSessions();
    }

    private /* synthetic */ String getSessionIdCookieValue(ServletRequest request, ServletResponse response) {
        if (!this.isSessionIdCookieEnabled()) {
            log.debug(FileUploadUtils.ALLATORIxDEMO(";3\u001b%\u00019\u0006v!\u0012H5\u00079\u0003?\rv\u0001%H2\u0001%\t4\u00043\fvEv\u001b3\u001b%\u00019\u0006v\u00012H!\u0001:\u0004v\u00069\u001cv\n3H7\u000b'\u001d?\u001a3\fv\u000e$\u0007;H7H$\r'\u001d3\u001b\"H5\u00079\u0003?\rx"));
            return null;
        }
        if (!(request instanceof HttpServletRequest)) {
            log.debug(DataSourceConfig.ALLATORIxDEMO("(L\u0019K\u000eW\u001f\u0019\u0019\\\u001aL\u000eJ\u001f\u0019\u0002JKW\u0004MKX\u0005\u0019#M\u001fI8\\\u0019O\u0007\\\u001fk\u000eH\u001e\\\u0018MK\u0014KZ\nW\u0005V\u001f\u0019\f\\\u001f\u0019\u0018\\\u0018J\u0002V\u0005\u0019\"}KZ\u0004V\u0000P\u000e\u0017K\u00199\\\u001fL\u0019W\u0002W\f\u0019\u0005L\u0007UE"));
            return null;
        }
        HttpServletRequest a = (HttpServletRequest)request;
        return this.getSessionIdCookie().readValue(a, WebUtils.toHttp((ServletResponse)response));
    }

    public Collection<Object> getAttributeKeys(SessionKey key) {
        try {
            return super.getAttributeKeys(key);
        }
        catch (InvalidSessionException a) {
            return null;
        }
    }

    public long getTimeout(SessionKey key) {
        try {
            return super.getTimeout(key);
        }
        catch (InvalidSessionException a) {
            return 0L;
        }
    }

    protected Session newSessionInstance(SessionContext context) {
        Session a = super.newSessionInstance(context);
        if (a instanceof SimpleSession) {
            ((SimpleSession)a).setHost(IpUtils.getRemoteAddr((HttpServletRequest)ServletUtils.getRequest()));
        }
        return a;
    }

    protected Session retrieveSession(SessionKey sessionKey) {
        try {
            return super.retrieveSession(sessionKey);
        }
        catch (UnknownSessionException a) {
            return null;
        }
    }

    public Object getAttribute(SessionKey sessionKey, Object attributeKey) {
        try {
            return super.getAttribute(sessionKey, attributeKey);
        }
        catch (InvalidSessionException a) {
            return null;
        }
    }

    public Date getLastAccessTime(SessionKey key) {
        try {
            return super.getLastAccessTime(key);
        }
        catch (InvalidSessionException a) {
            return new Date();
        }
    }

    public void stop(SessionKey key) {
        try {
            super.stop(key);
            return;
        }
        catch (InvalidSessionException invalidSessionException) {
            return;
        }
    }
}

