/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.service;

import com.jeesite.common.callback.MethodCallback;
import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.config.Global;
import com.jeesite.common.entity.Page;
import com.jeesite.common.i.v.M;
import com.jeesite.common.io.FileUtils;
import com.jeesite.common.lang.DateUtils;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mapper.JsonMapper;
import com.jeesite.common.network.IpUtils;
import com.jeesite.common.service.CrudService;
import com.jeesite.common.service.ServiceException;
import com.jeesite.common.shiro.realm.BaseAuthorizingRealm;
import com.jeesite.common.web.http.ServletUtils;
import com.jeesite.modules.sys.dao.UserDao;
import com.jeesite.modules.sys.dao.UserDataScopeDao;
import com.jeesite.modules.sys.dao.UserRoleDao;
import com.jeesite.modules.sys.entity.Role;
import com.jeesite.modules.sys.entity.User;
import com.jeesite.modules.sys.entity.UserDataScope;
import com.jeesite.modules.sys.entity.UserRole;
import com.jeesite.modules.sys.service.d;
import com.jeesite.modules.sys.utils.DictUtils;
import com.jeesite.modules.sys.utils.UserUtils;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;

@Service
@Transactional(readOnly=true)
public class UserService
extends CrudService<UserDao, User> {
    private static Pattern lowerCaseExp;
    @Autowired
    private UserRoleDao userRoleDao;
    private static Pattern numberExp;
    @Autowired
    private UserDataScopeDao userDataScopeDao;
    private static Pattern upperCaseExp;
    private static Pattern specialExp;

    @Override
    @Transactional(readOnly=false)
    public void save(User user) {
        if (user.getIsNewRecord()) {
            if (StringUtils.isBlank((CharSequence)user.getUserCode())) {
                User user2 = user;
                this.genId(user2, user2.getLoginCode());
            }
            if (((UserDao)this.dao).get(user) != null) {
                throw UserService.newValidationException(UserService.text(M.ALLATORIxDEMO("NNN\u0019HDXE\u0013[RPTY~XYRxOTDID"), new String[0]));
            }
            String a = user.getPassword();
            if (StringUtils.isBlank((CharSequence)a)) {
                a = Global.getConfig(DictUtils.ALLATORIxDEMO("[g[0]mMl\u0006wFw\\NIm[iGlL"));
            }
            User user3 = user;
            User user4 = user;
            user4.setPassword(UserService.encryptPassword(a));
            user3.setPwdSecurityLevel(UserService.getPwdSecurityLevel(a));
            User user5 = user;
            user4.setPwdUpdateDate(new Date());
            if (StringUtils.isBlank((CharSequence)user3.getUserType())) {
                user.setUserType("none");
            }
            if (StringUtils.isBlank((CharSequence)user.getMgrType())) {
                user.setMgrType("0");
            }
        }
        super.save(user);
        UserUtils.clearCache(user);
    }

    public List<User> findListByRoleCode(User user) {
        return ((UserDao)this.dao).findListByRoleCode(user);
    }

    public static boolean validatePassword(String plainPassword, String password) {
        return BaseAuthorizingRealm.validatePassword(plainPassword, password);
    }

    public List<UserDataScope> findDataScopeList(UserDataScope userDataScope) {
        return this.userDataScopeDao.findList(userDataScope);
    }

    private static /* synthetic */ int getPwdSecurityLevel(String newPassword) {
        int a = 0;
        if (!StringUtils.equals((CharSequence)newPassword, (CharSequence)Global.getConfig(M.ALLATORIxDEMO("DDD\u0013BNRO\u0019TYTCmVNDJXOS")))) {
            int a2;
            int a3;
            int a4;
            int a5;
            int a6 = newPassword.length() >= 8 ? 1 : 0;
            int a7 = a6 + (a5 = upperCaseExp.matcher(newPassword).find() ? 1 : 0) + (a4 = lowerCaseExp.matcher(newPassword).find() ? 1 : 0) + (a3 = numberExp.matcher(newPassword).find() ? 1 : 0) + (a2 = specialExp.matcher(newPassword).find() ? 1 : 0);
            a = a7 == 0 ? 0 : (a7 == 1 ? 1 : (a7 == 2 ? 2 : (a7 == 3 || a7 == 4 ? 3 : 4)));
            int a8 = ObjectUtils.toInteger((Object)Global.getConfig(DictUtils.ALLATORIxDEMO("mQm\u0006k[{Z0X\u007f[m_qZzeqLwNg{{KkZw\\gd{^{D")));
            if (a8 > 0 && a8 > a) {
                throw new ServiceException(UserService.text(M.ALLATORIxDEMO("NNN\u0019HDXE\u0013G\\DN@REYzRSTQDdXTHETCD{XAX["), new String[0]));
            }
        }
        return a;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional(readOnly=false)
    public void updatePassword(String userCode, String newPassword) {
        int a;
        void a2;
        User a3 = UserUtils.get(userCode);
        if (a3 == null) {
            throw new ServiceException(new StringBuilder().insert(0, userCode).append(UserService.text(DictUtils.ALLATORIxDEMO("mQm\u0006k[{Z0]mMlkqL{fq\\[Pw[j["), new String[0])).toString());
        }
        User user = new User();
        void v0 = a2;
        v0.setUserCode(a3.getUserCode());
        v0.setCorpCode(a3.getCorpCode_());
        if (StringUtils.isBlank((CharSequence)newPassword)) {
            newPassword = Global.getConfig(M.ALLATORIxDEMO("DDD\u0013BNRO\u0019TYTCmVNDJXOS"));
        }
        if ((a = UserService.getPwdSecurityLevel(newPassword)) != 0) {
            int a4 = ObjectUtils.toInteger((Object)Global.getConfig(DictUtils.ALLATORIxDEMO("[g[0]mMl\u0006nIm[iGlLSGzAxQPGjz{X{IjfkE"), "1"));
            List a5 = (List)JsonMapper.fromJson((String)a3.getPwdUpdateRecord(), List.class);
            if (a5 == null) {
                a5 = ListUtils.newArrayList();
                if (a3.getPwdUpdateDate() == null) {
                    a3.setPwdUpdateDate(new Date());
                }
                Object[] objectArray = new String[2];
                objectArray[0] = a3.getPassword();
                objectArray[1] = DateUtils.formatDateTime((Date)a3.getPwdUpdateDate());
                a5.add(ListUtils.newArrayList((Object[])objectArray));
            }
            for (List a6 : a5) {
                if (!UserService.validatePassword(newPassword, (String)a6.get(0))) continue;
                String[] stringArray = new String[1];
                stringArray[0] = String.valueOf(a4);
                throw new ServiceException(UserService.text(M.ALLATORIxDEMO("NNN\u0019HDXE\u0013G\\DN@REYzRSTQDyRCoRMR\\C"), stringArray));
            }
            a2.setPassword(UserService.encryptPassword(newPassword));
            Object[] objectArray = new String[2];
            objectArray[0] = a2.getPassword();
            objectArray[1] = DateUtils.getDateTime();
            a5.add(ListUtils.newArrayList((Object[])objectArray));
            if (a5.size() > a4) {
                List list = a5;
                list.subList(0, list.size() - a4).clear();
            }
            a2.setPwdUpdateRecord(JsonMapper.toJson((Object)a5));
        } else {
            a2.setPassword(UserService.encryptPassword(newPassword));
            a2.setPwdUpdateRecord(a3.getPwdUpdateRecord());
        }
        Global.assertDemoMode();
        void v5 = a2;
        v5.setPwdSecurityLevel(a);
        v5.setPwdUpdateDate(new Date());
        ((UserDao)this.dao).updatePassword((User)a2);
        UserUtils.clearCache((User)a2);
    }

    public String checkLoginCode(String oldLoginCode, String loginCode) {
        User a = new User();
        String string = loginCode;
        a.setLoginCode(string);
        if (string != null && loginCode.equals(oldLoginCode)) {
            return "true";
        }
        if (loginCode != null && this.getByLoginCode(a) == null) {
            return "true";
        }
        return "false";
    }

    public User getByLoginCode(User user) {
        return ((UserDao)this.dao).getByLoginCode(user);
    }

    @Override
    public Page<User> findPage(Page<User> page, User user) {
        return super.findPage(page, user);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional(readOnly=false)
    public void updateUserLoginInfo(User user) {
        void user2;
        void v0 = user2;
        v0.setOldLastLoginIp(v0.getLastLoginIp());
        v0.setOldLastLoginDate(v0.getLastLoginDate());
        v0.setLastLoginIp(IpUtils.getRemoteAddr((HttpServletRequest)ServletUtils.getRequest()));
        void v1 = user2;
        v0.setLastLoginDate(new Date());
        ((UserDao)this.dao).updateLoginInfo((User)user2);
    }

    public static String encryptPassword(String plainPassword) {
        return BaseAuthorizingRealm.encryptPassword(plainPassword);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional(readOnly=false)
    public void saveAuth(User user) {
        Global.assertDemoMode();
        if (StringUtils.isBlank((CharSequence)user.getUserCode())) {
            return;
        }
        UserRole a = new UserRole();
        a.setUserCode(user.getUserCode());
        this.userRoleDao.deleteByEntity(a);
        List<UserRole> a2 = user.getUserRoleList();
        if (!user.getCurrentUser().isAdmin()) {
            Iterator<void> iterator;
            void a3;
            List a4 = ListUtils.extractToList(a2, (String)DictUtils.ALLATORIxDEMO("lGrM]GzM"), null, (boolean)true);
            UserDataScope userDataScope = new UserDataScope();
            List list = a4;
            void v1 = a3;
            a3.setUserCode(user.getCurrentUser().getUserCode());
            v1.setCtrlType(Role.class.getSimpleName());
            v1.setCtrlData_in(list.toArray(new String[list.size()]));
            a3.setCtrlPermi("2");
            List<void> list2 = this.userDataScopeDao.findList(a3);
            a2.clear();
            Iterator<void> iterator2 = iterator = list2.iterator();
            while (iterator2.hasNext()) {
                void a5;
                UserDataScope a6 = (UserDataScope)iterator.next();
                UserRole userRole = new UserRole();
                iterator2 = iterator;
                void v4 = a5;
                v4.setUserCode(user.getUserCode());
                v4.setRoleCode(a6.getCtrlData());
                a2.add((UserRole)v4);
            }
        } else {
            Iterator<UserRole> a4;
            Iterator<UserRole> iterator = a4 = a2.iterator();
            while (iterator.hasNext()) {
                void var4_5;
                UserRole a3 = (UserRole)var4_5.next();
                iterator = var4_5;
                a3.setUserCode(user.getUserCode());
            }
        }
        if (ListUtils.isNotEmpty(a2)) {
            this.userRoleDao.insertBatch(user.getUserRoleList());
        }
        UserUtils.clearCache(user);
    }

    @Override
    public User get(User user) {
        return super.get(user);
    }

    public User getByUserTypeAndRefCode(User user) {
        return ((UserDao)this.dao).getByUserTypeAndRefCode(user);
    }

    static {
        upperCaseExp = Pattern.compile(M.ALLATORIxDEMO("l|\u001agj"));
        lowerCaseExp = Pattern.compile(DictUtils.ALLATORIxDEMO("s\u007f\u0005du"));
        numberExp = Pattern.compile(M.ALLATORIxDEMO("l\r\u001a\u0004j"));
        specialExp = Pattern.compile(DictUtils.ALLATORIxDEMO("s`\t^\u000b:\rBv8t4\u00007w5tetc\u0012<tb\u0014 \u0017~t3\u0015BsBu%t9tB\u0004B\u00061u"));
    }

    @Override
    @Transactional(readOnly=false)
    public void updateStatus(User user) {
        User user2 = user;
        super.updateStatus(user2);
        UserUtils.clearCache(user2);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional(readOnly=false)
    public void updateMgrType(User user) {
        void user2;
        user2.preUpdate();
        ((UserDao)this.dao).updateMgrType((User)user2);
        UserUtils.clearCache((User)user2);
    }

    /*
     * Unable to fully structure code
     */
    @Transactional(readOnly=false)
    public void updateUserInfo(User user) {
        a = user.getAvatarBase64();
        if (!StringUtils.isNotBlank((CharSequence)a)) ** GOTO lbl13
        if (M.ALLATORIxDEMO("rpgin").equals(a)) {
            v0 = user;
            v1 = v0;
            v0.setAvatar("");
        } else {
            a = new StringBuilder().insert(0, DictUtils.ALLATORIxDEMO("IhIjIl\u0007")).append(user.getCorpCode()).append(M.ALLATORIxDEMO("\u0018")).append(user.getUserType()).append(DictUtils.ALLATORIxDEMO("\u0007")).append(user.getUserCode()).append(M.ALLATORIxDEMO("\u0019")).append(FileUtils.getFileExtensionByImageBase64((String)a)).toString();
            FileUtils.writeToFileByImageBase64((String)Global.getUserfilesBaseDir(a), (String)a);
            user.setAvatar("/userfiles/" + a);
lbl13:
            // 2 sources

            v1 = user;
        }
        v1.preUpdate();
        ((UserDao)this.dao).updateUserInfo(user);
        UserUtils.clearCache(user);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional(readOnly=false)
    public void saveAuthDataScope(User user) {
        void a;
        Global.assertDemoMode();
        if (StringUtils.isBlank((CharSequence)user.getUserCode())) {
            return;
        }
        UserDataScope userDataScope = new UserDataScope();
        void v0 = a;
        v0.setUserCode(user.getUserCode());
        v0.setCtrlPermi("2".equals(user.getMgrType()) ? "2" : "1");
        this.userDataScopeDao.deleteByEntity(a);
        List<UserDataScope> a2 = user.getUserDataScopeList();
        Iterator<UserDataScope> iterator = a2.iterator();
        Iterator<UserDataScope> iterator2 = iterator;
        while (iterator2.hasNext()) {
            iterator.next().setCtrlPermi(a.getCtrlPermi());
            iterator2 = iterator;
        }
        ListUtils.pageList(a2, (int)100, (MethodCallback)new d(this));
        UserUtils.clearCache(user);
    }

    /*
     * Unable to fully structure code
     */
    public static String passwordModifyValid(User user, Model model) {
        a = null;
        a = Global.getConfig(DictUtils.ALLATORIxDEMO("[g[0]mMl\u0006wFw\\NIm[iGlLSGzAxQ"));
        if (!"0".equals(a) && (a = Boolean.valueOf(UserService.validatePassword(Global.getConfig(M.ALLATORIxDEMO("DDD\u0013BNRO\u0019TYTCmVNDJXOS")), user.getPassword()))).booleanValue()) {
            a = UserService.text(DictUtils.ALLATORIxDEMO("mQm\u0006k[{Z0ApAjx\u007f[m_qZzeqLwNg|wX"), new String[0]);
            if ("1".equals(a)) {
                model.addAttribute(M.ALLATORIxDEMO("ZRSTQDg\\DN@REYcTG"), (Object)a);
            } else if ("2".equals(a)) {
                a = a;
            }
        }
        a = Global.getConfig(DictUtils.ALLATORIxDEMO("[g[0]mMl\u0006nIm[iGlLSGzAxQ"));
        if (a == null || "0".equals(a)) ** GOTO lbl36
        a = ObjectUtils.toInteger((Object)Global.getConfig(M.ALLATORIxDEMO("NNN\u0019HDXE\u0013G\\DN@REYzRSTQDtDTQR")));
        v0 = a = user.getPwdUpdateDate() == null ? 0L : DateUtils.pastDays((Date)user.getPwdUpdateDate());
        if (user.getPwdUpdateDate() != null && a < (long)a) ** GOTO lbl36
        a = null;
        if (a == 0L) {
            a = UserService.text(DictUtils.ALLATORIxDEMO("mQm\u0006k[{Z0ApAjx\u007f[m_qZzeqLwNg|wX"), new String[0]);
        } else {
            v1 = new String[1];
            v1[0] = String.valueOf(a);
            a = UserService.text(M.ALLATORIxDEMO("NNN\u0019HDXE\u0013G\\DN@REYzRSTQDcTG"), v1);
        }
        if ("1".equals(a)) {
            v2 = a;
            model.addAttribute(DictUtils.ALLATORIxDEMO("EqLwNgx\u007f[m_qZz|wX"), (Object)a);
        } else {
            if ("2".equals(a)) {
                a = a;
            }
lbl36:
            // 5 sources

            v2 = a;
        }
        if (v2 != null) {
            return new StringBuilder().insert(0, Global.getAdminPath()).append(M.ALLATORIxDEMO("\u0012DDD\u0012BNRO\u0018TY[X\u0002XM\nM@Y\u0011HEQ\n")).append(Global.getAdminPath()).append(DictUtils.ALLATORIxDEMO("\u0007wFzMf\u000es[y\u0015")).append(a).toString();
        }
        return null;
    }

    static /* synthetic */ UserDataScopeDao access$000(UserService x0) {
        return x0.userDataScopeDao;
    }

    public List<User> findCorpList(User user) {
        return ((UserDao)this.dao).findCorpList(user);
    }

    @Transactional(readOnly=false)
    public void updateQuestion(User user) {
        Global.assertDemoMode();
        user.setPwdQuestUpdateDate(new Date());
        ((UserDao)this.dao).updateQuestion(user);
        UserUtils.clearCache(user);
    }

    @Override
    public List<User> findList(User user) {
        return super.findList(user);
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(User user) {
        User user2 = user;
        super.delete(user2);
        UserUtils.clearCache(user2);
    }
}

