/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.utils;

import com.jeesite.common.cache.CacheUtils;
import com.jeesite.common.codec.Md5Utils;
import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.collect.MapUtils;
import com.jeesite.common.collect.SetUtils;
import com.jeesite.common.config.Global;
import com.jeesite.common.lang.DateUtils;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mybatis.annotation.MyBatisDao;
import com.jeesite.common.mybatis.mapper.provider.TreeSqlProvider;
import com.jeesite.common.service.ServiceException;
import com.jeesite.common.shiro.realm.LoginInfo;
import com.jeesite.common.utils.SpringUtils;
import com.jeesite.common.web.http.ServletUtils;
import com.jeesite.modules.sys.entity.Menu;
import com.jeesite.modules.sys.entity.Role;
import com.jeesite.modules.sys.entity.User;
import com.jeesite.modules.sys.utils.E;
import com.jeesite.modules.sys.utils.ValidCodeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserUtils {
    public static final String CACHE_MENU_LIST = "menuList";
    private static final String USER_CACHE = "userCache";
    private static Lock userCacheLock = new ReentrantLock();
    public static final String CACHE_AUTH_INFO = "authInfo";
    private static Logger logger = LoggerFactory.getLogger(UserUtils.class);
    private static final String USER_CACHE_USER_TYPE_AND_REF_CODE_ = "type_ref_";
    private static final String USER_CACHE_LOGIN_CODE_ = "login_";
    private static final String USER_CACHE_CODE_ = "code_";

    public static void clearCache(User user) {
        CacheUtils.remove(USER_CACHE, new StringBuilder().insert(0, USER_CACHE_CODE_).append(user.getUserCode()).toString());
        CacheUtils.remove(USER_CACHE, new StringBuilder().insert(0, USER_CACHE_LOGIN_CODE_).append(StringUtils.isNotBlank((CharSequence)user.getCorpCode()) ? new StringBuilder().insert(0, user.getCorpCode()).append(ValidCodeUtils.ALLATORIxDEMO("F")).toString() : "").append(user.getLoginCode()).toString());
        CacheUtils.remove(USER_CACHE, new StringBuilder().insert(0, USER_CACHE_USER_TYPE_AND_REF_CODE_).append(user.getUserType()).append(TreeSqlProvider.ALLATORIxDEMO("*")).append(user.getRefCode()).toString());
        UserUtils.clearFoxbpmCache();
    }

    public static List<Menu> getMenuTree() {
        ArrayList a = ListUtils.newArrayList();
        List<Menu> a2 = UserUtils.getMenuList();
        E.ALLATORIxDEMO().convertChildList(a2, a, "0");
        return a2;
    }

    public static User getUser() {
        User a;
        LoginInfo a2 = UserUtils.getLoginInfo();
        if (a2 != null && (a = UserUtils.get(a2.getId())) != null) {
            return a;
        }
        return new User();
    }

    public static String getSsoToken(String username) {
        String a = Global.getConfig(ValidCodeUtils.ALLATORIxDEMO("j{pav=j`v=jvza|gRv`"));
        if (StringUtils.isBlank((CharSequence)a)) {
            logger.warn(TreeSqlProvider.ALLATORIxDEMO("\u5c31\u6052\u65e8\u4e83O\u0006\u0007\u001c\u001d\u001aA\u0006\u001c\u001aA\u0006\n\u0016\u001d\u0010\u001b>\n\fO\u4e4f\u7a15\uff79\u8b98\u8bcb\u7f01\u547b\u51e2\u64b8\u4f33\u3077"));
            return null;
        }
        if (ObjectUtils.toBoolean((Object)Global.getConfig(ValidCodeUtils.ALLATORIxDEMO("`qzk|7`j|7vwpkjigRv`"), "true")).booleanValue()) {
            a = Global.getPropertyDecodeAndEncode(TreeSqlProvider.ALLATORIxDEMO("\tC\u000e\u0016_EW@_G]\u0011\u000bAX\u0013^\u0013\n@W\u0010_\u0011\t\u0013Y\u0013_MWF"), ValidCodeUtils.ALLATORIxDEMO("j{pav=j`v=jvza|gRv`"), a);
        }
        return Md5Utils.md5((String)new StringBuilder().insert(0, a).append(username).append(DateUtils.getDate((String)TreeSqlProvider.ALLATORIxDEMO("\u0016\f\u0016\f\"8\u000b\u0011"))).toString());
    }

    public static Session getSession() {
        try {
            Subject a = UserUtils.getSubject();
            Session a2 = a.getSession(false);
            if (a2 == null) {
                a2 = a.getSession();
            }
            if (a2 != null) {
                return a2;
            }
        }
        catch (UnavailableSecurityManagerException a) {
        }
        catch (InvalidSessionException a) {
            // empty catch block
        }
        return new SimpleSession();
    }

    public static void putCache(String key, Object value) {
        UserUtils.getSession().setAttribute((Object)key, value);
    }

    public static LoginInfo getLoginInfo() {
        try {
            Subject a = UserUtils.getSubject();
            LoginInfo a2 = (LoginInfo)a.getPrincipal();
            if (a2 != null) {
                return a2;
            }
        }
        catch (UnavailableSecurityManagerException a) {
        }
        catch (InvalidSessionException a) {
            // empty catch block
        }
        return null;
    }

    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static void clearFoxbpmCache() {
        Class<?> a3 = Class.forName(ValidCodeUtils.ALLATORIxDEMO("|kt7uvk{ct=|}~zwv7ztcu=zrz{|=Zrz{|Fmzu"));
        try {
            a3.getMethod(TreeSqlProvider.ALLATORIxDEMO("\f\u0019\n\u0014\u001d<\u000b\u0010\u0001\u0001\u0006\u0001\u00166\u000e\u0016\u0007\u0010"), new Class[0]).invoke(null, new Object[0]);
            return;
        }
        catch (Exception a2) {
            try {
                a2.printStackTrace();
                return;
            }
            catch (ClassNotFoundException a3) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static User get(String userCode) {
        User a;
        Object a2;
        if (StringUtils.isBlank((CharSequence)userCode)) {
            return null;
        }
        HttpServletRequest a3 = ServletUtils.getRequest();
        if (a3 != null) {
            a2 = (User)a3.getAttribute(ValidCodeUtils.ALLATORIxDEMO("LFfjvkLF") + userCode);
            if (a2 != null) {
                return a2;
            }
        }
        if ((a = (User)CacheUtils.get(USER_CACHE, (String)(a2 = new StringBuilder().insert(0, USER_CACHE_CODE_).append(userCode).toString()))) != null) {
            return (User)a.clone();
        }
        userCacheLock.lock();
        try {
            a = (User)CacheUtils.get(USER_CACHE, (String)a2);
            if (a != null) {
                User user = (User)a.clone();
                return user;
            }
            User a4 = new User(userCode);
            a = E.ALLATORIxDEMO().get(a4);
            a = UserUtils.returnUser(a);
            if (a3 != null) {
                a3.setAttribute(new StringBuilder().insert(0, TreeSqlProvider.ALLATORIxDEMO("0*\u001a\u0006\n\u00070*")).append(userCode).toString(), (Object)a);
            }
            if (a != null) {
                User user = (User)a.clone();
                return user;
            }
            User user = null;
            return user;
        }
        finally {
            userCacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static User getByLoginCode(String loginCode) {
        if (StringUtils.isBlank((CharSequence)loginCode)) {
            return null;
        }
        String a = new StringBuilder().insert(0, USER_CACHE_LOGIN_CODE_).append(loginCode).toString();
        String a2 = (String)CacheUtils.get(USER_CACHE, a);
        if (a2 != null) {
            return UserUtils.get(a2);
        }
        userCacheLock.lock();
        try {
            a2 = (String)CacheUtils.get(USER_CACHE, a);
            if (a2 != null) {
                User user = UserUtils.get(a2);
                return user;
            }
            User a3 = new User();
            a3.setLoginCode(loginCode);
            a3 = E.ALLATORIxDEMO().getByLoginCode(a3);
            a3 = UserUtils.returnUser(a3);
            if (a3 != null) {
                User user = (User)a3.clone();
                return user;
            }
        }
        finally {
            userCacheLock.unlock();
        }
        return null;
    }

    public static List<Menu> getMenuList() {
        return UserUtils.getMenuListByParentCode(null);
    }

    /*
     * Unable to fully structure code
     */
    public static List<Menu> getMenuListByParentCode(String parentCode) {
        block8: {
            block10: {
                block9: {
                    a = (Map)UserUtils.getCache("menuList");
                    if (a == null) {
                        a = MapUtils.newConcurrentMap();
                        UserUtils.putCache("menuList", a);
                    }
                    a = null;
                    if (parentCode != null) {
                        a = (List<Menu>)a.get(parentCode);
                    }
                    if (a != null) break block8;
                    a = new Menu();
                    a.setParentCode(parentCode);
                    a = UserUtils.getLoginInfo();
                    if (a != null) {
                        a.setSysCode(a.getParam(ValidCodeUtils.ALLATORIxDEMO("jjjPvw|"), "default"));
                    } else {
                        a.setSysCode("default");
                    }
                    a = UserUtils.getUser();
                    if (!User.isSuperAdmin(a.getUserCode())) break block9;
                    a.setWeight_gte(Menu.SUPER_ADMIN_GET_MENU_MIN_WEIGHT);
                    a = E.ALLATORIxDEMO().findList(a);
                    v0 = parentCode;
                    break block10;
                }
                if (!"none".equals(a.getUserType()) && StringUtils.isNotBlank((CharSequence)(a = Global.getConfig(new StringBuilder().insert(0, TreeSqlProvider.ALLATORIxDEMO("\u001c\f\u001c[\u001a\u0006\n\u0007A\u0011\n\u0013\u000e\u0000\u0003\u0001=\u001a\u0003\u0010,\u001a\u000b\u0010\u001c[")).append(a.getUserType()).toString())))) {
                    a.setDefaultRoleCodes(StringUtils.split((String)a, (char)','));
                }
                if (!"1".equals(a.getMgrType())) ** GOTO lbl41
                v1 = a;
                if (a.getDefaultRoleCodes() != null) {
                    v2 = a = SetUtils.newHashSet((Object[])v1.getDefaultRoleCodes());
                    v2.add(Role.CORP_ADMIN_ROLE_CODE);
                    a.setDefaultRoleCodes(v2.toArray(new String[a.size()]));
                    v3 = a;
                } else {
                    v4 = new String[1];
                    v4[0] = Role.CORP_ADMIN_ROLE_CODE;
                    v1.setDefaultRoleCodes(v4);
lbl41:
                    // 2 sources

                    v3 = a;
                }
                v3.setUserCode(a.getId());
                a = E.ALLATORIxDEMO().findByUserCode(a);
                v0 = parentCode;
            }
            if (v0 != null) {
                a.put(parentCode, a);
            }
        }
        return a;
    }

    private static /* synthetic */ User returnUser(User user) {
        if (user == null) {
            return null;
        }
        User user2 = user;
        UserUtils.loadRefObj(user2);
        user2.setRoleList(E.ALLATORIxDEMO().findListByUserCode(new Role(user)));
        CacheUtils.put(USER_CACHE, new StringBuilder().insert(0, USER_CACHE_CODE_).append(user.getId()).toString(), user);
        CacheUtils.put(USER_CACHE, new StringBuilder().insert(0, USER_CACHE_LOGIN_CODE_).append(user.getCorpCode()).append(ValidCodeUtils.ALLATORIxDEMO("F")).append(user.getLoginCode()).toString(), user.getUserCode());
        CacheUtils.put(USER_CACHE, new StringBuilder().insert(0, USER_CACHE_USER_TYPE_AND_REF_CODE_).append(user.getUserType()).append(TreeSqlProvider.ALLATORIxDEMO("*")).append(user.getRefCode()).toString(), user.getUserCode());
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static User getByTypeAndRef(String userType, String refCode) {
        if (StringUtils.isBlank((CharSequence)userType) || StringUtils.isBlank((CharSequence)refCode)) {
            return null;
        }
        String a = new StringBuilder().insert(0, USER_CACHE_USER_TYPE_AND_REF_CODE_).append(userType).append(ValidCodeUtils.ALLATORIxDEMO("F")).append(refCode).toString();
        String a2 = (String)CacheUtils.get(USER_CACHE, a);
        if (a2 != null) {
            return UserUtils.get(a2);
        }
        userCacheLock.lock();
        try {
            User a3;
            a2 = (String)CacheUtils.get(USER_CACHE, a);
            if (a2 != null) {
                User user = UserUtils.get(a2);
                return user;
            }
            User user = new User();
            void v0 = a3;
            v0.setUserType(userType);
            v0.setRefCode(refCode);
            a3 = E.ALLATORIxDEMO().getByUserTypeAndRefCode(a3);
            a3 = UserUtils.returnUser(a3);
            if (a3 != null) {
                User user2 = (User)a3.clone();
                return user2;
            }
        }
        finally {
            userCacheLock.unlock();
        }
        return null;
    }

    public static String getUserTypeValue(String userType, String key) {
        if (E.ALLATORIxDEMO() == null) {
            throw new ServiceException(TreeSqlProvider.ALLATORIxDEMO("\u0005\u0010\n\u0006\u0006\u0001\n[\u0016\u0018\u0003\u4e58\u76eb\u0000\u001c\u0010\u001d[\u001a\u0006\n\u0007;\f\u001f\u0010\"\u0014\u001f\u9138\u7f01\u4e78\u6b0c\u781b\u6279\u6cd4\u6766\u5bef\u4e26\u3077"));
        }
        if ("none".equals(userType)) {
            return null;
        }
        Map a = (Map)E.ALLATORIxDEMO().get(userType);
        if (a != null && a.get(key) != null) {
            return (String)a.get(key);
        }
        logger.warn(new StringBuilder().insert(0, ValidCodeUtils.ALLATORIxDEMO("y|vjzmv7jt\u007f\u4e34\u7697l`|a7fjvkG`c|^xc\u6cb8\u671a\u9154\u7f7d\u2005")).append(userType).append(TreeSqlProvider.ALLATORIxDEMO("\u2068\u7547\u6242\u7c14\u57fe\u76eb\u2069")).append(key).append(ValidCodeUtils.ALLATORIxDEMO("\u2004\u502f\u301b")).toString());
        return null;
    }

    public static Object getCache(String key) {
        return UserUtils.getSession().getAttribute((Object)key);
    }

    public static AuthorizationInfo getAuthInfo() {
        return (AuthorizationInfo)UserUtils.getCache(CACHE_AUTH_INFO);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadRefObj(User user) {
        if (user.getRefObj() != null) return;
        if (!StringUtils.isNotBlank((CharSequence)user.getUserType())) return;
        if (!StringUtils.isNotBlank((CharSequence)user.getRefCode())) return;
        String a = UserUtils.getUserTypeValue(user.getUserType(), TreeSqlProvider.ALLATORIxDEMO("\u0011\u000e\u001a"));
        if (!StringUtils.isNotBlank((CharSequence)a)) return;
        try {
            User user2;
            Object a2;
            block6: {
                int n;
                a2 = SpringUtils.getBean(a);
                Class<?>[] classArray = a2.getClass().getInterfaces();
                int n2 = classArray.length;
                int n3 = n = 0;
                while (n3 < n2) {
                    MyBatisDao a3 = classArray[n].getAnnotation(MyBatisDao.class);
                    if (a3 != null) {
                        Class[] classArray2 = new Class[1];
                        classArray2[0] = String.class;
                        Object[] objectArray = new Object[1];
                        objectArray[0] = user.getRefCode();
                        user.setRefObj(a3.entity().getConstructor(classArray2).newInstance(objectArray));
                        user2 = user;
                        break block6;
                    }
                    n3 = ++n;
                }
                user2 = user;
            }
            if (user2.getRefObj() == null) return;
            Class[] classArray = new Class[1];
            classArray[0] = Object.class;
            Object[] objectArray = new Object[1];
            objectArray[0] = user.getRefObj();
            Object a4 = a2.getClass().getMethod(ValidCodeUtils.ALLATORIxDEMO("~vm"), classArray).invoke(a2, objectArray);
            if (a4 == null) return;
            user.setRefObj(a4);
            return;
        }
        catch (Exception a5) {
            a5.printStackTrace();
        }
    }

    public static void removeCache(String key) {
        UserUtils.getSession().removeAttribute((Object)key);
    }

    public static Object getCache(String key, Object defaultValue) {
        Object a = UserUtils.getCache(key);
        if (a != null) {
            return a;
        }
        return defaultValue;
    }

    public static List<User> findCorpList() {
        User a = new User();
        return E.ALLATORIxDEMO().findCorpList(a);
    }

    public static void clearCache() {
        UserUtils.removeCache(CACHE_AUTH_INFO);
        UserUtils.removeCache(CACHE_MENU_LIST);
        UserUtils.clearCache(UserUtils.getUser());
    }
}

