/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.shiro.session;

import com.jeesite.common.network.IpUtils;
import com.jeesite.common.shiro.session.StaticSession;
import com.jeesite.common.web.http.ServletUtils;
import com.jeesite.modules.file.utils.FileUploadUtils;
import com.jeesite.modules.msg.utils.MsgPushUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager
extends DefaultWebSessionManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultWebSessionManager.class);

    public void validateSessions() {
        super.validateSessions();
    }

    public Session start(SessionContext context) {
        try {
            return super.start(context);
        }
        catch (Exception a2) {
            return StaticSession.INSTANCE;
        }
    }

    public Date getLastAccessTime(SessionKey key) {
        try {
            return super.getLastAccessTime(key);
        }
        catch (InvalidSessionException a2) {
            return new Date();
        }
    }

    public void setAttribute(SessionKey sessionKey, Object attributeKey, Object value) {
        try {
            super.setAttribute(sessionKey, attributeKey, value);
            return;
        }
        catch (InvalidSessionException invalidSessionException) {
            return;
        }
    }

    private /* synthetic */ String getSessionIdCookieValue(ServletRequest request, ServletResponse response) {
        if (!this.isSessionIdCookieEnabled()) {
            log.debug(FileUploadUtils.b("\u0017L7Z-F*\t\rmdJ+F/@!\t-ZdM-Z%K(L \ti\t7L7Z-F*\t-Md^-E(\t*F0\t&LdH'X1@6L \t\"[+DdHd[!X1L7]dJ+F/@!\u0007"));
            return null;
        }
        if (!(request instanceof HttpServletRequest)) {
            log.debug(MsgPushUtils.b("\u007f9N>Y\"HlN)M9Y?HlU?\u001c\"S8\u001c-Rlt8H<o)N:P)H\u001eY=I)O8\u001ca\u001c/]\"R#Hl[)HlO)O?U#Rlu\b\u001c/S#W%Yb\u001cln)H9N\"U\"[lR9P \u0012"));
            return null;
        }
        HttpServletRequest a2 = (HttpServletRequest)request;
        return this.getSessionIdCookie().readValue(a2, WebUtils.toHttp((ServletResponse)response));
    }

    /*
     * WARNING - void declaration
     */
    protected Serializable getSessionId(ServletRequest request, ServletResponse response) {
        String string;
        String a2 = this.getSessionIdCookieValue(request, response);
        if (StringUtils.isNotBlank((CharSequence)a2)) {
            string = a2;
            request.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID_SOURCE, (Object)FileUploadUtils.b("'F+B-L"));
        } else {
            a2 = request.getParameter(MsgPushUtils.b("c\u0013O%X"));
            if (StringUtils.isNotBlank((CharSequence)a2)) {
                if (WebUtils.isTrue((ServletRequest)request, (String)FileUploadUtils.b("\u001bv'F+B-L"))) {
                    void a3;
                    HttpServletRequest a4 = (HttpServletRequest)request;
                    HttpServletResponse a5 = (HttpServletResponse)response;
                    Cookie a6 = this.getSessionIdCookie();
                    SimpleCookie simpleCookie = new SimpleCookie(a6);
                    void v1 = a3;
                    v1.setValue(a2);
                    v1.saveTo(a4, a5);
                }
                request.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID_SOURCE, (Object)MsgPushUtils.b("I>P"));
            }
            string = a2;
        }
        if (string != null) {
            ServletRequest servletRequest = request;
            servletRequest.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID, (Object)a2);
            servletRequest.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID_IS_VALID, (Object)Boolean.TRUE);
        }
        return a2;
    }

    public Date getStartTimestamp(SessionKey key) {
        try {
            return super.getStartTimestamp(key);
        }
        catch (InvalidSessionException a2) {
            return new Date();
        }
    }

    public Collection<Object> getAttributeKeys(SessionKey key) {
        try {
            return super.getAttributeKeys(key);
        }
        catch (InvalidSessionException a2) {
            return null;
        }
    }

    public void setTimeout(SessionKey key, long maxIdleTimeInMillis) {
        try {
            super.setTimeout(key, maxIdleTimeInMillis);
            return;
        }
        catch (InvalidSessionException invalidSessionException) {
            return;
        }
    }

    public long getTimeout(SessionKey key) {
        try {
            return super.getTimeout(key);
        }
        catch (InvalidSessionException a2) {
            return 0L;
        }
    }

    public String getHost(SessionKey key) {
        try {
            return super.getHost(key);
        }
        catch (InvalidSessionException a2) {
            return null;
        }
    }

    protected Session retrieveSession(SessionKey sessionKey) {
        try {
            return super.retrieveSession(sessionKey);
        }
        catch (UnknownSessionException a2) {
            return null;
        }
    }

    public Object getAttribute(SessionKey sessionKey, Object attributeKey) {
        try {
            return super.getAttribute(sessionKey, attributeKey);
        }
        catch (InvalidSessionException a2) {
            return null;
        }
    }

    public void stop(SessionKey key) {
        try {
            super.stop(key);
            return;
        }
        catch (InvalidSessionException invalidSessionException) {
            return;
        }
    }

    public Object removeAttribute(SessionKey sessionKey, Object attributeKey) {
        try {
            return super.removeAttribute(sessionKey, attributeKey);
        }
        catch (InvalidSessionException a2) {
            return null;
        }
    }

    protected Session newSessionInstance(SessionContext context) {
        Session a2 = super.newSessionInstance(context);
        if (a2 instanceof SimpleSession) {
            ((SimpleSession)a2).setHost(IpUtils.getRemoteAddr((HttpServletRequest)ServletUtils.getRequest()));
        }
        return a2;
    }

    public void touch(SessionKey key) {
        block4: {
            Session a22;
            block5: {
                HttpServletRequest a3;
                block6: {
                    a22 = this.doGetSession(key);
                    if (a22 == null) break block4;
                    a3 = ServletUtils.getRequest();
                    if (a3 == null) break block5;
                    if (!ServletUtils.isStaticFile((String)a3.getRequestURI())) break block6;
                    return;
                }
                String a4 = a3.getParameter(FileUploadUtils.b("\u001bv*F0|4M%]!z!Z7@+G"));
                if (!"true".equals(a4) && !"1".equals(a4)) break block5;
                return;
            }
            try {
                a22.touch();
                this.onChange(a22);
                return;
            }
            catch (InvalidSessionException a22) {
                // empty catch block
            }
        }
    }
}

