/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.config;

import com.jeesite.common.config.Global;
import com.jeesite.common.idgen.IdGen;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.service.BaseService;
import com.jeesite.common.shiro.session.CacheSessionDAO;
import com.jeesite.common.shiro.session.JedisSessionDAO;
import com.jeesite.common.shiro.session.SessionDAO;
import com.jeesite.common.shiro.session.SessionManager;
import com.jeesite.modules.sys.utils.ValidCodeUtils;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SessionConfig {
    @Bean(name={"sessionDAO"})
    @ConditionalOnMissingBean(value={SessionDAO.class})
    @ConditionalOnProperty(name={"redis.cacheAndSession"}, havingValue="true", matchIfMissing=false)
    public SessionDAO sessionDAORedis() {
        JedisSessionDAO a2;
        JedisSessionDAO jedisSessionDAO = a2 = new JedisSessionDAO();
        a2.setSessionIdGenerator(new IdGen());
        jedisSessionDAO.setSessionKeyPrefix(new StringBuilder().insert(0, Global.getProperty(BaseService.b("o\fy\u0000nGv\fd9o\f{\u0000e"))).append(ValidCodeUtils.b("KzKlQpV@")).toString());
        return a2;
    }

    @Bean(name={"sessionDAO"})
    @ConditionalOnMissingBean(value={SessionDAO.class})
    @ConditionalOnProperty(name={"redis.cacheAndSession"}, havingValue="false", matchIfMissing=true)
    public SessionDAO sessionDAO(CacheManager shiroCacheManager) {
        CacheSessionDAO a2;
        CacheSessionDAO cacheSessionDAO = a2 = new CacheSessionDAO();
        a2.setSessionIdGenerator(new IdGen());
        cacheSessionDAO.setActiveSessionsCacheName(BaseService.b("|\ni\u0000k\fN\fn\u001at\u0006s\u001a^\b~\u0001x"));
        cacheSessionDAO.setCacheManager(shiroCacheManager);
        return cacheSessionDAO;
    }

    @Bean
    public SimpleCookie sessionIdCookie() {
        SimpleCookie simpleCookie = new SimpleCookie();
        simpleCookie.setName(Global.getProperty(ValidCodeUtils.b("l]lKvWq\u0016l]lKvWqq{{pWtQzv~Uz")));
        return simpleCookie;
    }

    @Bean
    public SessionManager sessionManager(SessionDAO sessionDAO, SimpleCookie sessionIdCookie) {
        SessionManager a2;
        SessionManager sessionManager = a2 = new SessionManager();
        SessionManager sessionManager2 = a2;
        SessionManager sessionManager3 = a2;
        a2.setSessionDAO(sessionDAO);
        sessionManager3.setSessionIdUrlRewritingEnabled(false);
        sessionManager3.setGlobalSessionTimeout(ObjectUtils.toLong((Object)Global.getProperty(BaseService.b("\u001ax\u001an\u0000r\u00073\u001ax\u001an\u0000r\u0007I\u0000p\fr\u001ci"))));
        sessionManager2.setSessionValidationInterval(ObjectUtils.toLong((Object)Global.getProperty(ValidCodeUtils.b("l]lKvWq\u0016l]lKvWqlvUzWjL\\TzYq"))));
        sessionManager2.setSessionValidationSchedulerEnabled(true);
        sessionManager.setSessionIdCookie((Cookie)sessionIdCookie);
        sessionManager.setSessionIdCookieEnabled(true);
        return sessionManager;
    }
}

