/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.job.web;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.d.q.m;
import com.jeesite.common.entity.Page;
import com.jeesite.common.lang.DateUtils;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.config.TransactionConfig;
import com.jeesite.modules.job.entity.JobEntity;
import com.jeesite.modules.job.service.JobService;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.validation.ValidationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.quartz.CronExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/job"})
@ConditionalOnProperty(name={"job.enabled"}, havingValue="true", matchIfMissing=true)
public class JobController
extends BaseController {
    @Autowired
    private JobService jobService;

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"pause"})
    @ResponseBody
    public String pause(JobEntity job) {
        if (!ObjectUtils.toBoolean(m.b().get(TransactionConfig.b("G\u0000k\u0001C"))).booleanValue()) {
            return this.renderResult("false", Page.b("\u5f52\u5212\u7249\u6773\u672b\u5f5f\u653f\u6b3b\u529e\u80a2\uff00"));
        }
        this.jobService.pause(job);
        return this.renderResult("true", TransactionConfig.b("\u66a3\u5032\u8ff1\u8822\u6231\u52f1\uff20"));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"form"})
    public String form(JobEntity jobEntity, Model model) {
        void job;
        void model2;
        model2.addAttribute(Page.b("k0c\u001ao+h+x"), (Object)job);
        return TransactionConfig.b("L\u0001E\u001bM\u000bRAK\u0001CAK\u0001C(N\u001cL");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"checkCron"})
    @ResponseBody
    public String checkCron(String cron, @RequestParam(defaultValue="10") Integer num) {
        StringBuilder a2 = new StringBuilder();
        try {
            void a3;
            CronExpression a4 = new CronExpression(cron);
            if (num <= 0) {
                a2.append(TransactionConfig.b("-S\u0001O\u8806\u8f9f\u5f61\u6b42\u7800\u3023"));
                return this.renderResult("true", a2.toString());
            }
            a2.append(Page.b("=/?\u675f\u8fd0") + num + TransactionConfig.b("\u6b4f\u8ff1\u8822\u65d7\u959a\uff3bR\u000e\u001e\u001f"));
            Date a5 = new Date();
            boolean bl = false;
            void v0 = a3;
            while (v0 <= num) {
                if ((a5 = a4.getTimeAfter(a5)) == null) {
                    return this.renderResult("true", a2.toString());
                }
                a2.append(new StringBuilder().insert(0, DateUtils.formatDateTime((Date)a5)).append(Page.b("=pc-?")).toString());
                v0 = ++a3;
            }
            return this.renderResult("true", a2.toString());
        }
        catch (ParseException a6) {
            return this.renderResult("false", new StringBuilder().insert(0, Page.b("\u001cs0o\u8837\u8fbf\u5f50\u9518\u8bb0\uff1b")).append(a6.getMessage()).toString());
        }
    }

    @RequiresPermissions(value={"sys:job:view"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public List<JobEntity> listData(JobEntity job, String orderBy) {
        List a2 = this.jobService.findList(job);
        a2 = ListUtils.listOrderBy(a2, (String)orderBy);
        return a2;
    }

    @ModelAttribute(value="job")
    public JobEntity get(String jobName, String jobGroup, boolean isNewRecord) {
        JobEntity a2 = null;
        CharSequence[] charSequenceArray = new CharSequence[2];
        charSequenceArray[0] = jobName;
        charSequenceArray[1] = jobGroup;
        if (StringUtils.isNoneBlank((CharSequence[])charSequenceArray)) {
            a2 = this.jobService.get(new JobEntity(jobName, jobGroup));
            if (isNewRecord && a2 != null) {
                throw new ValidationException(TransactionConfig.b("\u542c\u799e\u53eb\u7eaa\u542c\u5d9c\u7eee\u5b36\u5709"));
            }
        }
        if (a2 == null) {
            a2 = new JobEntity();
        }
        return a2;
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"resume"})
    @ResponseBody
    public String resume(JobEntity job) {
        if (!ObjectUtils.toBoolean(m.b().get(Page.b("g1K0c"))).booleanValue()) {
            return this.renderResult("false", TransactionConfig.b("\u5f72\u5223\u7269\u6742\u670b\u5f6e\u651f\u6b0a\u52be\u8093\uff20"));
        }
        this.jobService.resume(job);
        return this.renderResult("true", Page.b("\u6063\u5952\u8fd1\u8813\u6211\u52c0\uff00"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"runOnce"})
    @ResponseBody
    public String runOnce(JobEntity job) {
        if (!ObjectUtils.toBoolean(m.b().get(TransactionConfig.b("G\u0000k\u0001C"))).booleanValue()) {
            return this.renderResult("false", Page.b("\u5f52\u5212\u7249\u6773\u672b\u5f5f\u653f\u6b3b\u529e\u80a2\uff00"));
        }
        this.jobService.runOnce(job);
        return this.renderResult("true", TransactionConfig.b("\u8ff1\u8822\u4e21\u6b4f\u6231\u52f1\uff20"));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:job:view"})
    @RequestMapping(value={"list"})
    public String list(JobEntity job, Model model) {
        void a2;
        Boolean bl = this.jobService.isRunning();
        model.addAttribute(Page.b("h,S*o1h1f"), (Object)a2);
        return TransactionConfig.b("L\u0001E\u001bM\u000bRAK\u0001CAK\u0001C\"H\u001dU");
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"stopAll"})
    @ResponseBody
    public String stopAll() {
        if (!ObjectUtils.toBoolean(m.b().get(Page.b("g1K0c"))).booleanValue()) {
            return this.renderResult("false", TransactionConfig.b("\u5f72\u5223\u7269\u6742\u670b\u5f6e\u651f\u6b0a\u52be\u8093\uff20"));
        }
        if (!this.jobService.stopAll()) {
            return this.renderResult("false", Page.b("\u5003\u6b63\u5bc5\u65f7\u5637\u5930\u8d7a\uff00"));
        }
        return this.renderResult("true", TransactionConfig.b("\u5032\u6b43\u5bf4\u65d7\u5606\u6231\u52f1\uff20"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"startAll"})
    @ResponseBody
    public String startAll() {
        if (!ObjectUtils.toBoolean(m.b().get(Page.b("g1K0c"))).booleanValue()) {
            return this.renderResult("false", TransactionConfig.b("\u5f72\u5223\u7269\u6742\u670b\u5f6e\u651f\u6b0a\u52be\u8093\uff20"));
        }
        if (!this.jobService.startAll()) {
            return this.renderResult("false", Page.b("\u5470\u52a9\u5bc5\u65f7\u5637\u5930\u8d7a\uff00"));
        }
        return this.renderResult("true", TransactionConfig.b("\u5441\u5289\u5bf4\u65d7\u5606\u6231\u52f1\uff20"));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(JobEntity jobEntity) {
        void job;
        JobController jobController = this;
        jobController.jobService.delete((JobEntity)job);
        return jobController.renderResult("true", Page.b("\u5221\u963b\u6211\u52c0\uff00"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated JobEntity job) {
        if (!ObjectUtils.toBoolean(m.b().get(TransactionConfig.b("G\u0000k\u0001C"))).booleanValue()) {
            return this.renderResult("false", Page.b("\u5f52\u5212\u7249\u6773\u672b\u5f5f\u653f\u6b3b\u529e\u80a2\uff00"));
        }
        this.jobService.save(job);
        return this.renderResult("true", TransactionConfig.b("\u4ffc\u5b36\u6231\u52f1\uff20"));
    }
}

