/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.config;

import com.jeesite.common.config.Global;
import com.jeesite.common.idgen.IdGen;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.shiro.session.CacheSessionDAO;
import com.jeesite.common.shiro.session.JedisSessionDAO;
import com.jeesite.common.shiro.session.SessionDAO;
import com.jeesite.common.shiro.session.SessionManager;
import com.jeesite.modules.msg.utils.MsgPushUtils;
import com.jeesite.modules.sys.utils.CorpUtils;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SessionConfig {
    @Bean(name={"sessionDAO"})
    @ConditionalOnMissingBean(value={SessionDAO.class})
    @ConditionalOnProperty(name={"redis.cacheAndSession"}, havingValue="true", matchIfMissing=false)
    public SessionDAO sessionDAORedis() {
        JedisSessionDAO a2;
        JedisSessionDAO jedisSessionDAO = a2 = new JedisSessionDAO();
        a2.setSessionIdGenerator(new IdGen());
        jedisSessionDAO.setSessionKeyPrefix(new StringBuilder().insert(0, Global.getProperty(MsgPushUtils.true("\u0014N\u0002B\u0015\u0005\rN\u001f{\u0014N\u0000B\u001e"))).append(CorpUtils.true(")r)d3x4H")).toString());
        return a2;
    }

    @Bean(name={"sessionDAO"})
    @ConditionalOnMissingBean(value={SessionDAO.class})
    @ConditionalOnProperty(name={"redis.cacheAndSession"}, havingValue="false", matchIfMissing=true)
    public SessionDAO sessionDAO(CacheManager shiroCacheManager) {
        CacheSessionDAO a2;
        CacheSessionDAO cacheSessionDAO = a2 = new CacheSessionDAO();
        a2.setSessionIdGenerator(new IdGen());
        cacheSessionDAO.setActiveSessionsCacheName(MsgPushUtils.true("\u0007H\u0012B\u0010N5N\u0015X\u000fD\bX%J\u0005C\u0003"));
        cacheSessionDAO.setCacheManager(shiroCacheManager);
        return cacheSessionDAO;
    }

    @Bean
    public SessionManager sessionManager(SessionDAO sessionDAO, SimpleCookie sessionIdCookie) {
        SessionManager a2;
        SessionManager sessionManager = a2 = new SessionManager();
        SessionManager sessionManager2 = a2;
        SessionManager sessionManager3 = a2;
        a2.setSessionDAO(sessionDAO);
        sessionManager3.setSessionIdUrlRewritingEnabled(false);
        sessionManager3.setGlobalSessionTimeout(ObjectUtils.toLong((Object)Global.getProperty(CorpUtils.true(")r)d3x49)r)d3x4C3z?x/c"))));
        sessionManager2.setSessionValidationInterval(ObjectUtils.toLong((Object)Global.getProperty(MsgPushUtils.true("\u0015N\u0015X\u000fD\b\u0005\u0015N\u0015X\u000fD\b\u007f\u000fF\u0003D\u0013_%G\u0003J\b"))));
        sessionManager2.setSessionValidationSchedulerEnabled(true);
        sessionManager.setSessionIdCookie((Cookie)sessionIdCookie);
        sessionManager.setSessionIdCookieEnabled(true);
        return sessionManager;
    }

    @Bean
    public SimpleCookie sessionIdCookie() {
        SimpleCookie simpleCookie = new SimpleCookie();
        simpleCookie.setName(Global.getProperty(CorpUtils.true("d?d)~5ytd?d)~5y\u0013s\u0019x5|3r\u0014v7r")));
        return simpleCookie;
    }
}

