/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.job.service;

import com.beust.jcommander.internal.Lists;
import com.jeesite.common.config.Global;
import com.jeesite.common.datasource.RoutingDataSource;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.s.p.D;
import com.jeesite.common.s.p.H;
import com.jeesite.common.service.CrudService;
import com.jeesite.common.service.ServiceException;
import com.jeesite.modules.job.dao.JobDao;
import com.jeesite.modules.job.entity.JobEntity;
import com.jeesite.modules.job.listener.JobDetalListener;
import com.jeesite.modules.job.listener.JobSchedulerListener;
import com.jeesite.modules.job.listener.JobTriggerListener;
import com.jeesite.modules.job.s.l;
import com.jeesite.modules.job.service.JobLogService;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.quartz.JobListener;
import org.quartz.ListenerManager;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.DependsOn;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DependsOn(value={"dbUpgrade"})
@Transactional(readOnly=true)
@ConditionalOnProperty(name={"job.enabled"}, havingValue="true", matchIfMissing=true)
public class JobService
extends CrudService<JobDao, JobEntity> {
    @Autowired
    private JobLogService jobLogService;
    private SchedulerFactoryBean scheduler;
    @Autowired
    private RoutingDataSource dataSource;

    public Scheduler getScheduler() {
        return this.scheduler.getScheduler();
    }

    public boolean stopAll() {
        if (!ObjectUtils.toBoolean(H.true().get(l.true((Object)"c\u0007O\u0006g"))).booleanValue()) {
            return false;
        }
        try {
            this.scheduler.stop();
        }
        catch (Exception a2) {
            this.logger.error(D.true("\u504b\u6b14\u5b8d\u6580\u567f\u5947\u8d32\uff77"), (Throwable)a2);
            return false;
        }
        return true;
    }

    @Transactional(readOnly=false)
    public void resume(JobEntity job) {
        if (!ObjectUtils.toBoolean(H.true().get(l.true((Object)"c\u0007O\u0006g"))).booleanValue()) {
            return;
        }
        job.setStatus("0");
        super.updateStatus(job);
        try {
            TriggerKey a2 = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            JobService jobService = this;
            Trigger a3 = jobService.getScheduler().getTrigger(a2);
            jobService.getScheduler().resumeJob(a3.getJobKey());
            jobService.getScheduler().resumeTrigger(a3.getKey());
            return;
        }
        catch (SchedulerException a4) {
            throw new ServiceException(D.true("\u6014\u591a\u8fa6\u885b\u5947\u8d32\uff77"), a4);
        }
    }

    @PostConstruct
    private /* synthetic */ void initialize() throws Exception {
        JobEntity a2;
        if (Global.isTestProfileActive()) {
            return;
        }
        JobService jobService = this;
        jobService.scheduler = new SchedulerFactoryBean();
        jobService.scheduler.setAutoStartup(ObjectUtils.toBoolean((Object)Global.getProperty(l.true((Object)"o\u0006gGd\u001cq\u0006V\u001dd\u001bq\u001cu"), "true")).booleanValue());
        jobService.scheduler.setStartupDelay(ObjectUtils.toInteger((Object)Global.getProperty(D.true("}\u0019uXd\u0002v\u0004c\u0003g2r\u001av\u000f"), l.true((Object)"_5"))).intValue());
        if (!ObjectUtils.toBoolean(H.true().get(D.true("\u0010y<x\u0014"))).booleanValue()) {
            this.scheduler.afterPropertiesSet();
            return;
        }
        JobService jobService2 = this;
        jobService2.scheduler.setQuartzProperties(l.true());
        JobService jobService3 = this;
        jobService2.scheduler.setDataSource((DataSource)((Object)jobService3.dataSource));
        jobService3.scheduler.afterPropertiesSet();
        if (jobService2.scheduler.isAutoStartup()) {
            this.scheduler.start();
        }
        JobEntity jobEntity = a2 = new JobEntity();
        jobEntity.setStatus("");
        for (JobEntity a3 : super.findList(jobEntity)) {
            if ("1".equals(a2.getStatus())) {
                this.delete(a2);
                continue;
            }
            try {
                this.save(a3, false);
            }
            catch (Exception a4) {
                this.logger.warn(a4.getMessage(), (Throwable)a4);
            }
        }
        try {
            ListenerManager a5;
            ListenerManager listenerManager = a5 = this.getScheduler().getListenerManager();
            a5.addJobListener((JobListener)new JobDetalListener(this.jobLogService));
            listenerManager.addTriggerListener((TriggerListener)new JobTriggerListener(this.jobLogService));
            a5.addSchedulerListener((SchedulerListener)new JobSchedulerListener(this.jobLogService));
            return;
        }
        catch (SchedulerException a6) {
            this.logger.error(l.true((Object)"\u4f59\u4e73\u76d4\u5445\u4e8e\u4e9f\u5f07\u5e51\uff04"), (Throwable)a6);
            return;
        }
    }

    public boolean isRunning() {
        block3: {
            try {
                if (this.getScheduler().isInStandbyMode() || !this.getScheduler().isStarted()) break block3;
                return true;
            }
            catch (Exception a2) {
                this.logger.error(D.true("\u83c1\u53c1\u5bec\u65e1\u561e\u72a1\u6077\u65e1\u5947\u8d32\uff77"), (Throwable)a2);
                return false;
            }
        }
        return false;
    }

    @Transactional(readOnly=false)
    public void pause(JobEntity job) {
        if (!ObjectUtils.toBoolean(H.true().get(l.true((Object)"c\u0007O\u0006g"))).booleanValue()) {
            return;
        }
        job.setStatus("2");
        super.updateStatus(job);
        try {
            TriggerKey a2 = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            JobService jobService = this;
            Trigger a3 = jobService.getScheduler().getTrigger(a2);
            jobService.getScheduler().pauseJob(a3.getJobKey());
            jobService.getScheduler().pauseTrigger(a3.getKey());
            return;
        }
        catch (SchedulerException a4) {
            throw new ServiceException(D.true("\u66f4\u504b\u8fa6\u885b\u5947\u8d32\uff77"), a4);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void save(JobEntity job) {
        this.save(job, true);
    }

    @Override
    public List<JobEntity> findList(JobEntity job) {
        List a2 = Lists.newArrayList();
        try {
            Scheduler a3 = this.getScheduler();
            Iterator iterator = a3.getTriggerGroupNames().iterator();
            while (iterator.hasNext()) {
                GroupMatcher a4 = GroupMatcher.groupEquals((String)((String)iterator.next()));
                for (TriggerKey a5 : a3.getTriggerKeys(a4)) {
                    Trigger a6 = a3.getTrigger(a5);
                    if (!(a6 instanceof CronTriggerImpl)) continue;
                    a2.add(new JobEntity().convert(a3, (CronTriggerImpl)a6));
                }
            }
        }
        catch (Exception a7) {
            this.logger.error(l.true((Object)"\u67e0\u8b8b\u4efe\u52c8\u5212\u8801\u5934\u8d4c\uff04"), (Throwable)a7);
        }
        return a2;
    }

    public boolean startAll() {
        if (!ObjectUtils.toBoolean(H.true().get(D.true("\u0010y<x\u0014"))).booleanValue()) {
            return false;
        }
        try {
            JobService jobService = this;
            jobService.scheduler.setStartupDelay(0);
            jobService.scheduler.start();
        }
        catch (Exception a2) {
            this.logger.error(l.true((Object)"\u5446\u52ad\u5bf3\u65f3\u5601\u5934\u8d4c\uff04"), (Throwable)a2);
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Transactional(readOnly=false)
    public void save(JobEntity job, boolean isSaveToDb) {
        block6: {
            block7: {
                if (!ObjectUtils.toBoolean(H.true().get(D.true("\u0010y<x\u0014"))).booleanValue()) {
                    return;
                }
                v0 = job;
                a = l.true(v0);
                a = l.true(v0, a);
                if (!isSaveToDb) break block6;
                if (!job.getIsNewRecord()) break block7;
                v1 = this;
                v2 = v1;
                super.insert(job);
                ** GOTO lbl17
            }
            super.update(job);
        }
        try {
            v2 = this;
lbl17:
            // 2 sources

            v2.getScheduler().addJob(a, true);
            v3 = this;
            if (this.getScheduler().getTrigger(a.getKey()) != null) {
                v3.getScheduler().rescheduleJob(a.getKey(), (Trigger)a);
            } else {
                v3.getScheduler().scheduleJob((Trigger)a);
            }
            if ("2".equals(job.getStatus())) {
                v4 = this;
                v4.getScheduler().pauseJob(a.getJobKey());
                v4.getScheduler().pauseTrigger(a.getKey());
                return;
            }
        }
        catch (Exception a) {
            throw new ServiceException(l.true((Object)"\u6dfe\u52c9\u8ba4\u527b\u4efe\u52c8\u5934\u8d4c\uff04"), a);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(JobEntity job) {
        if (!ObjectUtils.toBoolean(H.true().get(D.true("\u0010y<x\u0014"))).booleanValue()) {
            return;
        }
        super.delete(job);
        try {
            TriggerKey a2 = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            Trigger a3 = this.getScheduler().getTrigger(a2);
            if (a3 != null) {
                JobService jobService = this;
                jobService.getScheduler().deleteJob(a3.getJobKey());
                jobService.getScheduler().unscheduleJob(a3.getKey());
                return;
            }
        }
        catch (SchedulerException a4) {
            throw new ServiceException(l.true((Object)"\u5225\u960d\u5934\u8d4c\uff04"), a4);
        }
    }

    @Transactional(readOnly=false)
    public void runOnce(JobEntity job) {
        if (!ObjectUtils.toBoolean(H.true().get(D.true("\u0010y<x\u0014"))).booleanValue()) {
            return;
        }
        try {
            TriggerKey a2 = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            JobService jobService = this;
            Trigger a3 = jobService.getScheduler().getTrigger(a2);
            jobService.getScheduler().triggerJob(a3.getJobKey());
            return;
        }
        catch (SchedulerException a4) {
            throw new ServiceException(l.true((Object)"\u8fd5\u8825\u4e05\u6b48\u5934\u8d4c\uff04"), a4);
        }
    }

    @Override
    public JobEntity get(JobEntity job) {
        JobEntity a2 = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)job.getJobName()) && StringUtils.isNotBlank((CharSequence)job.getJobGroup())) {
                TriggerKey a3 = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
                Trigger a4 = this.getScheduler().getTrigger(a3);
                if (a4 instanceof CronTriggerImpl) {
                    a2 = new JobEntity().convert(this.getScheduler(), (CronTriggerImpl)a4);
                }
            }
        }
        catch (SchedulerException a5) {
            this.logger.error(D.true("\u83c1\u53c1\u5947\u8d32\uff77"), (Throwable)a5);
        }
        return a2;
    }
}

