/*!
 * Bootstrap Colorpicker
 * http://mjolnic.github.io/bootstrap-colorpicker/
 *
 * Originally written by (c) 2012 Stefan Petre
 * Licensed under the Apache License v2.0
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * @todo Update DOCS
 */
(function(a){if(typeof exports==="object"){module.exports=a(window.jQuery)}else{if(typeof define==="function"&&define.amd){define(["jquery"],a)}else{if(window.jQuery&&!window.jQuery.fn.colorpicker){a(window.jQuery)}}}}(function(b){var d=function(f,e){this.value={h:0,s:0,b:0,a:1};this.origFormat=null;if(e){b.extend(this.colors,e)}if(f){if(f.toLowerCase!==undefined){f=f+"";this.setColor(f)}else{if(f.h!==undefined){this.value=f}}}};d.prototype={constructor:d,colors:{aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgrey:"#d3d3d3",lightgreen:"#90ee90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370d8",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#d87093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32",transparent:"transparent"},_sanitizeNumber:function(e){if(typeof e==="number"){return e}if(isNaN(e)||(e===null)||(e==="")||(e===undefined)){return 1}if(e.toLowerCase!==undefined){return parseFloat(e)}return 1},isTransparent:function(e){if(!e){return false}e=e.toLowerCase().trim();return(e==="transparent")||(e.match(/#?00000000/))||(e.match(/(rgba|hsla)\(0,0,0,0?\.?0\)/))},rgbaIsTransparent:function(e){return((e.r===0)&&(e.g===0)&&(e.b===0)&&(e.a===0))},setColor:function(e){e=e.toLowerCase().trim();if(e){if(this.isTransparent(e)){this.value={h:0,s:0,b:0,a:0}}else{this.value=this.stringToHSB(e)||{h:0,s:0,b:0,a:1}}}},stringToHSB:function(g){g=g.toLowerCase();var f;if(typeof this.colors[g]!=="undefined"){g=this.colors[g];f="alias"}var h=this,e=false;b.each(this.stringParsers,function(l,n){var k=n.re.exec(g),j=k&&n.parse.apply(h,[k]),m=f||n.format||"rgba";if(j){if(m.match(/hsla?/)){e=h.RGBtoHSB.apply(h,h.HSLtoRGB.apply(h,j))}else{e=h.RGBtoHSB.apply(h,j)}h.origFormat=m;return false}return true});return e},setHue:function(e){this.value.h=1-e},setSaturation:function(e){this.value.s=e},setBrightness:function(e){this.value.b=1-e},setAlpha:function(e){this.value.a=parseInt((1-e)*100,10)/100},toRGB:function(j,n,k,l){if(!j){j=this.value.h;n=this.value.s;k=this.value.b}j*=360;var i,m,f,g,e;j=(j%360)/60;e=k*n;g=e*(1-Math.abs(j%2-1));i=m=f=k-e;j=~~j;i+=[e,g,0,0,g,e][j];m+=[g,e,e,g,0,0][j];f+=[0,0,g,e,e,g][j];return{r:Math.round(i*255),g:Math.round(m*255),b:Math.round(f*255),a:l||this.value.a}},toHex:function(j,i,e,f){var g=this.toRGB(j,i,e,f);if(this.rgbaIsTransparent(g)){return"transparent"}return"#"+((1<<24)|(parseInt(g.r)<<16)|(parseInt(g.g)<<8)|parseInt(g.b)).toString(16).substr(1)},toHSL:function(l,k,f,g){l=l||this.value.h;k=k||this.value.s;f=f||this.value.b;g=g||this.value.a;var j=l,e=(2-k)*f,i=k*f;if(e>0&&e<=1){i/=e}else{i/=2-e}e/=2;if(i>1){i=1}return{h:isNaN(j)?0:j,s:isNaN(i)?0:i,l:isNaN(e)?0:e,a:isNaN(g)?0:g}},toAlias:function(k,j,e,f){var h=this.toHex(k,j,e,f);for(var i in this.colors){if(this.colors[i]===h){return i}}return false},RGBtoHSB:function(l,k,e,h){l/=255;k/=255;e/=255;var j,i,f,m;f=Math.max(l,k,e);m=f-Math.min(l,k,e);j=(m===0?null:f===l?(k-e)/m:f===k?(e-l)/m+2:(l-k)/m+4);j=((j+360)%6)*60/360;i=m===0?0:m/f;return{h:this._sanitizeNumber(j),s:i,b:f,a:this._sanitizeNumber(h)}},HueToRGB:function(g,f,e){if(e<0){e+=1}else{if(e>1){e-=1}}if((e*6)<1){return g+(f-g)*e*6}else{if((e*2)<1){return f}else{if((e*3)<2){return g+(f-g)*((2/3)-e)*6}else{return g}}}},HSLtoRGB:function(n,w,k,v){if(w<0){w=0}var f;if(k<=0.5){f=k*(1+w)}else{f=k+w-(k*w)}var i=2*k-f;var t=n+(1/3);var j=n;var m=n-(1/3);var e=Math.round(this.HueToRGB(i,f,t)*255);var o=Math.round(this.HueToRGB(i,f,j)*255);var u=Math.round(this.HueToRGB(i,f,m)*255);return[e,o,u,this._sanitizeNumber(v)]},toString:function(e){e=e||"rgba";var f=false;switch(e){case"rgb":f=this.toRGB();if(this.rgbaIsTransparent(f)){return"transparent"}return"rgb("+f.r+","+f.g+","+f.b+")";break;case"rgba":f=this.toRGB();return"rgba("+f.r+","+f.g+","+f.b+","+f.a+")";break;case"hsl":f=this.toHSL();return"hsl("+Math.round(f.h*360)+","+Math.round(f.s*100)+"%,"+Math.round(f.l*100)+"%)";break;case"hsla":f=this.toHSL();return"hsla("+Math.round(f.h*360)+","+Math.round(f.s*100)+"%,"+Math.round(f.l*100)+"%,"+f.a+")";break;case"hex":return this.toHex();break;case"alias":return this.toAlias()||this.toHex();default:return f;break}},stringParsers:[{re:/rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*?\)/,format:"rgb",parse:function(e){return[e[1],e[2],e[3],1]}},{re:/rgb\(\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*?\)/,format:"rgb",parse:function(e){return[2.55*e[1],2.55*e[2],2.55*e[3],1]}},{re:/rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)/,format:"rgba",parse:function(e){return[e[1],e[2],e[3],e[4]]}},{re:/rgba\(\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)/,format:"rgba",parse:function(e){return[2.55*e[1],2.55*e[2],2.55*e[3],e[4]]}},{re:/hsl\(\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*?\)/,format:"hsl",parse:function(e){return[e[1]/360,e[2]/100,e[3]/100,e[4]]}},{re:/hsla\(\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)/,format:"hsla",parse:function(e){return[e[1]/360,e[2]/100,e[3]/100,e[4]]}},{re:/#?([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/,format:"hex",parse:function(e){return[parseInt(e[1],16),parseInt(e[2],16),parseInt(e[3],16),1]}},{re:/#?([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/,format:"hex",parse:function(e){return[parseInt(e[1]+e[1],16),parseInt(e[2]+e[2],16),parseInt(e[3]+e[3],16),1]}}],colorNameToHex:function(e){if(typeof this.colors[e.toLowerCase()]!=="undefined"){return this.colors[e.toLowerCase()]}return false}};var c={horizontal:false,inline:false,color:false,format:false,input:"input",container:false,component:".add-on, .input-group-addon",sliders:{saturation:{maxLeft:100,maxTop:100,callLeft:"setSaturation",callTop:"setBrightness"},hue:{maxLeft:0,maxTop:100,callLeft:false,callTop:"setHue"},alpha:{maxLeft:0,maxTop:100,callLeft:false,callTop:"setAlpha"}},slidersHorz:{saturation:{maxLeft:100,maxTop:100,callLeft:"setSaturation",callTop:"setBrightness"},hue:{maxLeft:100,maxTop:0,callLeft:"setHue",callTop:false},alpha:{maxLeft:100,maxTop:0,callLeft:"setAlpha",callTop:false}},template:'<div class="colorpicker dropdown-menu"><div class="colorpicker-saturation"><i><b></b></i></div><div class="colorpicker-hue"><i></i></div><div class="colorpicker-alpha"><i></i></div><div class="colorpicker-color"><div /></div><div class="colorpicker-selectors"></div></div>',align:"right",customClass:null,colorSelectors:null};var a=function(g,f){this.element=b(g).addClass("colorpicker-element");this.options=b.extend(true,{},c,this.element.data(),f);this.component=this.options.component;this.component=(this.component!==false)?this.element.find(this.component):false;if(this.component&&(this.component.length===0)){this.component=false}this.container=(this.options.container===true)?this.element:this.options.container;this.container=(this.container!==false)?b(this.container):false;this.input=this.element.is("input")?this.element:(this.options.input?this.element.find(this.options.input):false);if(this.input&&(this.input.length===0)){this.input=false}this.color=new d(this.options.color!==false?this.options.color:this.getValue(),this.options.colorSelectors);this.format=this.options.format!==false?this.options.format:this.color.origFormat;this.picker=b(this.options.template);if(this.options.customClass){this.picker.addClass(this.options.customClass)}if(this.options.inline){this.picker.addClass("colorpicker-inline colorpicker-visible")}else{this.picker.addClass("colorpicker-hidden")}if(this.options.horizontal){this.picker.addClass("colorpicker-horizontal")}if(this.format==="rgba"||this.format==="hsla"||this.options.format===false){this.picker.addClass("colorpicker-with-alpha")}if(this.options.align==="right"){this.picker.addClass("colorpicker-right")}if(this.options.colorSelectors){var e=this;b.each(this.options.colorSelectors,function(i,h){var j=b("<i />").css("background-color",h).data("class",i);j.click(function(){e.setValue(b(this).css("background-color"))});e.picker.find(".colorpicker-selectors").append(j)});this.picker.find(".colorpicker-selectors").show()}this.picker.on("mousedown.colorpicker touchstart.colorpicker",b.proxy(this.mousedown,this));this.picker.appendTo(this.container?this.container:b("body"));if(this.input!==false){this.input.on({"keyup.colorpicker":b.proxy(this.keyup,this)});this.input.on({"change.colorpicker":b.proxy(this.change,this)});if(this.component===false){this.element.on({"focus.colorpicker":b.proxy(this.show,this)})}if(this.options.inline===false){this.element.on({"focusout.colorpicker":b.proxy(this.hide,this)})}}if(this.component!==false){this.component.on({"click.colorpicker":b.proxy(this.show,this)})}if((this.input===false)&&(this.component===false)){this.element.on({"click.colorpicker":b.proxy(this.show,this)})}if((this.input!==false)&&(this.component!==false)&&(this.input.attr("type")==="color")){this.input.on({"click.colorpicker":b.proxy(this.show,this),"focus.colorpicker":b.proxy(this.show,this)})}this.update();b(b.proxy(function(){this.element.trigger("create")},this))};a.Color=d;a.prototype={constructor:a,destroy:function(){this.picker.remove();this.element.removeData("colorpicker").off(".colorpicker");if(this.input!==false){this.input.off(".colorpicker")}if(this.component!==false){this.component.off(".colorpicker")}this.element.removeClass("colorpicker-element");this.element.trigger({type:"destroy"})},reposition:function(){if(this.options.inline!==false||this.options.container){return false}var f=this.container&&this.container[0]!==document.body?"position":"offset";var e=this.component||this.element;var g=e[f]();if(this.options.align==="right"){g.left-=this.picker.outerWidth()-e.outerWidth()}this.picker.css({top:g.top+e.outerHeight(),left:g.left})},show:function(f){if(this.isDisabled()){return false}this.picker.addClass("colorpicker-visible").removeClass("colorpicker-hidden");this.reposition();b(window).on("resize.colorpicker",b.proxy(this.reposition,this));if(f&&(!this.hasInput()||this.input.attr("type")==="color")){if(f.stopPropagation&&f.preventDefault){f.stopPropagation();f.preventDefault()}}if(this.options.inline===false){b(window.document).on({"mousedown.colorpicker":b.proxy(this.hide,this)})}this.element.trigger({type:"showPicker",color:this.color})},hide:function(){this.picker.addClass("colorpicker-hidden").removeClass("colorpicker-visible");b(window).off("resize.colorpicker",this.reposition);b(document).off({"mousedown.colorpicker":this.hide});this.update();this.element.trigger({type:"hidePicker",color:this.color})},updateData:function(e){e=e||this.color.toString(this.format);this.element.data("color",e);return e},updateInput:function(g){g=g||this.color.toString(this.format);if(this.input!==false){if(this.options.colorSelectors){var e=new d(g,this.options.colorSelectors);var f=e.toAlias();if(typeof this.options.colorSelectors[f]!=="undefined"){g=f}}this.input.prop("value",g)}return g},updatePicker:function(g){if(g!==undefined){this.color=new d(g,this.options.colorSelectors)}var e=(this.options.horizontal===false)?this.options.sliders:this.options.slidersHorz;var f=this.picker.find("i");if(f.length===0){return}if(this.options.horizontal===false){e=this.options.sliders;f.eq(1).css("top",e.hue.maxTop*(1-this.color.value.h)).end().eq(2).css("top",e.alpha.maxTop*(1-this.color.value.a))}else{e=this.options.slidersHorz;f.eq(1).css("left",e.hue.maxLeft*(1-this.color.value.h)).end().eq(2).css("left",e.alpha.maxLeft*(1-this.color.value.a))}f.eq(0).css({top:e.saturation.maxTop-this.color.value.b*e.saturation.maxTop,left:this.color.value.s*e.saturation.maxLeft});this.picker.find(".colorpicker-saturation").css("backgroundColor",this.color.toHex(this.color.value.h,1,1,1));this.picker.find(".colorpicker-alpha").css("backgroundColor",this.color.toHex());this.picker.find(".colorpicker-color, .colorpicker-color div").css("backgroundColor",this.color.toString(this.format));return g},updateComponent:function(f){f=f||this.color.toString(this.format);if(this.component!==false){var e=this.component.find("i").eq(0);if(e.length>0){e.css({backgroundColor:f})}else{this.component.css({backgroundColor:f})}}return f},update:function(e){var f;if((this.getValue(false)!==false)||(e===true)){f=this.updateComponent();this.updateInput(f);this.updateData(f);this.updatePicker()}return f},setValue:function(e){this.color=new d(e,this.options.colorSelectors);this.update(true);this.element.trigger({type:"changeColor",color:this.color,value:e})},getValue:function(e){e=(e===undefined)?"#000000":e;var f;if(this.hasInput()){f=this.input.val()}else{f=this.element.data("color")}if((f===undefined)||(f==="")||(f===null)){f=e}return f},hasInput:function(){return(this.input!==false)},isDisabled:function(){if(this.hasInput()){return(this.input.prop("disabled")===true)}return false},disable:function(){if(this.hasInput()){this.input.prop("disabled",true);this.element.trigger({type:"disable",color:this.color,value:this.getValue()});return true}return false},enable:function(){if(this.hasInput()){this.input.prop("disabled",false);this.element.trigger({type:"enable",color:this.color,value:this.getValue()});return true}return false},currentSlider:null,mousePointer:{left:0,top:0},mousedown:function(i){if(!i.pageX&&!i.pageY&&i.originalEvent){i.pageX=i.originalEvent.touches[0].pageX;i.pageY=i.originalEvent.touches[0].pageY}i.stopPropagation();i.preventDefault();var h=b(i.target);var g=h.closest("div");var f=this.options.horizontal?this.options.slidersHorz:this.options.sliders;if(!g.is(".colorpicker")){if(g.is(".colorpicker-saturation")){this.currentSlider=b.extend({},f.saturation)}else{if(g.is(".colorpicker-hue")){this.currentSlider=b.extend({},f.hue)}else{if(g.is(".colorpicker-alpha")){this.currentSlider=b.extend({},f.alpha)}else{return false}}}var j=g.offset();this.currentSlider.guide=g.find("i")[0].style;this.currentSlider.left=i.pageX-j.left;this.currentSlider.top=i.pageY-j.top;this.mousePointer={left:i.pageX,top:i.pageY};b(document).on({"mousemove.colorpicker":b.proxy(this.mousemove,this),"touchmove.colorpicker":b.proxy(this.mousemove,this),"mouseup.colorpicker":b.proxy(this.mouseup,this),"touchend.colorpicker":b.proxy(this.mouseup,this)}).trigger("mousemove")}return false},mousemove:function(h){if(!h.pageX&&!h.pageY&&h.originalEvent){h.pageX=h.originalEvent.touches[0].pageX;h.pageY=h.originalEvent.touches[0].pageY}h.stopPropagation();h.preventDefault();var g=Math.max(0,Math.min(this.currentSlider.maxLeft,this.currentSlider.left+((h.pageX||this.mousePointer.left)-this.mousePointer.left)));var f=Math.max(0,Math.min(this.currentSlider.maxTop,this.currentSlider.top+((h.pageY||this.mousePointer.top)-this.mousePointer.top)));this.currentSlider.guide.left=g+"px";this.currentSlider.guide.top=f+"px";if(this.currentSlider.callLeft){this.color[this.currentSlider.callLeft].call(this.color,g/this.currentSlider.maxLeft)}if(this.currentSlider.callTop){this.color[this.currentSlider.callTop].call(this.color,f/this.currentSlider.maxTop)}if(this.currentSlider.callTop==="setAlpha"&&this.options.format===false){if(this.color.value.a!==1){this.format="rgba";this.color.origFormat="rgba"}else{this.format="hex";this.color.origFormat="hex"}}this.update(true);this.element.trigger({type:"changeColor",color:this.color});return false},mouseup:function(f){f.stopPropagation();f.preventDefault();b(document).off({"mousemove.colorpicker":this.mousemove,"touchmove.colorpicker":this.mousemove,"mouseup.colorpicker":this.mouseup,"touchend.colorpicker":this.mouseup});return false},change:function(f){this.keyup(f)},keyup:function(f){if((f.keyCode===38)){if(this.color.value.a<1){this.color.value.a=Math.round((this.color.value.a+0.01)*100)/100}this.update(true)}else{if((f.keyCode===40)){if(this.color.value.a>0){this.color.value.a=Math.round((this.color.value.a-0.01)*100)/100}this.update(true)}else{this.color=new d(this.input.val(),this.options.colorSelectors);if(this.color.origFormat&&this.options.format===false){this.format=this.color.origFormat}if(this.getValue(false)!==false){this.updateData();this.updateComponent();this.updatePicker()}}}this.element.trigger({type:"changeColor",color:this.color,value:this.input.val()})}};b.colorpicker=a;b.fn.colorpicker=function(f){var e=arguments,h;var g=this.each(function(){var k=b(this),j=k.data("colorpicker"),i=((typeof f==="object")?f:{});if((!j)&&(typeof f!=="string")){k.data("colorpicker",new a(this,i))}else{if(typeof f==="string"){h=j[f].apply(j,Array.prototype.slice.call(e,1))}}});if(f==="getValue"){return h}return g};b.fn.colorpicker.constructor=a}));