/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.shiro.session;

import com.jeesite.common.collect.MapUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.mgt.ValidatingSession;

public class StaticSession
implements ValidatingSession,
Serializable {
    private Serializable id = "1";
    public static final StaticSession INSTANCE = new StaticSession();
    private Date startTimestamp;
    private static final long serialVersionUID = 1L;
    private Map<Object, Object> attributes;

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public Date getLastAccessTime() {
        return new Date();
    }

    public StaticSession() {
        StaticSession staticSession = this;
        this.startTimestamp = new Date();
        staticSession.attributes = MapUtils.newHashMap();
    }

    public void validate() throws InvalidSessionException {
    }

    public String getHost() {
        return null;
    }

    public Collection<Object> getAttributeKeys() throws InvalidSessionException {
        return this.attributes.keySet();
    }

    public Object removeAttribute(Object key) throws InvalidSessionException {
        return this.attributes.remove(key);
    }

    public long getTimeout() throws InvalidSessionException {
        return Long.MAX_VALUE;
    }

    public Serializable getId() {
        return this.id;
    }

    public void stop() throws InvalidSessionException {
    }

    public void touch() throws InvalidSessionException {
    }

    public void setTimeout(long maxIdleTimeInMillis) throws InvalidSessionException {
    }

    public boolean isValid() {
        return true;
    }

    public Object getAttribute(Object key) throws InvalidSessionException {
        return this.attributes.get(key);
    }

    public void setAttribute(Object key, Object value) throws InvalidSessionException {
        this.attributes.put(key, value);
    }
}

