/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ContextLocalBuffer {
    public static int charBufferSize = 256;
    public static int byteBufferSize = 256;
    public static int MAX_SIZE = 4096;
    public static int BYTE_MAX_SIZE = 16384;
    public static boolean isSoft = true;
    public static boolean isThreadLocal = true;
    private char[] charBuffer = new char[charBufferSize];
    private byte[] byteBuffer = new byte[byteBufferSize];
    private char[] EMPTY_CHAR_ARRAY = new char[0];
    private byte[] EMPTY_BYTE_ARRAY = new byte[0];
    static ThreadLocalMap threadLocal = new ThreadLocalMap();

    public static ContextLocalBuffer get() {
        if (!isThreadLocal) {
            return new ContextLocalBuffer();
        }
        Reference<ContextLocalBuffer> re = threadLocal.get();
        ContextLocalBuffer ctxBuffer = re.get();
        if (ctxBuffer == null) {
            Reference<ContextLocalBuffer> one = ContextLocalBuffer.createOne();
            ctxBuffer = one.get();
            if (ctxBuffer == null) {
                return new ContextLocalBuffer();
            }
            threadLocal.set(one);
        }
        return ctxBuffer;
    }

    public static void clear() {
        threadLocal.clear();
    }

    public char[] getCharBuffer() {
        return this.charBuffer;
    }

    public byte[] getByteBuffer() {
        return this.byteBuffer;
    }

    public char[] getCharBuffer(int expected) {
        if (this.charBuffer.length >= expected) {
            return this.charBuffer;
        }
        if (expected >= MAX_SIZE) {
            return this.EMPTY_CHAR_ARRAY;
        }
        this.charBuffer = new char[(int)((double)expected * 1.2)];
        return this.charBuffer;
    }

    public byte[] getByteBuffer(int expected) {
        if (this.byteBuffer.length >= expected) {
            return this.byteBuffer;
        }
        if (expected < MAX_SIZE) {
            this.byteBuffer = new byte[(int)((double)expected * 1.2)];
            return this.byteBuffer;
        }
        return this.EMPTY_BYTE_ARRAY;
    }

    static Reference<ContextLocalBuffer> createOne() {
        if (isSoft) {
            return new SoftReference<ContextLocalBuffer>(new ContextLocalBuffer());
        }
        return new WeakReference<ContextLocalBuffer>(new ContextLocalBuffer());
    }

    static class ThreadLocalMap {
        public ConcurrentMap<Thread, Reference<ContextLocalBuffer>> map = new ConcurrentHashMap<Thread, Reference<ContextLocalBuffer>>();

        ThreadLocalMap() {
        }

        public Reference<ContextLocalBuffer> get() {
            Thread thread = Thread.currentThread();
            Reference<ContextLocalBuffer> soft = (Reference<ContextLocalBuffer>)this.map.get(thread);
            if (soft == null) {
                soft = ContextLocalBuffer.createOne();
                this.map.put(thread, soft);
            }
            return soft;
        }

        public void set(Reference<ContextLocalBuffer> o) {
            Thread thread = Thread.currentThread();
            this.map.put(thread, o);
        }

        public void clear() {
            this.map.clear();
        }
    }
}

