/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.codec;

import com.jeesite.common.codec.DigestUtils;
import com.jeesite.common.codec.EncodeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class Md5Utils {
    private static final String MD5 = "MD5";
    private static final String DEFAULT_ENCODING = "UTF-8";

    public static String md5(String input) {
        return Md5Utils.md5(input, 1);
    }

    public static String md5(String input, int iterations) {
        try {
            return EncodeUtils.encodeHex(DigestUtils.digest(input.getBytes(DEFAULT_ENCODING), MD5, null, iterations));
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static byte[] md5(byte[] input) {
        return Md5Utils.md5(input, 1);
    }

    public static byte[] md5(byte[] input, int iterations) {
        return DigestUtils.digest(input, MD5, null, iterations);
    }

    public static byte[] md5(InputStream input) throws IOException {
        return DigestUtils.digest(input, MD5);
    }
}

