/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.image;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.patchca.background.BackgroundFactory;
import org.patchca.color.ColorFactory;
import org.patchca.filter.FilterFactory;
import org.patchca.filter.predefined.CurvesRippleFilterFactory;
import org.patchca.filter.predefined.DiffuseRippleFilterFactory;
import org.patchca.filter.predefined.DoubleRippleFilterFactory;
import org.patchca.filter.predefined.MarbleRippleFilterFactory;
import org.patchca.filter.predefined.WobbleRippleFilterFactory;
import org.patchca.font.FontFactory;
import org.patchca.font.RandomFontFactory;
import org.patchca.service.CaptchaService;
import org.patchca.service.ConfigurableCaptchaService;
import org.patchca.text.renderer.BestFitTextRenderer;
import org.patchca.text.renderer.TextRenderer;
import org.patchca.utils.encoder.EncoderHelper;
import org.patchca.word.RandomWordFactory;
import org.patchca.word.WordFactory;

public class CaptchaUtils {
    private static Random random = new Random();
    private static ConfigurableCaptchaService ccs;
    private static WobbleRippleFilterFactory wrff;
    private static DoubleRippleFilterFactory doff;
    private static CurvesRippleFilterFactory crff;
    private static DiffuseRippleFilterFactory drff;
    private static MarbleRippleFilterFactory mrff;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initialize() {
        if (ccs != null) return;
        Class<CaptchaUtils> clazz = CaptchaUtils.class;
        synchronized (CaptchaUtils.class) {
            if (ccs != null) return;
            ccs = new ConfigurableCaptchaService();
            ccs.setWidth(100);
            ccs.setHeight(28);
            RandomWordFactory wf = new RandomWordFactory();
            wf.setCharacters("ABDEFGHKMNRSWX2345689");
            wf.setMinLength(4);
            wf.setMaxLength(4);
            ccs.setWordFactory((WordFactory)wf);
            RandomFontFactory ff = new RandomFontFactory();
            ff.setMinSize(28);
            ff.setMaxSize(28);
            ccs.setFontFactory((FontFactory)ff);
            BestFitTextRenderer tr = new BestFitTextRenderer();
            tr.setTopMargin(3);
            tr.setRightMargin(3);
            tr.setBottomMargin(3);
            tr.setLeftMargin(3);
            ccs.setTextRenderer((TextRenderer)tr);
            ccs.setColorFactory(new ColorFactory(){

                public Color getColor(int x) {
                    int r = random.nextInt(90);
                    int g = random.nextInt(90);
                    int b = random.nextInt(90);
                    return new Color(r, g, b);
                }
            });
            ccs.setBackgroundFactory(new BackgroundFactory(){

                public void fillBackground(BufferedImage image) {
                    Graphics graphics = image.getGraphics();
                    int imgWidth = image.getWidth();
                    int imgHeight = image.getHeight();
                    graphics.setColor(Color.WHITE);
                    graphics.fillRect(0, 0, imgWidth, imgHeight);
                    for (int i = 0; i < 50; ++i) {
                        int rInt = random.nextInt(100) + 50;
                        int gInt = random.nextInt(100) + 50;
                        int bInt = random.nextInt(100) + 50;
                        graphics.setColor(new Color(rInt, gInt, bInt));
                        int xInt = random.nextInt(imgWidth - 3);
                        int yInt = random.nextInt(imgHeight - 2);
                        int sAngleInt = random.nextInt(360);
                        int eAngleInt = random.nextInt(360);
                        int wInt = random.nextInt(6);
                        int hInt = random.nextInt(6);
                        graphics.fillArc(xInt, yInt, wInt, hInt, sAngleInt, eAngleInt);
                        if (i % 10 != 0) continue;
                        int xInt2 = random.nextInt(imgWidth);
                        int yInt2 = random.nextInt(imgHeight);
                        graphics.drawLine(xInt, yInt, xInt2, yInt2);
                    }
                }
            });
            wrff = new WobbleRippleFilterFactory();
            doff = new DoubleRippleFilterFactory();
            crff = new CurvesRippleFilterFactory(ccs.getColorFactory());
            drff = new DiffuseRippleFilterFactory();
            mrff = new MarbleRippleFilterFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static String generateCaptcha(OutputStream outputStream) throws IOException {
        CaptchaUtils.initialize();
        switch (random.nextInt(3)) {
            case 0: {
                ccs.setFilterFactory((FilterFactory)wrff);
                break;
            }
            case 1: {
                ccs.setFilterFactory((FilterFactory)doff);
                break;
            }
            case 2: {
                ccs.setFilterFactory((FilterFactory)crff);
                break;
            }
            case 3: {
                ccs.setFilterFactory((FilterFactory)drff);
                break;
            }
            case 4: {
                ccs.setFilterFactory((FilterFactory)mrff);
            }
        }
        String s = EncoderHelper.getChallangeAndWriteImage((CaptchaService)ccs, (String)"png", (OutputStream)outputStream);
        return s;
    }
}

