/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.io;

import com.jeesite.common.collect.SetUtils;
import com.jeesite.common.io.FileUtils;
import com.jeesite.common.io.ResourceUtils;
import com.jeesite.common.lang.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class PropertiesUtils {
    public static final String[] DEFAULT_CONFIG_FILE = new String[]{"classpath:config/jeesite.yml", "classpath:config/application.yml", "classpath:application.yml"};
    private static Logger logger = PropertiesUtils.initLogger();
    private final Properties properties = new Properties();
    private static Pattern p1 = Pattern.compile("\\$\\{.*?\\}");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesUtils(String ... configFiles) {
        for (String location : configFiles) {
            try {
                Resource resource = ResourceUtils.getResource(location);
                if (!resource.exists()) continue;
                String ext = FileUtils.getFileExtension(location);
                if ("properties".equals(ext)) {
                    InputStreamReader is = null;
                    try {
                        is = new InputStreamReader(resource.getInputStream(), "UTF-8");
                        this.properties.load(is);
                    }
                    catch (IOException ex) {
                        try {
                            logger.error("Load " + location + " failure. ", (Throwable)ex);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(is);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((Reader)is);
                        continue;
                    }
                    IOUtils.closeQuietly((Reader)is);
                    continue;
                }
                if (!"yml".equals(ext)) continue;
                YamlPropertiesFactoryBean bean = new YamlPropertiesFactoryBean();
                bean.setResources(new Resource[]{resource});
                for (Map.Entry<Object, Object> entry : bean.getObject().entrySet()) {
                    this.properties.put(ObjectUtils.toString(entry.getKey()), ObjectUtils.toString(entry.getValue()));
                }
            }
            catch (Exception e) {
                logger.error("Load " + location + " failure. ", (Throwable)e);
            }
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static PropertiesUtils getInstance() {
        return PropertiesLoaderHolder.INSTANCE;
    }

    public static void releadInstance() {
        PropertiesLoaderHolder.releadInstance();
    }

    public String getProperty(String key) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            Matcher m = p1.matcher(value);
            while (m.find()) {
                String g = m.group();
                String keyChild = g.replaceAll("\\$\\{", "").replaceAll("\\}", "");
                value = value.replace(g, this.getProperty(keyChild));
            }
            return value;
        }
        String systemProperty = System.getProperty(key);
        if (systemProperty != null) {
            return systemProperty;
        }
        return null;
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        return value != null ? value : defaultValue;
    }

    private static Logger initLogger() {
        String logPath = null;
        try {
            logPath = new DefaultResourceLoader().getResource("/").getFile().getPath();
        }
        catch (Exception e) {
            logPath = System.getProperty("user.dir");
        }
        String classesLogPath = FileUtils.path(logPath + "/WEB-INF/classes");
        if (new File(classesLogPath).exists()) {
            logPath = classesLogPath;
        }
        System.setProperty("logPath", FileUtils.path(logPath));
        return LoggerFactory.getLogger(PropertiesUtils.class);
    }

    private static final class PropertiesLoaderHolder {
        private static PropertiesUtils INSTANCE;

        private PropertiesLoaderHolder() {
        }

        /*
         * WARNING - void declaration
         */
        public static void releadInstance() {
            Resource[] resources;
            LinkedHashSet<Object> configFiles = SetUtils.newLinkedHashSet();
            for (Resource resource : resources = ResourceUtils.getResources("classpath*:/config/jeesite-*.*")) {
                configFiles.add("classpath:/config/" + resource.getFilename());
            }
            for (String string : DEFAULT_CONFIG_FILE) {
                configFiles.add(string);
            }
            String string = System.getProperty("spring.config.location");
            if (com.jeesite.common.lang.StringUtils.isNotBlank((CharSequence)string)) {
                void var2_7;
                String string2;
                if (!string.contains("$") && !ResourceUtils.isUrl((String)(string2 = StringUtils.cleanPath((String)string)))) {
                    String string3 = "file:" + string2;
                }
                configFiles.add(var2_7);
            }
            logger.debug("Loading jeesite config: {}", configFiles);
            INSTANCE = new PropertiesUtils(configFiles.toArray(new String[configFiles.size()]));
        }

        static {
            PropertiesLoaderHolder.releadInstance();
        }
    }
}

