/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.lang;

import java.lang.management.ManagementFactory;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM/dd HH", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM.dd HH", "yyyy.MM", "yyyy\u5e74MM\u6708dd\u65e5", "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2", "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206", "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6", "yyyy\u5e74MM\u6708", "yyyy"};

    public static String formatDate(Date date) {
        return DateUtils.formatDate(date, "yyyy-MM-dd");
    }

    public static String formatDate(long dateTime, String pattern) {
        return DateUtils.formatDate(new Date(dateTime), pattern);
    }

    public static String formatDate(Date date, String pattern) {
        String formatDate = null;
        if (date != null) {
            if (StringUtils.isBlank((CharSequence)pattern)) {
                pattern = "yyyy-MM-dd";
            }
            formatDate = FastDateFormat.getInstance((String)pattern).format(date);
        }
        return formatDate;
    }

    public static String formatDateTime(Date date) {
        return DateUtils.formatDate(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getDate() {
        return DateUtils.getDate("yyyy-MM-dd");
    }

    public static String getDate(String pattern) {
        return FastDateFormat.getInstance((String)pattern).format(new Date());
    }

    public static String getDate(String pattern, int amont, int type) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(type, amont);
        return FastDateFormat.getInstance((String)pattern).format(calendar.getTime());
    }

    public static String getTime() {
        return DateUtils.formatDate(new Date(), "HH:mm:ss");
    }

    public static String getDateTime() {
        return DateUtils.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss");
    }

    public static String getYear() {
        return DateUtils.formatDate(new Date(), "yyyy");
    }

    public static String getMonth() {
        return DateUtils.formatDate(new Date(), "MM");
    }

    public static String getDay() {
        return DateUtils.formatDate(new Date(), "dd");
    }

    public static String getWeek() {
        return DateUtils.formatDate(new Date(), "E");
    }

    public static Date parseDate(Object str) {
        if (str == null) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str.toString(), (String[])parsePatterns);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static long pastDays(Date date) {
        long t = System.currentTimeMillis() - date.getTime();
        return t / 86400000L;
    }

    public static long pastHour(Date date) {
        long t = System.currentTimeMillis() - date.getTime();
        return t / 3600000L;
    }

    public static long pastMinutes(Date date) {
        long t = System.currentTimeMillis() - date.getTime();
        return t / 60000L;
    }

    public static double getDistanceOfTwoDate(Date before, Date after) {
        long beforeTime = before.getTime();
        long afterTime = after.getTime();
        return (afterTime - beforeTime) / 86400000L;
    }

    public static int getMonthHasDays(Date date) {
        int y;
        String yyyyMM = FastDateFormat.getInstance((String)"yyyyMM").format(date);
        String year = yyyyMM.substring(0, 4);
        String month = yyyyMM.substring(4, 6);
        String day31 = ",01,03,05,07,08,10,12,";
        String day30 = "04,06,09,11";
        int day = 0;
        day = day31.contains(month) ? 31 : (day30.contains(month) ? 30 : ((y = Integer.parseInt(year)) % 4 == 0 && y % 100 != 0 || y % 400 == 0 ? 29 : 28));
        return day;
    }

    public static int getWeekOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(3);
    }

    public static Date getOfDayFirst(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getOfDayLast(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getServerStartDate() {
        long time = ManagementFactory.getRuntimeMXBean().getStartTime();
        return new Date(time);
    }

    public static String formatDateBetweenString(Date beginDate, Date endDate) {
        String begin = DateUtils.formatDate(beginDate);
        String end = DateUtils.formatDate(endDate);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{begin, end})) {
            return begin + " ~ " + end;
        }
        return null;
    }

    public static Date[] parseDateBetweenString(String dateString) {
        String end;
        String begin;
        String[] ss;
        Date beginDate = null;
        Date endDate = null;
        if (StringUtils.isNotBlank((CharSequence)dateString) && (ss = StringUtils.split((String)dateString, (String)"~")) != null && ss.length == 2 && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{begin = StringUtils.trim((String)ss[0]), end = StringUtils.trim((String)ss[1])})) {
            beginDate = DateUtils.parseDate(begin);
            endDate = DateUtils.parseDate(end);
        }
        return new Date[]{beginDate, endDate};
    }
}

