/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.mail;

import com.jeesite.common.io.PropertiesUtils;
import org.apache.commons.mail.HtmlEmail;

public class EmailUtils {
    public static boolean sendEmail(String toAddress, String subject, String content) {
        PropertiesUtils loader = PropertiesUtils.getInstance();
        String fromAddress = loader.getProperty("msg.email.fromAddress");
        String fromPassword = loader.getProperty("msg.email.fromPassword");
        String fromHostName = loader.getProperty("msg.email.fromHostName");
        String sslOnConnect = loader.getProperty("msg.email.sslOnConnect", "false");
        String sslSmtpPort = loader.getProperty("msg.email.sslSmtpPort");
        return EmailUtils.sendEmail(fromAddress, fromPassword, fromHostName, sslOnConnect, sslSmtpPort, toAddress, subject, content);
    }

    public static boolean sendEmail(String fromAddress, String fromPassword, String fromHostName, String sslOnConnect, String sslSmtpPort, String toAddress, String subject, String content) {
        try {
            HtmlEmail htmlEmail = new HtmlEmail();
            htmlEmail.setFrom(fromAddress);
            htmlEmail.setAuthentication(fromAddress, fromPassword);
            htmlEmail.setHostName(fromHostName);
            if ("true".equals(sslOnConnect)) {
                htmlEmail.setSSLOnConnect(true);
                htmlEmail.setSslSmtpPort(sslSmtpPort);
            }
            htmlEmail.addTo(toAddress);
            htmlEmail.setSubject(subject);
            htmlEmail.setMsg(content);
            htmlEmail.setCharset("utf-8");
            htmlEmail.send();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

