/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.mapper;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.util.JSONPObject;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import com.jeesite.common.collect.ListUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(JsonMapper.class);

    public JsonMapper() {
        this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        this.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        this.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        this.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.getSerializerProvider().setNullValueSerializer((JsonSerializer)new JsonSerializer<Object>(){

            public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                jgen.writeString("");
            }
        });
    }

    public String toJsonString(Object object) {
        try {
            return this.writeValueAsString(object);
        }
        catch (IOException e) {
            logger.warn("write to json string error:" + object, (Throwable)e);
            return null;
        }
    }

    public String toJsonpString(String functionName, Object object) {
        return this.toJsonString(new JSONPObject(functionName, object));
    }

    public <T> T fromJsonString(String jsonString, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)jsonString) || "<CLOB>".equals(jsonString)) {
            return null;
        }
        try {
            return (T)this.readValue(jsonString, clazz);
        }
        catch (IOException e) {
            logger.warn("parse json string error:" + jsonString, (Throwable)e);
            return null;
        }
    }

    public <T> T fromJsonString(String jsonString, JavaType javaType) {
        if (StringUtils.isEmpty((CharSequence)jsonString) || "<CLOB>".equals(jsonString)) {
            return null;
        }
        try {
            return (T)this.readValue(jsonString, javaType);
        }
        catch (IOException e) {
            logger.warn("parse json string error:" + jsonString, (Throwable)e);
            return null;
        }
    }

    public JavaType createCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return this.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public <T> T update(String jsonString, T object) {
        try {
            return (T)this.readerForUpdating(object).readValue(jsonString);
        }
        catch (JsonProcessingException e) {
            logger.warn("update json string:" + jsonString + " to object:" + object + " error.", (Throwable)e);
        }
        catch (IOException e) {
            logger.warn("update json string:" + jsonString + " to object:" + object + " error.", (Throwable)e);
        }
        return null;
    }

    public JsonMapper enableEnumUseToString() {
        this.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        return this;
    }

    public JsonMapper enableJaxbAnnotation() {
        JaxbAnnotationModule module = new JaxbAnnotationModule();
        this.registerModule((Module)module);
        return this;
    }

    public ObjectMapper getMapper() {
        return this;
    }

    public static JsonMapper getInstance() {
        return JsonMapperHolder.INSTANCE;
    }

    public static String toJson(Object object) {
        return JsonMapper.getInstance().toJsonString(object);
    }

    public static String toJsonp(String functionName, Object object) {
        return JsonMapper.getInstance().toJsonpString(functionName, object);
    }

    public static <T> T fromJson(String jsonString, Class<?> clazz) {
        return (T)JsonMapper.getInstance().fromJsonString(jsonString, clazz);
    }

    public static List<Map<String, Object>> fromJsonForMapList(String jsonString) {
        List list;
        List<Map<String, Object>> result = ListUtils.newArrayList();
        if (StringUtils.startsWith((CharSequence)jsonString, (CharSequence)"{")) {
            Map map = (Map)JsonMapper.fromJson(jsonString, Map.class);
            if (map != null) {
                result.add(map);
            }
        } else if (StringUtils.startsWith((CharSequence)jsonString, (CharSequence)"[") && (list = (List)JsonMapper.fromJson(jsonString, List.class)) != null) {
            result = list;
        }
        return result;
    }

    private static final class JsonMapperHolder {
        private static final JsonMapper INSTANCE = new JsonMapper();

        private JsonMapperHolder() {
        }
    }
}

