/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.network;

import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import javax.servlet.http.HttpServletRequest;

public class IpUtils {
    public static String getRemoteAddr(HttpServletRequest request) {
        if (request == null) {
            return "unknown";
        }
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return StringUtils.split((String)ObjectUtils.toString(ip), (String)",")[0];
    }

    public static boolean isLocalAddr(String ip) {
        return StringUtils.inString(ip, "127.0.0.1", "0:0:0:0:0:0:0:1");
    }

    public static boolean isInternalAddr(String ip) {
        if (IpUtils.isLocalAddr(ip)) {
            return true;
        }
        byte[] addr = IpUtils.textToNumericFormatV4(ip);
        byte b0 = addr[0];
        byte b1 = addr[1];
        int SECTION_1 = 10;
        int SECTION_2 = -84;
        int SECTION_3 = 16;
        int SECTION_4 = 31;
        int SECTION_5 = -64;
        int SECTION_6 = -88;
        switch (b0) {
            case 10: {
                return true;
            }
            case -84: {
                if (b1 >= 16 && b1 <= 31) {
                    return true;
                }
            }
            case -64: {
                switch (b1) {
                    case -88: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static byte[] textToNumericFormatV4(String paramString) {
        if (paramString.length() == 0) {
            return null;
        }
        byte[] arrayOfByte = new byte[4];
        String[] arrayOfString = paramString.split("\\.", -1);
        try {
            switch (arrayOfString.length) {
                case 1: {
                    long l = Long.parseLong(arrayOfString[0]);
                    if (l < 0L || l > 0xFFFFFFFFL) {
                        return null;
                    }
                    arrayOfByte[0] = (byte)(l >> 24 & 0xFFL);
                    arrayOfByte[1] = (byte)((l & 0xFFFFFFL) >> 16 & 0xFFL);
                    arrayOfByte[2] = (byte)((l & 0xFFFFL) >> 8 & 0xFFL);
                    arrayOfByte[3] = (byte)(l & 0xFFL);
                    break;
                }
                case 2: {
                    long l = Integer.parseInt(arrayOfString[0]);
                    if (l < 0L || l > 255L) {
                        return null;
                    }
                    arrayOfByte[0] = (byte)(l & 0xFFL);
                    l = Integer.parseInt(arrayOfString[1]);
                    if (l < 0L || l > 0xFFFFFFL) {
                        return null;
                    }
                    arrayOfByte[1] = (byte)(l >> 16 & 0xFFL);
                    arrayOfByte[2] = (byte)((l & 0xFFFFL) >> 8 & 0xFFL);
                    arrayOfByte[3] = (byte)(l & 0xFFL);
                    break;
                }
                case 3: {
                    long l;
                    for (int i = 0; i < 2; ++i) {
                        l = Integer.parseInt(arrayOfString[i]);
                        if (l < 0L || l > 255L) {
                            return null;
                        }
                        arrayOfByte[i] = (byte)(l & 0xFFL);
                    }
                    l = Integer.parseInt(arrayOfString[2]);
                    if (l < 0L || l > 65535L) {
                        return null;
                    }
                    arrayOfByte[2] = (byte)(l >> 8 & 0xFFL);
                    arrayOfByte[3] = (byte)(l & 0xFFL);
                    break;
                }
                case 4: {
                    for (int i = 0; i < 4; ++i) {
                        long l = Integer.parseInt(arrayOfString[i]);
                        if (l < 0L || l > 255L) {
                            return null;
                        }
                        arrayOfByte[i] = (byte)(l & 0xFFL);
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (NumberFormatException localNumberFormatException) {
            return null;
        }
        return arrayOfByte;
    }

    public static byte[] textToNumericFormatV6(String paramString) {
        int i4;
        if (paramString.length() < 2) {
            return null;
        }
        char[] arrayOfChar = paramString.toCharArray();
        byte[] arrayOfByte1 = new byte[16];
        int m = arrayOfChar.length;
        int n = paramString.indexOf("%");
        if (n == m - 1) {
            return null;
        }
        if (n != -1) {
            m = n;
        }
        int i = -1;
        int i1 = 0;
        int i2 = 0;
        if (arrayOfChar[i1] == ':' && arrayOfChar[++i1] != ':') {
            return null;
        }
        int i3 = i1;
        boolean j = false;
        int k = 0;
        while (i1 < m) {
            char c;
            if ((i4 = Character.digit(c = arrayOfChar[i1++], 16)) != -1) {
                k <<= 4;
                if ((k |= i4) > 65535) {
                    return null;
                }
                j = true;
                continue;
            }
            if (c == ':') {
                i3 = i1;
                if (!j) {
                    if (i != -1) {
                        return null;
                    }
                    i = i2;
                    continue;
                }
                if (i1 == m) {
                    return null;
                }
                if (i2 + 2 > 16) {
                    return null;
                }
                arrayOfByte1[i2++] = (byte)(k >> 8 & 0xFF);
                arrayOfByte1[i2++] = (byte)(k & 0xFF);
                j = false;
                k = 0;
                continue;
            }
            if (c == '.' && i2 + 4 <= 16) {
                String str = paramString.substring(i3, m);
                int i5 = 0;
                int i6 = 0;
                while ((i6 = str.indexOf(46, i6)) != -1) {
                    ++i5;
                    ++i6;
                }
                if (i5 != 3) {
                    return null;
                }
                byte[] arrayOfByte3 = IpUtils.textToNumericFormatV4(str);
                if (arrayOfByte3 == null) {
                    return null;
                }
                for (int i7 = 0; i7 < 4; ++i7) {
                    arrayOfByte1[i2++] = arrayOfByte3[i7];
                }
                j = false;
                continue;
            }
            return null;
        }
        if (j) {
            if (i2 + 2 > 16) {
                return null;
            }
            arrayOfByte1[i2++] = (byte)(k >> 8 & 0xFF);
            arrayOfByte1[i2++] = (byte)(k & 0xFF);
        }
        if (i != -1) {
            i4 = i2 - i;
            if (i2 == 16) {
                return null;
            }
            for (i1 = 1; i1 <= i4; ++i1) {
                arrayOfByte1[16 - i1] = arrayOfByte1[i + i4 - i1];
                arrayOfByte1[i + i4 - i1] = 0;
            }
            i2 = 16;
        }
        if (i2 != 16) {
            return null;
        }
        byte[] arrayOfByte2 = IpUtils.convertFromIPv4MappedAddress(arrayOfByte1);
        if (arrayOfByte2 != null) {
            return arrayOfByte2;
        }
        return arrayOfByte1;
    }

    public static boolean isIPv4LiteralAddress(String paramString) {
        return IpUtils.textToNumericFormatV4(paramString) != null;
    }

    public static boolean isIPv6LiteralAddress(String paramString) {
        return IpUtils.textToNumericFormatV6(paramString) != null;
    }

    public static byte[] convertFromIPv4MappedAddress(byte[] paramArrayOfByte) {
        if (IpUtils.isIPv4MappedAddress(paramArrayOfByte)) {
            byte[] arrayOfByte = new byte[4];
            System.arraycopy(paramArrayOfByte, 12, arrayOfByte, 0, 4);
            return arrayOfByte;
        }
        return null;
    }

    private static boolean isIPv4MappedAddress(byte[] paramArrayOfByte) {
        if (paramArrayOfByte.length < 16) {
            return false;
        }
        return paramArrayOfByte[0] == 0 && paramArrayOfByte[1] == 0 && paramArrayOfByte[2] == 0 && paramArrayOfByte[3] == 0 && paramArrayOfByte[4] == 0 && paramArrayOfByte[5] == 0 && paramArrayOfByte[6] == 0 && paramArrayOfByte[7] == 0 && paramArrayOfByte[8] == 0 && paramArrayOfByte[9] == 0 && paramArrayOfByte[10] == -1 && paramArrayOfByte[11] == -1;
    }
}

