/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.utils.excel;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jeesite.common.codec.EncodeUtils;
import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.reflect.ReflectUtils;
import com.jeesite.common.utils.excel.ExcelException;
import com.jeesite.common.utils.excel.annotation.ExcelField;
import com.jeesite.common.utils.excel.annotation.ExcelFields;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExport {
    private static Logger log = LoggerFactory.getLogger(ExcelExport.class);
    private Workbook wb;
    private Sheet sheet;
    private Map<String, CellStyle> styles;
    private int rownum;
    List<Object[]> annotationList;

    public ExcelExport(String title, Class<?> cls) {
        this(title, cls, ExcelField.Type.EXPORT, new String[0]);
    }

    public ExcelExport(String title, Class<?> cls, ExcelField.Type type, String ... groups) {
        this(null, null, title, cls, type, groups);
    }

    public ExcelExport(String sheetName, String title, Class<?> cls, ExcelField.Type type, String ... groups) {
        this(null, sheetName, title, cls, type, groups);
    }

    public ExcelExport(Workbook wb, String sheetName, String title, Class<?> cls, ExcelField.Type type, String ... groups) {
        this.wb = wb != null ? wb : this.createWorkbook();
        this.createSheet(sheetName, title, cls, type, groups);
    }

    public ExcelExport(String title, List<String> headerList, List<Integer> headerWidthList) {
        this(null, null, title, headerList, headerWidthList);
    }

    public ExcelExport(String sheetName, String title, List<String> headerList, List<Integer> headerWidthList) {
        this(null, sheetName, title, headerList, headerWidthList);
    }

    public ExcelExport(Workbook wb, String sheetName, String title, List<String> headerList, List<Integer> headerWidthList) {
        this.wb = wb != null ? wb : this.createWorkbook();
        this.createSheet(sheetName, title, headerList, headerWidthList);
    }

    public Workbook createWorkbook() {
        return new SXSSFWorkbook(500);
    }

    public Workbook getWorkbook() {
        return this.wb;
    }

    public void createSheet(String sheetName, String title, Class<?> cls, ExcelField.Type type, String ... groups) {
        Method[] ms;
        ExcelField ef;
        Field[] fs;
        this.annotationList = ListUtils.newArrayList();
        for (Field f : fs = cls.getDeclaredFields()) {
            ExcelFields efs = f.getAnnotation(ExcelFields.class);
            if (efs != null && efs.value() != null) {
                for (ExcelField ef2 : efs.value()) {
                    this.addAnnotation(this.annotationList, ef2, f, type, groups);
                }
            }
            ef = f.getAnnotation(ExcelField.class);
            this.addAnnotation(this.annotationList, ef, f, type, groups);
        }
        for (Method m : ms = cls.getDeclaredMethods()) {
            ExcelFields efs = m.getAnnotation(ExcelFields.class);
            if (efs != null && efs.value() != null) {
                for (ExcelField ef3 : efs.value()) {
                    this.addAnnotation(this.annotationList, ef3, m, type, groups);
                }
            }
            ExcelField ef4 = m.getAnnotation(ExcelField.class);
            this.addAnnotation(this.annotationList, ef4, m, type, groups);
        }
        Collections.sort(this.annotationList, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                return new Integer(((ExcelField)o1[0]).sort()).compareTo(new Integer(((ExcelField)o2[0]).sort()));
            }
        });
        ArrayList<String> headerList = ListUtils.newArrayList();
        ArrayList<Integer> headerWidthList = ListUtils.newArrayList();
        for (Object[] os : this.annotationList) {
            String[] ss;
            ef = (ExcelField)os[0];
            String headerTitle = ef.title();
            if (type == ExcelField.Type.EXPORT && (ss = StringUtils.split((String)headerTitle, (String)"**", (int)2)).length == 2) {
                headerTitle = ss[0];
            }
            headerList.add(headerTitle);
            headerWidthList.add(ef.width());
        }
        this.createSheet(sheetName, title, headerList, headerWidthList);
    }

    private void addAnnotation(List<Object[]> annotationList, ExcelField ef, Object fOrM, ExcelField.Type type, String ... groups) {
        if (ef != null && (ef.type() == ExcelField.Type.ALL || ef.type() == type)) {
            if (groups != null && groups.length > 0) {
                boolean inGroup = false;
                block0: for (String g : groups) {
                    if (!inGroup) {
                        for (String efg : ef.groups()) {
                            if (!StringUtils.equals((CharSequence)g, (CharSequence)efg)) continue;
                            inGroup = true;
                            annotationList.add(new Object[]{ef, fOrM});
                            continue block0;
                        }
                        continue;
                    }
                    break;
                }
            } else {
                annotationList.add(new Object[]{ef, fOrM});
            }
        }
    }

    public void createSheet(String sheetName, String title, List<String> headerList, List<Integer> headerWidthList) {
        this.sheet = this.wb.createSheet(StringUtils.defaultString((String)sheetName, (String)StringUtils.defaultString((String)title, (String)"Sheet1")));
        this.styles = this.createStyles(this.wb);
        this.rownum = 0;
        if (StringUtils.isNotBlank((CharSequence)title)) {
            Row titleRow = this.sheet.createRow(this.rownum++);
            titleRow.setHeightInPoints(30.0f);
            Cell titleCell = titleRow.createCell(0);
            titleCell.setCellStyle(this.styles.get("title"));
            titleCell.setCellValue(title);
            this.sheet.addMergedRegion(new CellRangeAddress(titleRow.getRowNum(), titleRow.getRowNum(), titleRow.getRowNum(), headerList.size() - 1));
        }
        if (headerList == null) {
            throw new ExcelException("headerList not null!");
        }
        Row headerRow = this.sheet.createRow(this.rownum++);
        headerRow.setHeightInPoints(16.0f);
        for (int i = 0; i < headerList.size(); ++i) {
            Cell cell = headerRow.createCell(i);
            cell.setCellStyle(this.styles.get("header"));
            String[] ss = StringUtils.split((String)headerList.get(i), (String)"**", (int)2);
            if (ss.length == 2) {
                cell.setCellValue(ss[0]);
                Comment comment = this.sheet.createDrawingPatriarch().createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, 3, 3, 5, 6));
                comment.setRow(cell.getRowIndex());
                comment.setColumn(cell.getColumnIndex());
                comment.setString((RichTextString)new XSSFRichTextString(ss[1]));
                cell.setCellComment(comment);
                continue;
            }
            cell.setCellValue(headerList.get(i));
        }
        boolean isDefWidth = headerWidthList != null && headerWidthList.size() == headerList.size();
        for (int i = 0; i < headerList.size(); ++i) {
            int colWidth = -1;
            if (isDefWidth) {
                colWidth = headerWidthList.get(i);
            }
            if (colWidth == -1) {
                colWidth = this.sheet.getColumnWidth(i) * 2;
                int n = colWidth = colWidth < 3000 ? 3000 : colWidth;
            }
            if (colWidth == 0) {
                this.sheet.setColumnHidden(i, true);
                continue;
            }
            this.sheet.setColumnWidth(i, colWidth);
        }
        log.debug("Create sheet {} success.", (Object)sheetName);
    }

    private Map<String, CellStyle> createStyles(Workbook wb) {
        HashMap<String, CellStyle> styles = new HashMap<String, CellStyle>();
        CellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        Font titleFont = wb.createFont();
        titleFont.setFontName("Arial");
        titleFont.setFontHeightInPoints((short)16);
        titleFont.setBoldweight((short)700);
        style.setFont(titleFont);
        styles.put("title", style);
        style = wb.createCellStyle();
        style.setVerticalAlignment((short)1);
        style.setBorderRight((short)1);
        style.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderLeft((short)1);
        style.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderTop((short)1);
        style.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderBottom((short)1);
        style.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        Font dataFont = wb.createFont();
        dataFont.setFontName("Arial");
        dataFont.setFontHeightInPoints((short)10);
        style.setFont(dataFont);
        styles.put("data", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment((short)1);
        styles.put("data1", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment((short)2);
        styles.put("data2", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment((short)3);
        styles.put("data3", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment((short)2);
        style.setFillForegroundColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setFillPattern((short)1);
        Font headerFont = wb.createFont();
        headerFont.setFontName("Arial");
        headerFont.setFontHeightInPoints((short)10);
        headerFont.setBoldweight((short)700);
        headerFont.setColor(IndexedColors.WHITE.getIndex());
        style.setFont(headerFont);
        styles.put("header", style);
        return styles;
    }

    public Row addRow() {
        return this.sheet.createRow(this.rownum++);
    }

    public Cell addCell(Row row, int column, Object val) {
        return this.addCell(row, column, val, ExcelField.Align.AUTO, Class.class, null);
    }

    public Cell addCell(Row row, int column, Object val, ExcelField.Align align, Class<?> fieldType, String dataFormat) {
        Cell cell = row.createCell(column);
        String defaultDataFormat = "@";
        try {
            if (val == null) {
                cell.setCellValue("");
            } else if (fieldType != Class.class) {
                cell.setCellValue((String)fieldType.getMethod("setValue", Object.class).invoke(null, val));
                try {
                    defaultDataFormat = (String)fieldType.getMethod("getDataFormat", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Exception ex) {
                    defaultDataFormat = "@";
                }
            } else if (val instanceof String) {
                cell.setCellValue((String)val);
            } else if (val instanceof Integer) {
                cell.setCellValue((double)((Integer)val).intValue());
                defaultDataFormat = "0";
            } else if (val instanceof Long) {
                cell.setCellValue((double)((Long)val).longValue());
                defaultDataFormat = "0";
            } else if (val instanceof Double) {
                cell.setCellValue(((Double)val).doubleValue());
                defaultDataFormat = "0.00";
            } else if (val instanceof Float) {
                cell.setCellValue((double)((Float)val).floatValue());
                defaultDataFormat = "0.00";
            } else if (val instanceof Date) {
                cell.setCellValue((Date)val);
                defaultDataFormat = "yyyy-MM-dd HH:mm";
            } else {
                cell.setCellValue((String)Class.forName(this.getClass().getName().replaceAll(this.getClass().getSimpleName(), "fieldtype." + val.getClass().getSimpleName() + "Type")).getMethod("setValue", Object.class).invoke(null, val));
            }
            CellStyle style = this.styles.get("data_column_" + column);
            if (style == null) {
                style = this.wb.createCellStyle();
                style.cloneStyleFrom(this.styles.get("data" + (align.value() >= 1 && align.value() <= 3 ? Integer.valueOf(align.value()) : "")));
                if (dataFormat != null) {
                    defaultDataFormat = dataFormat;
                }
                style.setDataFormat(this.wb.createDataFormat().getFormat(defaultDataFormat));
                this.styles.put("data_column_" + column, style);
            }
            cell.setCellStyle(style);
        }
        catch (Exception ex) {
            log.info("Set cell value [" + row.getRowNum() + "," + column + "] error: " + ex.toString());
            cell.setCellValue(ObjectUtils.toString(val));
        }
        return cell;
    }

    public <E> ExcelExport setDataList(List<E> list) {
        for (E e : list) {
            int colunm = 0;
            Row row = this.addRow();
            StringBuilder sb = new StringBuilder();
            for (Object[] os : this.annotationList) {
                ExcelField ef = (ExcelField)os[0];
                Object val = null;
                try {
                    if (StringUtils.isNotBlank((CharSequence)ef.attrName())) {
                        val = ReflectUtils.invokeGetter(e, ef.attrName());
                    } else if (os[1] instanceof Field) {
                        val = ReflectUtils.invokeGetter(e, ((Field)os[1]).getName());
                    } else if (os[1] instanceof Method) {
                        val = ReflectUtils.invokeMethod(e, ((Method)os[1]).getName(), new Class[0], new Object[0]);
                    }
                    if (StringUtils.isNotBlank((CharSequence)ef.dictType())) {
                        Class<?> dictUtils = Class.forName("com.jeesite.modules.sys.utils.DictUtils");
                        val = dictUtils.getMethod("getDictLabel", String.class, String.class, String.class).invoke(null, ef.dictType(), val == null ? "" : val.toString(), "");
                    }
                }
                catch (Exception ex) {
                    log.info(ex.toString());
                    val = "";
                }
                String dataFormat = ef.dataFormat();
                try {
                    JsonFormat jf = e.getClass().getMethod("get" + StringUtils.capitalize((String)ef.attrName()), new Class[0]).getAnnotation(JsonFormat.class);
                    if (jf != null && jf.pattern() != null) {
                        dataFormat = jf.pattern();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.addCell(row, colunm++, val, ef.align(), ef.fieldType(), dataFormat);
                sb.append(val + ", ");
            }
            log.debug("Write success: [" + row.getRowNum() + "] " + sb.toString());
        }
        return this;
    }

    public ExcelExport write(OutputStream os) {
        try {
            this.wb.write(os);
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return this;
    }

    public ExcelExport write(HttpServletResponse response, String fileName) {
        response.reset();
        response.setContentType("application/octet-stream; charset=utf-8");
        response.setHeader("Content-Disposition", "attachment; filename=" + EncodeUtils.encodeUrl(fileName));
        try {
            this.write((OutputStream)response.getOutputStream());
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return this;
    }

    public ExcelExport writeFile(String name) throws FileNotFoundException, IOException {
        FileOutputStream os = new FileOutputStream(name);
        this.write(os);
        return this;
    }

    public ExcelExport dispose() {
        if (this.wb instanceof SXSSFWorkbook) {
            ((SXSSFWorkbook)this.wb).dispose();
        }
        return this;
    }
}

