/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.web.http;

import com.jeesite.common.collect.MapUtils;
import com.jeesite.common.io.PropertiesUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mapper.JsonMapper;
import com.jeesite.common.mapper.XmlMapper;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.Validate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletUtils {
    public static final String DEFAULT_PARAMS_PARAM = "params";
    public static final String DEFAULT_PARAM_PREFIX_PARAM = "param_";
    private static String[] staticFiles;
    private static String[] staticFileExcludeUri;

    public static HttpServletRequest getRequest() {
        HttpServletRequest request = null;
        try {
            request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
            if (request == null) {
                return null;
            }
            return request;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static HttpServletResponse getResponse() {
        HttpServletResponse response = null;
        try {
            response = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getResponse();
            if (response == null) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return response;
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String accept = request.getHeader("accept");
        if (accept != null && accept.indexOf("application/json") != -1) {
            return true;
        }
        String xRequestedWith = request.getHeader("X-Requested-With");
        if (xRequestedWith != null && xRequestedWith.indexOf("XMLHttpRequest") != -1) {
            return true;
        }
        String uri = request.getRequestURI();
        if (StringUtils.inStringIgnoreCase(uri, ".json", ".xml")) {
            return true;
        }
        String ajax = request.getParameter("__ajax");
        return StringUtils.inStringIgnoreCase(ajax, "json", "xml");
    }

    public static boolean isStaticFile(String uri) {
        if (staticFiles == null) {
            PropertiesUtils pl = PropertiesUtils.getInstance();
            try {
                staticFiles = StringUtils.split((String)pl.getProperty("web.staticFile"), (String)",");
                staticFileExcludeUri = StringUtils.split((String)pl.getProperty("web.staticFileExcludeUri"), (String)",");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            if (staticFiles == null) {
                try {
                    throw new Exception("\u68c0\u6d4b\u5230\u201cjeesite.yml\u201d\u4e2d\u6ca1\u6709\u914d\u7f6e\u201cweb.staticFile\u201d\u5c5e\u6027\u3002\u914d\u7f6e\u793a\u4f8b\uff1a\n#\u9759\u6001\u6587\u4ef6\u540e\u7f00\nweb.staticFile=.css,.js,.png,.jpg,.gif,.jpeg,.bmp,.ico,.swf,.psd,.htc,.crx,.xpi,.exe,.ipa,.apk");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (staticFileExcludeUri != null) {
            for (String s : staticFileExcludeUri) {
                if (!StringUtils.contains((CharSequence)uri, (CharSequence)s)) continue;
                return false;
            }
        }
        return StringUtils.endsWithAny((CharSequence)uri, (CharSequence[])staticFiles);
    }

    public static String renderResult(String result, String message) {
        return ServletUtils.renderResult(result, message, null);
    }

    public static String renderResult(String result, String message, Object data) {
        HttpServletRequest request;
        String uri;
        HashMap<String, Object> resultMap = MapUtils.newHashMap();
        resultMap.put("result", result);
        resultMap.put("message", message);
        if (data != null) {
            if (data instanceof Map) {
                resultMap.putAll((Map)data);
            } else {
                resultMap.put("data", data);
            }
        }
        if (StringUtils.endsWithIgnoreCase((CharSequence)(uri = (request = ServletUtils.getRequest()).getRequestURI()), (CharSequence)".xml")) {
            return XmlMapper.toXml(resultMap);
        }
        String functionName = request.getParameter("__callback");
        if (StringUtils.isNotBlank((CharSequence)functionName)) {
            return JsonMapper.toJsonp(functionName, resultMap);
        }
        return JsonMapper.toJson(resultMap);
    }

    public static String renderResult(HttpServletResponse response, String result, String message) {
        return ServletUtils.renderString(response, ServletUtils.renderResult(result, message), null);
    }

    public static String renderResult(HttpServletResponse response, String result, String message, Object data) {
        return ServletUtils.renderString(response, ServletUtils.renderResult(result, message, data), null);
    }

    public static String renderObject(HttpServletResponse response, Object object) {
        HttpServletRequest request = ServletUtils.getRequest();
        String uri = request.getRequestURI();
        if (StringUtils.endsWithIgnoreCase((CharSequence)uri, (CharSequence)".xml")) {
            return XmlMapper.toXml(object);
        }
        String functionName = request.getParameter("__callback");
        if (StringUtils.isNotBlank((CharSequence)functionName)) {
            return ServletUtils.renderString(response, JsonMapper.toJsonp(functionName, object));
        }
        return ServletUtils.renderString(response, JsonMapper.toJson(object));
    }

    public static String renderString(HttpServletResponse response, String string) {
        return ServletUtils.renderString(response, string, null);
    }

    public static String renderString(HttpServletResponse response, String string, String type) {
        try {
            response.setContentType(type == null ? "application/json" : type);
            response.setCharacterEncoding("utf-8");
            response.getWriter().print(string);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getParameter(String name) {
        HttpServletRequest request = ServletUtils.getRequest();
        if (request == null) {
            return null;
        }
        return request.getParameter(name);
    }

    public static Map<String, Object> getParameters() {
        return ServletUtils.getParameters((ServletRequest)ServletUtils.getRequest());
    }

    public static Map<String, Object> getParameters(ServletRequest request) {
        if (request == null) {
            return MapUtils.newHashMap();
        }
        return ServletUtils.getParametersStartingWith(request, "");
    }

    public static Map<String, Object> getParametersStartingWith(ServletRequest request, String prefix) {
        Validate.notNull((Object)request, (String)"Request must not be null", (Object[])new Object[0]);
        Enumeration paramNames = request.getParameterNames();
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        String pre = prefix;
        if (pre == null) {
            pre = "";
        }
        while (paramNames != null && paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (!"".equals(pre) && !paramName.startsWith(pre)) continue;
            String unprefixed = paramName.substring(pre.length());
            String[] values = request.getParameterValues(paramName);
            if (values == null || values.length == 0) {
                values = new String[]{};
                continue;
            }
            if (values.length > 1) {
                params.put(unprefixed, values);
                continue;
            }
            params.put(unprefixed, values[0]);
        }
        return params;
    }

    public static String encodeParameterStringWithPrefix(Map<String, Object> params, String prefix) {
        StringBuilder queryStringBuilder = new StringBuilder();
        String pre = prefix;
        if (pre == null) {
            pre = "";
        }
        Iterator<Map.Entry<String, Object>> it = params.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            queryStringBuilder.append(pre).append(entry.getKey()).append("=").append(entry.getValue());
            if (!it.hasNext()) continue;
            queryStringBuilder.append("&");
        }
        return queryStringBuilder.toString();
    }

    public static Map<String, Object> getExtParams(ServletRequest request) {
        Map paramMap = null;
        String params = StringUtils.trim((String)request.getParameter(DEFAULT_PARAMS_PARAM));
        paramMap = StringUtils.isNotBlank((CharSequence)params) && StringUtils.startsWith((CharSequence)params, (CharSequence)"{") ? (Map)JsonMapper.fromJson(params, Map.class) : ServletUtils.getParametersStartingWith((ServletRequest)ServletUtils.getRequest(), DEFAULT_PARAM_PREFIX_PARAM);
        return paramMap;
    }

    public static void setExpiresHeader(HttpServletResponse response, long expiresSeconds) {
        response.setDateHeader("Expires", System.currentTimeMillis() + expiresSeconds * 1000L);
        response.setHeader("Cache-Control", "private, max-age=" + expiresSeconds);
    }

    public static void setNoCacheHeader(HttpServletResponse response) {
        response.setDateHeader("Expires", 1L);
        response.addHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache, no-store, max-age=0");
    }

    public static void setLastModifiedHeader(HttpServletResponse response, long lastModifiedDate) {
        response.setDateHeader("Last-Modified", lastModifiedDate);
    }

    public static void setEtag(HttpServletResponse response, String etag) {
        response.setHeader("ETag", etag);
    }

    public static boolean checkIfModifiedSince(HttpServletRequest request, HttpServletResponse response, long lastModified) {
        long ifModifiedSince = request.getDateHeader("If-Modified-Since");
        if (ifModifiedSince != -1L && lastModified < ifModifiedSince + 1000L) {
            response.setStatus(304);
            return false;
        }
        return true;
    }

    public static boolean checkIfNoneMatchEtag(HttpServletRequest request, HttpServletResponse response, String etag) {
        String headerValue = request.getHeader("If-None-Match");
        if (headerValue != null) {
            boolean conditionSatisfied = false;
            if (!"*".equals(headerValue)) {
                StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
                while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                    String currentToken = commaTokenizer.nextToken();
                    if (!currentToken.trim().equals(etag)) continue;
                    conditionSatisfied = true;
                }
            } else {
                conditionSatisfied = true;
            }
            if (conditionSatisfied) {
                response.setStatus(304);
                response.setHeader("ETag", etag);
                return false;
            }
        }
        return true;
    }
}

