/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.collect;

import com.jeesite.common.callback.MethodCallback;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.reflect.ReflectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.beanutils.PropertyUtils;

public class ListUtils
extends org.apache.commons.collections.ListUtils {
    public static boolean inString(String str, List<String> strs) {
        if (str != null && strs != null) {
            for (String s : strs) {
                if (!str.equals(StringUtils.trim((String)s))) continue;
                return true;
            }
        }
        return false;
    }

    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    @SafeVarargs
    public static <E> ArrayList<E> newArrayList(E ... elements) {
        ArrayList list = new ArrayList(elements.length);
        Collections.addAll(list, elements);
        return list;
    }

    public static <E> ArrayList<E> newArrayList(Iterable<? extends E> elements) {
        return elements instanceof Collection ? new ArrayList<E>(ListUtils.cast(elements)) : ListUtils.newArrayList(elements.iterator());
    }

    public static <E> ArrayList<E> newArrayList(Iterator<? extends E> elements) {
        ArrayList<E> list = ListUtils.newArrayList();
        ListUtils.addAll(list, elements);
        return list;
    }

    public static <E> LinkedList<E> newLinkedList() {
        return new LinkedList();
    }

    public static <E> LinkedList<E> newLinkedList(Iterable<? extends E> elements) {
        LinkedList<E> list = ListUtils.newLinkedList();
        ListUtils.addAll(list, elements);
        return list;
    }

    public static <E> CopyOnWriteArrayList<E> newCopyOnWriteArrayList() {
        return new CopyOnWriteArrayList();
    }

    public static <E> CopyOnWriteArrayList<E> newCopyOnWriteArrayList(Iterable<? extends E> elements) {
        Collection<? extends E> elementsCollection = elements instanceof Collection ? ListUtils.cast(elements) : ListUtils.newArrayList(elements);
        return new CopyOnWriteArrayList<E>(elementsCollection);
    }

    private static <T> Collection<T> cast(Iterable<T> iterable) {
        return (Collection)iterable;
    }

    private static <T> boolean addAll(Collection<T> addTo, Iterator<? extends T> iterator) {
        boolean wasModified = false;
        while (iterator.hasNext()) {
            wasModified |= addTo.add(iterator.next());
        }
        return wasModified;
    }

    public static <T> boolean addAll(Collection<T> addTo, Iterable<? extends T> elementsToAdd) {
        if (elementsToAdd instanceof Collection) {
            Collection<? extends T> c = ListUtils.cast(elementsToAdd);
            return addTo.addAll(c);
        }
        return ListUtils.addAll(addTo, elementsToAdd.iterator());
    }

    public static Map extractToMap(Collection collection, String keyPropertyName, String valuePropertyName) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(collection.size());
        try {
            for (Object obj : collection) {
                map.put(PropertyUtils.getProperty(obj, (String)keyPropertyName), PropertyUtils.getProperty(obj, (String)valuePropertyName));
            }
        }
        catch (Exception e) {
            throw ReflectUtils.convertReflectionExceptionToUnchecked("", e);
        }
        return map;
    }

    public static <T> List<T> extractToList(Collection collection, String propertyName) {
        if (collection == null) {
            return ListUtils.newArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>(collection.size());
        try {
            for (Object obj : collection) {
                list.add(PropertyUtils.getProperty(obj, (String)propertyName));
            }
        }
        catch (Exception e) {
            throw ReflectUtils.convertReflectionExceptionToUnchecked("", e);
        }
        return list;
    }

    public static List<String> extractToList(Collection collection, String propertyName, String prefix, boolean isNotBlank) {
        ArrayList<String> list = new ArrayList<String>(collection.size());
        try {
            for (Object obj : collection) {
                String value = (String)PropertyUtils.getProperty(obj, (String)propertyName);
                if (!StringUtils.isBlank((CharSequence)prefix) && !StringUtils.startsWith((CharSequence)value, (CharSequence)prefix)) continue;
                if (isNotBlank) {
                    if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                    list.add(value);
                    continue;
                }
                list.add(value);
            }
        }
        catch (Exception e) {
            throw ReflectUtils.convertReflectionExceptionToUnchecked("", e);
        }
        return list;
    }

    public static String extractToString(Collection collection, String propertyName, String separator) {
        List list = ListUtils.extractToList(collection, propertyName);
        return StringUtils.join(list, (String)separator);
    }

    public static String convertToString(Collection collection, String separator) {
        return StringUtils.join((Iterable)collection, (String)separator);
    }

    public static String convertToString(Collection collection, String prefix, String postfix) {
        StringBuilder builder = new StringBuilder();
        for (Object o : collection) {
            builder.append(prefix).append(o).append(postfix);
        }
        return builder.toString();
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection collection) {
        return !ListUtils.isEmpty(collection);
    }

    public static <T> T getFirst(Collection<T> collection) {
        if (ListUtils.isEmpty(collection)) {
            return null;
        }
        return collection.iterator().next();
    }

    public static <T> T getLast(Collection<T> collection) {
        T current;
        if (ListUtils.isEmpty(collection)) {
            return null;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return (T)list.get(list.size() - 1);
        }
        Iterator<T> iterator = collection.iterator();
        do {
            current = iterator.next();
        } while (iterator.hasNext());
        return current;
    }

    public static <T> List<T> union(Collection<T> a, Collection<T> b) {
        ArrayList<T> result = new ArrayList<T>(a);
        result.addAll(b);
        return result;
    }

    public static <T> List<T> subtract(Collection<T> a, Collection<T> b) {
        ArrayList<T> list = new ArrayList<T>(a);
        for (T element : b) {
            list.remove(element);
        }
        return list;
    }

    public static <T> List<T> intersection(Collection<T> a, Collection<T> b) {
        ArrayList<T> list = new ArrayList<T>();
        for (T element : a) {
            if (!b.contains(element)) continue;
            list.add(element);
        }
        return list;
    }

    public static <T> void pageList(List<T> list, int pageSize, MethodCallback pageCallback) {
        if (list != null && list.size() > 0) {
            int count = list.size();
            int pageNo = 1;
            int totalPage = (count + pageSize - 1) / pageSize;
            while (true) {
                List<T> pageList;
                if ((pageList = ListUtils.getPageList(list, pageNo, pageSize, totalPage)).size() > 0) {
                    pageCallback.execute(pageList, pageNo, pageSize, totalPage);
                }
                if (pageNo >= totalPage) break;
                ++pageNo;
            }
        }
    }

    private static <T> List<T> getPageList(List<T> list, int pageNo, int pageSize, int totalPage) {
        int fromIndex = 0;
        int toIndex = 0;
        if (list == null || list.size() == 0) {
            return new ArrayList();
        }
        if (pageNo <= totalPage && pageNo != 0) {
            fromIndex = (pageNo - 1) * pageSize;
            toIndex = pageNo == totalPage ? list.size() : pageNo * pageSize;
        }
        return list.subList(fromIndex, toIndex);
    }

    public static <T> List<T> listOrderBy(List<T> list, String orderBy) {
        String[] ss;
        if (list != null && StringUtils.isNotBlank((CharSequence)orderBy) && (ss = orderBy.trim().split(" ")) != null) {
            final String t = ss.length == 2 ? ss[1] : "asc";
            Collections.sort(list, new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    String s1 = "";
                    String s2 = "";
                    if (o1 instanceof Map) {
                        s1 = ObjectUtils.toString(((Map)o1).get(ss[0]));
                        s2 = ObjectUtils.toString(((Map)o2).get(ss[0]));
                    } else {
                        s1 = ObjectUtils.toString(ReflectUtils.invokeGetter(o1, ss[0]));
                        s2 = ObjectUtils.toString(ReflectUtils.invokeGetter(o2, ss[0]));
                    }
                    if ("asc".equalsIgnoreCase(t)) {
                        return s1.compareTo(s2);
                    }
                    return s2.compareTo(s1);
                }
            });
        }
        return list;
    }
}

