/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.lang;

import com.jeesite.common.codec.EncodeUtils;
import com.jeesite.common.collect.ListUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    private static final char SEPARATOR = '_';
    private static final String CHARSET_NAME = "UTF-8";
    private static Pattern p1 = Pattern.compile("<([a-zA-Z]+)[^<>]*>");

    public static byte[] getBytes(String str) {
        if (str != null) {
            try {
                return str.getBytes(CHARSET_NAME);
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return null;
    }

    public static String toString(byte[] bytes) {
        try {
            return new String(bytes, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static boolean inString(String str, String ... strs) {
        if (str != null && strs != null) {
            for (String s : strs) {
                if (!str.equals(StringUtils.trim((String)s))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean inStringIgnoreCase(String str, String ... strs) {
        if (str != null && strs != null) {
            for (String s : strs) {
                if (!str.equalsIgnoreCase(StringUtils.trim((String)s))) continue;
                return true;
            }
        }
        return false;
    }

    public static String stripHtml(String html) {
        if (StringUtils.isBlank((CharSequence)html)) {
            return "";
        }
        String regEx = "<.+?>";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(html);
        String s = m.replaceAll("");
        return s;
    }

    public static String toMobileHtml(String html) {
        if (html == null) {
            return "";
        }
        return html.replaceAll("<([a-z]+?)\\s+?.*?>", "<$1>");
    }

    public static String toHtml(String txt) {
        if (txt == null) {
            return "";
        }
        return StringUtils.replace((String)StringUtils.replace((String)EncodeUtils.encodeHtml(StringUtils.trim((String)txt)), (String)"\n", (String)"<br/>"), (String)"\t", (String)"&nbsp; &nbsp; ");
    }

    public static String abbr(String str, int length) {
        if (str == null) {
            return "";
        }
        try {
            StringBuilder sb = new StringBuilder();
            int currentLength = 0;
            for (char c : StringUtils.stripHtml(EncodeUtils.decodeHtml(str)).toCharArray()) {
                if ((currentLength += String.valueOf(c).getBytes("GBK").length) > length - 3) {
                    sb.append("...");
                    break;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String htmlAbbr(String param, int length) {
        if (param == null) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        int n = 0;
        boolean isCode = false;
        boolean isHTML = false;
        for (int i = 0; i < param.length(); ++i) {
            char temp = param.charAt(i);
            if (temp == '<') {
                isCode = true;
            } else if (temp == '&') {
                isHTML = true;
            } else if (temp == '>' && isCode) {
                --n;
                isCode = false;
            } else if (temp == ';' && isHTML) {
                isHTML = false;
            }
            try {
                if (!isCode && !isHTML) {
                    n += String.valueOf(temp).getBytes("GBK").length;
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (n > length - 3) {
                result.append("...");
                break;
            }
            result.append(temp);
        }
        String tempResult = result.toString().replaceAll("(>)[^<>]*(<?)", "$1$2");
        tempResult = tempResult.replaceAll("</?(AREA|BASE|BASEFONT|BODY|BR|COL|COLGROUP|DD|DT|FRAME|HEAD|HR|HTML|IMG|INPUT|ISINDEX|LI|LINK|META|OPTION|P|PARAM|TBODY|TD|TFOOT|TH|THEAD|TR|area|base|basefont|body|br|col|colgroup|dd|dt|frame|head|hr|html|img|input|isindex|li|link|meta|option|p|param|tbody|td|tfoot|th|thead|tr)[^<>]*/?>", "");
        tempResult = tempResult.replaceAll("<([a-zA-Z]+)[^<>]*>(.*?)</\\1>", "$2");
        Matcher m = p1.matcher(tempResult);
        ArrayList<String> endHTML = ListUtils.newArrayList();
        while (m.find()) {
            endHTML.add(m.group(1));
        }
        for (int i = endHTML.size() - 1; i >= 0; --i) {
            result.append("</");
            result.append((String)endHTML.get(i));
            result.append(">");
        }
        return result.toString();
    }

    public static String cap(String str) {
        return StringUtils.capitalize((String)str);
    }

    public static String uncap(String str) {
        return StringUtils.uncapitalize((String)str);
    }

    public static String camelCase(String s) {
        if (s == null) {
            return null;
        }
        s = s.toLowerCase();
        StringBuilder sb = new StringBuilder(s.length());
        boolean upperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_') {
                upperCase = i != 1;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String capCamelCase(String s) {
        if (s == null) {
            return null;
        }
        s = StringUtils.camelCase(s);
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String uncamelCase(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean upperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            boolean nextUpperCase = true;
            if (i < s.length() - 1) {
                nextUpperCase = Character.isUpperCase(s.charAt(i + 1));
            }
            if (i > 0 && Character.isUpperCase(c)) {
                if (!upperCase || !nextUpperCase) {
                    sb.append('_');
                }
                upperCase = true;
            } else {
                upperCase = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String jsGetVal(String objectString) {
        StringBuilder result = new StringBuilder();
        StringBuilder val = new StringBuilder();
        String[] vals = StringUtils.split((String)objectString, (String)".");
        for (int i = 0; i < vals.length; ++i) {
            val.append("." + vals[i]);
            result.append("!" + val.substring(1) + "?'':");
        }
        result.append(val.substring(1));
        return result.toString();
    }

    public static String getRandomStr(int count) {
        char[] codeSeq = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        Random random = new Random();
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            String r = String.valueOf(codeSeq[random.nextInt(codeSeq.length)]);
            s.append(r);
        }
        return s.toString();
    }

    public static String getRandomNum(int count) {
        char[] codeSeq = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        Random random = new Random();
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            String r = String.valueOf(codeSeq[random.nextInt(codeSeq.length)]);
            s.append(r);
        }
        return s.toString();
    }

    public static String getTreeNodeName(String isShowCode, String code, String name) {
        if ("true".equals(isShowCode) || "1".equals(isShowCode)) {
            return "(" + code + ") " + StringUtils.replace((String)name, (String)" ", (String)"");
        }
        if ("2".equals(isShowCode)) {
            return StringUtils.replace((String)name, (String)" ", (String)"") + " (" + code + ")";
        }
        return StringUtils.replace((String)name, (String)" ", (String)"");
    }
}

