/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.lang;

import com.jeesite.common.lang.DateUtils;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;

public class TimeUtils {
    public static final int SECOND = 0;
    public static final int MINUTE = 1;
    public static final int HOUR = 2;
    public static final int DAY = 3;
    private final int[] maxFields = new int[]{59, 59, 23, 0x7FFFFFFE};
    private final int[] minFields = new int[]{0, 0, 0, Integer.MIN_VALUE};
    private String timeSeparator = ":";
    private int[] fields = new int[4];

    public static String formatDateAgo(long dateTime) {
        StringBuilder sb = new StringBuilder();
        if (dateTime < 1000L) {
            sb.append(dateTime).append("\u6beb\u79d2");
        } else {
            TimeUtils t = new TimeUtils(dateTime);
            int day = t.get(3);
            int hour = t.get(2);
            int minute = t.get(1);
            int second = t.get(0);
            if (day > 365) {
                return DateUtils.formatDate(new Date(dateTime), "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2");
            }
            if (day > 0) {
                sb.append(day).append("\u5929");
            }
            if (hour > 0) {
                sb.append(hour).append("\u65f6");
            }
            if (minute > 0) {
                sb.append(minute).append("\u5206");
            }
            if (second > 0) {
                sb.append(second).append("\u79d2");
            }
        }
        return sb.toString();
    }

    public static String formatTimeAgo(String dateTime) {
        return TimeUtils.formatTimeAgo(DateUtils.parseDate(dateTime));
    }

    public static String formatTimeAgo(Date dateTime) {
        String interval = null;
        long time = System.currentTimeMillis() - dateTime.getTime();
        if (time / 1000L < 10L && time / 1000L >= 0L) {
            interval = "\u521a\u521a";
        } else if (time / 3600000L < 96L && time / 3600000L >= 24L) {
            int d = (int)(time / 86400000L);
            interval = d + "\u5929\u524d";
        } else if (time / 3600000L < 24L && time / 3600000L >= 1L) {
            int h = (int)(time / 3600000L);
            interval = h + "\u5c0f\u65f6\u524d";
        } else if (time / 60000L < 60L && time / 60000L >= 1L) {
            int m = (int)(time % 3600000L / 60000L);
            interval = m + "\u5206\u949f\u524d";
        } else if (time / 1000L < 60L && time / 1000L >= 10L) {
            int se = (int)(time % 60000L / 1000L);
            interval = se + "\u79d2\u524d";
        } else {
            interval = DateUtils.formatDate(dateTime, "yyyy-MM-dd");
        }
        return interval;
    }

    public TimeUtils() {
        this(0, 0, 0, 0);
    }

    public TimeUtils(int hour, int minute) {
        this(0, hour, minute, 0);
    }

    public TimeUtils(int hour, int minute, int second) {
        this(0, hour, minute, second);
    }

    public TimeUtils(String time) {
        this(time, null);
    }

    public TimeUtils(long time) {
        this(new Date(time));
    }

    public TimeUtils(Date date) {
        this(DateFormatUtils.formatUTC((Date)date, (String)"HH:mm:ss"));
    }

    public TimeUtils(int day, int hour, int minute, int second) {
        this.initialize(day, hour, minute, second);
    }

    public TimeUtils(String time, String timeSeparator) {
        if (timeSeparator != null) {
            this.setTimeSeparator(timeSeparator);
        }
        this.parseTime(time);
    }

    public void set(int field, int value) {
        if (value < this.minFields[field]) {
            throw new IllegalArgumentException(value + ", time value must be positive.");
        }
        this.fields[field] = value % (this.maxFields[field] + 1);
        int carry = value / (this.maxFields[field] + 1);
        if (carry > 0) {
            int upFieldValue = this.get(field + 1);
            this.set(field + 1, upFieldValue + carry);
        }
    }

    public int get(int field) {
        if (field < 0 || field > this.fields.length - 1) {
            throw new IllegalArgumentException(field + ", field value is error.");
        }
        return this.fields[field];
    }

    public TimeUtils addTime(TimeUtils time) {
        TimeUtils result = new TimeUtils();
        int up = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            int sum = this.fields[i] + time.fields[i] + up;
            up = sum / (this.maxFields[i] + 1);
            result.fields[i] = sum % (this.maxFields[i] + 1);
        }
        return result;
    }

    public TimeUtils subtractTime(TimeUtils time) {
        TimeUtils result = new TimeUtils();
        int down = 0;
        int k = this.fields.length - 1;
        for (int i = 0; i < k; ++i) {
            int difference = this.fields[i] + down;
            if (difference >= time.fields[i]) {
                difference -= time.fields[i];
                down = 0;
            } else {
                difference += this.maxFields[i] + 1 - time.fields[i];
                down = -1;
            }
            result.fields[i] = difference;
        }
        result.fields[3] = this.fields[3] - time.fields[3] + down;
        return result;
    }

    public String getTimeSeparator() {
        return this.timeSeparator;
    }

    public void setTimeSeparator(String timeSeparator) {
        this.timeSeparator = timeSeparator;
    }

    private void initialize(int day, int hour, int minute, int second) {
        this.set(3, day);
        this.set(2, hour);
        this.set(1, minute);
        this.set(0, second);
    }

    private void parseTime(String time) {
        if (time == null) {
            this.initialize(0, 0, 0, 0);
            return;
        }
        String t = time;
        int field = 3;
        this.set(field--, 0);
        int p = -1;
        while ((p = t.indexOf(this.timeSeparator)) > -1) {
            this.parseTimeField(time, t.substring(0, p), field--);
            t = t.substring(p + this.timeSeparator.length());
        }
        this.parseTimeField(time, t, field--);
    }

    private void parseTimeField(String time, String t, int field) {
        if (field < 0 || t.length() < 1) {
            this.parseTimeException(time);
        }
        char[] chs = t.toCharArray();
        int n = 0;
        for (int i = 0; i < chs.length; ++i) {
            if (chs[i] <= ' ') continue;
            if (chs[i] >= '0' && chs[i] <= '9') {
                n = n * 10 + chs[i] - 48;
                continue;
            }
            this.parseTimeException(time);
        }
        this.set(field, n);
    }

    private void parseTimeException(String time) {
        throw new IllegalArgumentException(time + ", time format error, HH" + this.timeSeparator + "mm" + this.timeSeparator + "ss");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append(this.fields[3]).append(',').append(' ');
        this.buildString(sb, 2).append(this.timeSeparator);
        this.buildString(sb, 1).append(this.timeSeparator);
        this.buildString(sb, 0);
        return sb.toString();
    }

    private StringBuilder buildString(StringBuilder sb, int field) {
        if (this.fields[field] < 10) {
            sb.append('0');
        }
        return sb.append(this.fields[field]);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.fields);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeUtils other = (TimeUtils)obj;
        return Arrays.equals(this.fields, other.fields);
    }
}

