/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.mapper;

import com.jeesite.common.lang.ExceptionUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.reflect.ReflectUtils;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.namespace.QName;

public class JaxbMapper {
    private static ConcurrentMap<Class, JAXBContext> jaxbContexts = new ConcurrentHashMap<Class, JAXBContext>();

    public static String toXml(Object root) {
        Class<?> clazz = ReflectUtils.getUserClass(root);
        return JaxbMapper.toXml(root, clazz, null);
    }

    public static String toXml(Object root, String encoding) {
        Class<?> clazz = ReflectUtils.getUserClass(root);
        return JaxbMapper.toXml(root, clazz, encoding);
    }

    public static String toXml(Object root, Class clazz, String encoding) {
        try {
            StringWriter writer = new StringWriter();
            JaxbMapper.createMarshaller(clazz, encoding).marshal(root, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw ExceptionUtils.unchecked((Exception)((Object)e));
        }
    }

    public static String toXml(Collection<?> root, String rootName, Class clazz) {
        return JaxbMapper.toXml(root, rootName, clazz, null);
    }

    public static String toXml(Collection<?> root, String rootName, Class clazz, String encoding) {
        try {
            CollectionWrapper wrapper = new CollectionWrapper();
            wrapper.collection = root;
            JAXBElement wrapperElement = new JAXBElement(new QName(rootName), CollectionWrapper.class, (Object)wrapper);
            StringWriter writer = new StringWriter();
            JaxbMapper.createMarshaller(clazz, encoding).marshal((Object)wrapperElement, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw ExceptionUtils.unchecked((Exception)((Object)e));
        }
    }

    public static <T> T fromXml(String xml, Class<T> clazz) {
        try {
            StringReader reader = new StringReader(xml);
            return (T)JaxbMapper.createUnmarshaller(clazz).unmarshal((Reader)reader);
        }
        catch (JAXBException e) {
            throw ExceptionUtils.unchecked((Exception)((Object)e));
        }
    }

    public static Marshaller createMarshaller(Class clazz, String encoding) {
        try {
            JAXBContext jaxbContext = JaxbMapper.getJaxbContext(clazz);
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            if (StringUtils.isNotBlank((CharSequence)encoding)) {
                marshaller.setProperty("jaxb.encoding", (Object)encoding);
            }
            return marshaller;
        }
        catch (JAXBException e) {
            throw ExceptionUtils.unchecked((Exception)((Object)e));
        }
    }

    public static Unmarshaller createUnmarshaller(Class clazz) {
        try {
            JAXBContext jaxbContext = JaxbMapper.getJaxbContext(clazz);
            return jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw ExceptionUtils.unchecked((Exception)((Object)e));
        }
    }

    protected static JAXBContext getJaxbContext(Class clazz) {
        if (clazz == null) {
            throw new RuntimeException("'clazz' must not be null");
        }
        JAXBContext jaxbContext = (JAXBContext)jaxbContexts.get(clazz);
        if (jaxbContext == null) {
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz, CollectionWrapper.class});
                jaxbContexts.putIfAbsent(clazz, jaxbContext);
            }
            catch (JAXBException ex) {
                throw new RuntimeException("Could not instantiate JAXBContext for class [" + clazz + "]: " + ex.getMessage(), ex);
            }
        }
        return jaxbContext;
    }

    public static class CollectionWrapper {
        @XmlAnyElement
        protected Collection<?> collection;
    }
}

