/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public class XmlMapper
extends com.fasterxml.jackson.dataformat.xml.XmlMapper {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(XmlMapper.class);

    public XmlMapper() {
        new Jackson2ObjectMapperBuilder().configure((ObjectMapper)this);
        this.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
    }

    public String toXmlString(Object object) {
        try {
            return this.writeValueAsString(object);
        }
        catch (IOException e) {
            logger.warn("write to xml string error:" + object, (Throwable)e);
            return null;
        }
    }

    public <T> T fromXmlString(String xmlString, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)xmlString) || "<CLOB>".equals(xmlString)) {
            return null;
        }
        try {
            return (T)this.readValue(xmlString, clazz);
        }
        catch (IOException e) {
            logger.warn("parse xml string error:" + xmlString, (Throwable)e);
            return null;
        }
    }

    public static XmlMapper getInstance() {
        return XmlMapperHolder.INSTANCE;
    }

    public static String toXml(Object object) {
        return XmlMapper.getInstance().toXmlString(object);
    }

    public static <T> T fromXml(String jsonString, Class<?> clazz) {
        return (T)XmlMapper.getInstance().fromXmlString(jsonString, clazz);
    }

    public static Map<String, Object> xmlToMap(String xmlStr, boolean needRootKey) {
        try {
            Document doc = DocumentHelper.parseText((String)xmlStr);
            Element root = doc.getRootElement();
            Map map = (Map)XmlMapper.xmlToMap(root);
            if (root.elements().size() == 0 && root.attributes().size() == 0) {
                return map;
            }
            if (needRootKey) {
                HashMap<String, Object> rootMap = new HashMap<String, Object>();
                rootMap.put(root.getName(), map);
                return rootMap;
            }
            return map;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> xmlToMapWithAttr(String xmlStr, boolean needRootKey) {
        try {
            Document doc = DocumentHelper.parseText((String)xmlStr);
            Element root = doc.getRootElement();
            Map map = (Map)XmlMapper.xmlToMapWithAttr(root);
            if (root.elements().size() == 0 && root.attributes().size() == 0) {
                return map;
            }
            if (needRootKey) {
                HashMap<String, Object> rootMap = new HashMap<String, Object>();
                rootMap.put(root.getName(), map);
                return rootMap;
            }
            return map;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object xmlToMap(Element element) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        List elements = element.elements();
        if (elements.size() == 0) {
            map.put(element.getName(), element.getText());
            if (!element.isRootElement()) {
                return element.getText();
            }
        } else if (elements.size() == 1) {
            map.put(((Element)elements.get(0)).getName(), XmlMapper.xmlToMap((Element)elements.get(0)));
        } else if (elements.size() > 1) {
            LinkedHashMap<String, Element> tempMap = new LinkedHashMap<String, Element>();
            for (Element ele : elements) {
                tempMap.put(ele.getName(), ele);
            }
            Set keySet = tempMap.keySet();
            for (String string : keySet) {
                Namespace namespace;
                List elements2 = element.elements(new QName(string, namespace = ((Element)tempMap.get(string)).getNamespace()));
                if (elements2.size() > 1) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (Element ele : elements2) {
                        list.add(XmlMapper.xmlToMap(ele));
                    }
                    map.put(string, list);
                    continue;
                }
                map.put(string, XmlMapper.xmlToMap((Element)elements2.get(0)));
            }
        }
        return map;
    }

    private static Object xmlToMapWithAttr(Element element) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        List elements = element.elements();
        List listAttr = element.attributes();
        boolean hasAttributes = false;
        for (Object attr : listAttr) {
            hasAttributes = true;
            map.put("@" + attr.getName(), attr.getValue());
        }
        if (elements.size() == 0) {
            if (hasAttributes) {
                map.put("#text", element.getText());
            } else {
                map.put(element.getName(), element.getText());
            }
            if (!element.isRootElement() && !hasAttributes) {
                return element.getText();
            }
        } else if (elements.size() == 1) {
            map.put(((Element)elements.get(0)).getName(), XmlMapper.xmlToMapWithAttr((Element)elements.get(0)));
        } else if (elements.size() > 1) {
            LinkedHashMap<String, Element> tempMap = new LinkedHashMap<String, Element>();
            for (Element ele : elements) {
                tempMap.put(ele.getName(), ele);
            }
            Set keySet = tempMap.keySet();
            for (String string : keySet) {
                Namespace namespace;
                List elements2 = element.elements(new QName(string, namespace = ((Element)tempMap.get(string)).getNamespace()));
                if (elements2.size() > 1) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (Element ele : elements2) {
                        list.add(XmlMapper.xmlToMapWithAttr(ele));
                    }
                    map.put(string, list);
                    continue;
                }
                map.put(string, XmlMapper.xmlToMapWithAttr((Element)elements2.get(0)));
            }
        }
        return map;
    }

    private static final class XmlMapperHolder {
        private static final XmlMapper INSTANCE = new XmlMapper();

        private XmlMapperHolder() {
        }
    }
}

