/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.ueditor.define;

import com.jeesite.common.ueditor.Encoder;
import com.jeesite.common.ueditor.define.AppInfo;
import com.jeesite.common.ueditor.define.State;
import java.util.HashMap;
import java.util.Map;

public class BaseState
implements State {
    private boolean state = false;
    private String info = null;
    private Map<String, String> infoMap = new HashMap<String, String>();

    public BaseState() {
        this.state = true;
    }

    public BaseState(boolean state) {
        this.setState(state);
    }

    public BaseState(boolean state, String info) {
        this.setState(state);
        this.info = info;
    }

    public BaseState(boolean state, int infoCode) {
        this.setState(state);
        this.info = AppInfo.getStateInfo(infoCode);
    }

    @Override
    public boolean isSuccess() {
        return this.state;
    }

    public void setState(boolean state) {
        this.state = state;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public void setInfo(int infoCode) {
        this.info = AppInfo.getStateInfo(infoCode);
    }

    @Override
    public String toJSONString() {
        return this.toString();
    }

    public String toString() {
        String key2 = null;
        String stateVal = this.isSuccess() ? AppInfo.getStateInfo(0) : this.info;
        StringBuilder builder = new StringBuilder();
        builder.append("{\"state\": \"" + stateVal + "\"");
        for (String key2 : this.infoMap.keySet()) {
            builder.append(",\"" + key2 + "\": \"" + this.infoMap.get(key2) + "\"");
        }
        builder.append("}");
        return Encoder.toUnicode(builder.toString());
    }

    @Override
    public void putInfo(String name, String val) {
        this.infoMap.put(name, val);
    }

    @Override
    public void putInfo(String name, long val) {
        this.putInfo(name, val + "");
    }
}

